/*
 * Decompiled with CFR 0.152.
 */
package Engine;

import Engine.Board;
import Engine.MapMain;
import enemiesClass.Enemies;
import exceptions.GameException;
import java.awt.EventQueue;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import javax.swing.JFrame;
import mapClass.MakeMaps;

public class Animator
extends JFrame {
    public static int gameSize = 1;
    public static final int imgSize = 16;
    static final int rowX = 16;
    static final int rowY = 12;
    public static int pixMulti = 4 * gameSize;
    public static int scale = 16 * pixMulti;
    public static int scaleSpeed = pixMulti / 4;
    private static final long serialVersionUID = 5235596323033775173L;
    public static int screenW = 1024 * gameSize;
    public static int screenH = 768 * gameSize;
    public static int timerCounter = 30;
    public static Boolean playsouds = true;
    public static Boolean adminCommands = true;
    public static Boolean heroImortal = false;
    public static int[] itemAmts = new int[]{1, 3, 5, 10, 15, 20, 25, 30, 35, 40, 50, 75, 100};
    public static int[] itemCoinAmts = new int[]{1, 5, 10, 20, 50, 100};
    private static Random rand = new Random();
    private static ArrayList<tilesSearchItems> tilesSearchAry2 = new ArrayList();
    private static HashMap<Integer, mapSaveItem> mapSaveItems = new HashMap();
    private static transferTile[] transferTiles = new transferTile[]{new transferTile(1, new Point(12, 48), 3, new Point(15, 15), false), new transferTile(3, new Point(15, 16), 1, new Point(12, 49), false), new transferTile(3, new Point(36, 3), 4, new Point(35, 15), false), new transferTile(4, new Point(36, 15), 3, new Point(35, 3), false)};
    private static String[] weaponNames = new String[]{"None", "Combat Knife", "Handgun", "Shotgun", "Lasergun", "Flame Thrower", "Missle Luncher"};
    public static HashMap<String, Integer> heroSecItemIndexLocs = new HashMap<String, Integer>(){
        private static final long serialVersionUID = 1L;
        {
            this.put("C4", 1);
            this.put("Syringe", 2);
            this.put("Shield", 3);
            this.put("Hookshot", 4);
            this.put("IceBoots", 5);
            this.put("MudBoots", 6);
            this.put("Helmet", 7);
            this.put("Orb", 8);
        }
    };
    private static Board board;
    private static Enemies enemy;
    static JFrame ex;

    public static void checkmapSaveItems(int mapNum) {
        if (!mapSaveItems.containsKey(mapNum)) {
            mapSaveItems.put(mapNum, new mapSaveItem());
        }
    }

    public static int[] doAnimation(AnimationItems aniItem, String aniName, MapMain mapTile) {
        if (aniItem.itemAniPauseCounter == 0) {
            if (aniItem.itemAniCounter % aniItem.itemAniSpeed == 0) {
                aniItem.imageLoc = aniItem.imageLocArray.get(aniItem.itemAniSpriteNum);
                if (aniItem.itemAniType == 1) {
                    aniItem.itemAniSpriteNum += aniItem.itemAniSpriteNumInc;
                    if (aniItem.itemAniSpriteNum == aniItem.imageLocArray.size()) {
                        aniItem.itemAniSpriteNum = 0;
                        aniItem.itemAniPauseCounter = 1;
                    }
                } else if (aniItem.itemAniType == 2) {
                    if (aniItem.itemAniSpriteNumInc == 1 && aniItem.itemAniSpriteNum == aniItem.imageLocArray.size() - 1) {
                        aniItem.itemAniPauseCounter = 1;
                        aniItem.itemAniSpriteNumInc = -1;
                    } else if (aniItem.itemAniSpriteNumInc == -1 && aniItem.itemAniSpriteNum == 0) {
                        aniItem.itemAniPauseCounter = 1;
                        aniItem.itemAniSpriteNumInc = 1;
                    }
                    aniItem.itemAniSpriteNum += aniItem.itemAniSpriteNumInc;
                }
            }
            ++aniItem.itemAniCounter;
            if (aniItem.itemAniCounter >= aniItem.itemAniSpeed) {
                aniItem.itemAniCounter = 0;
            }
        } else {
            ++aniItem.itemAniPauseCounter;
            if (aniItem.itemAniPauseCounter > aniItem.itemAniPause) {
                aniItem.itemAniPauseCounter = 0;
                if (aniName.equals("w.") || aniName.equals("w%")) {
                    int ranNum = rand.nextInt(500);
                    aniItem.itemAniPause = ranNum + 180;
                    mapTile.getHeroDistance(100);
                }
            }
        }
        return aniItem.imageLoc;
    }

    public static int[] getSpriteLoc(int type, int index) {
        int[] ret = new int[4];
        if (type == 1) {
            switch (index) {
                case 0: {
                    ret[0] = 48;
                    ret[1] = 80;
                    ret[2] = 64;
                    ret[3] = 96;
                    break;
                }
                case 1: {
                    ret[0] = 80;
                    ret[1] = 64;
                    ret[2] = 96;
                    ret[3] = 80;
                    break;
                }
                case 2: {
                    ret[0] = 0;
                    ret[1] = 48;
                    ret[2] = 16;
                    ret[3] = 64;
                    break;
                }
                case 3: {
                    ret[0] = 48;
                    ret[1] = 48;
                    ret[2] = 64;
                    ret[3] = 64;
                    break;
                }
                case 4: {
                    ret[0] = 112;
                    ret[1] = 48;
                    ret[2] = 128;
                    ret[3] = 64;
                    break;
                }
                case 5: {
                    ret[0] = 96;
                    ret[1] = 48;
                    ret[2] = 112;
                    ret[3] = 64;
                    break;
                }
                case 6: {
                    ret[0] = 80;
                    ret[1] = 48;
                    ret[2] = 96;
                    ret[3] = 64;
                }
            }
        } else if (type == 2) {
            switch (index) {
                case 0: {
                    ret[0] = 48;
                    ret[1] = 80;
                    ret[2] = 64;
                    ret[3] = 96;
                    break;
                }
                case 1: {
                    ret[0] = 48;
                    ret[1] = 80;
                    ret[2] = 64;
                    ret[3] = 96;
                    break;
                }
                case 2: {
                    ret[0] = 16;
                    ret[1] = 32;
                    ret[2] = 32;
                    ret[3] = 48;
                    break;
                }
                case 3: {
                    ret[0] = 64;
                    ret[1] = 96;
                    ret[2] = 80;
                    ret[3] = 112;
                    break;
                }
                case 4: {
                    ret[0] = 112;
                    ret[1] = 96;
                    ret[2] = 128;
                    ret[3] = 112;
                    break;
                }
                case 5: {
                    ret[0] = 112;
                    ret[1] = 32;
                    ret[2] = 128;
                    ret[3] = 48;
                    break;
                }
                case 6: {
                    ret[0] = 48;
                    ret[1] = 16;
                    ret[2] = 64;
                    ret[3] = 32;
                }
            }
        } else if (type == 3) {
            switch (index) {
                case 0: {
                    ret[0] = 0;
                    ret[1] = 0;
                    ret[2] = 16;
                    ret[3] = 16;
                    break;
                }
                case 1: {
                    ret[0] = 32;
                    ret[1] = 0;
                    ret[2] = 48;
                    ret[3] = 16;
                    break;
                }
                case 2: {
                    ret[0] = 16;
                    ret[1] = 0;
                    ret[2] = 32;
                    ret[3] = 16;
                    break;
                }
                case 3: {
                    ret[0] = 112;
                    ret[1] = 96;
                    ret[2] = 128;
                    ret[3] = 112;
                    break;
                }
                case 4: {
                    ret[0] = 48;
                    ret[1] = 0;
                    ret[2] = 64;
                    ret[3] = 16;
                }
            }
        }
        return ret;
    }

    public static int rectTouching(Rectangle rect1, Rectangle rect2) {
        if (rect1.x + rect1.width == rect2.x && rect1.y + rect1.height >= rect2.y && rect1.y <= rect2.y + rect2.height) {
            return 4;
        }
        if (rect2.x + rect2.width == rect1.x && rect1.y + rect1.height >= rect2.y && rect1.y <= rect2.y + rect2.height) {
            return 2;
        }
        if (rect1.y == rect2.y + rect2.height && rect1.x + rect1.width >= rect2.x && rect1.x <= rect2.x + rect2.width) {
            return 1;
        }
        if (rect1.y + rect1.height == rect2.y && rect1.x + rect1.width >= rect2.x && rect1.x <= rect2.x + rect2.width) {
            return 3;
        }
        return 0;
    }

    public static String heroSecItemIndexLocsKeyByValue(int value) {
        for (Map.Entry<String, Integer> entry : heroSecItemIndexLocs.entrySet()) {
            if (entry.getValue() != value) continue;
            return entry.getKey();
        }
        return null;
    }

    private static void makeMapTilesRefs() {
        try {
            String line;
            InputStream is = MakeMaps.class.getResourceAsStream("/mapFiles/mapTileRef");
            BufferedReader reader = new BufferedReader(new InputStreamReader(is));
            while ((line = reader.readLine()) != null) {
                String[] word = line.split("~");
                if (word[0].substring(0, 2).equals("//")) continue;
                int sizeX = 1;
                int sizeY = 1;
                int mapNum = 0;
                Boolean touchable = false;
                Boolean seeThough = false;
                int shadowX = -1;
                int shadowY = -1;
                int L4PointX = -1;
                int L4PointY = -1;
                ArrayList imageLocArray = new ArrayList();
                int arrayEnd = 0;
                int i = word.length - 1;
                while (i > 3) {
                    String tempString;
                    if (word[i].substring(0, 1).equals("#")) {
                        tempString = word[i].replace("#", "");
                        mapNum = Integer.parseInt(tempString);
                        ++arrayEnd;
                    } else if (word[i].substring(0, 1).equals("X")) {
                        tempString = word[i].replace("X", "");
                        sizeX = Integer.parseInt(tempString);
                        ++arrayEnd;
                    } else if (word[i].substring(0, 1).equals("Y")) {
                        tempString = word[i].replace("Y", "");
                        sizeY = Integer.parseInt(tempString);
                        ++arrayEnd;
                    } else if (word[i].substring(0, 1).equals("T")) {
                        touchable = true;
                        ++arrayEnd;
                    } else if (word[i].substring(0, 1).equals("S")) {
                        seeThough = true;
                        ++arrayEnd;
                    } else if (word[i].substring(0, 1).equals("A")) {
                        tempString = word[i].replace("A", "");
                        shadowY = Integer.parseInt(tempString);
                        ++arrayEnd;
                    } else if (word[i].substring(0, 1).equals("B")) {
                        tempString = word[i].replace("B", "");
                        shadowX = Integer.parseInt(tempString);
                        ++arrayEnd;
                    } else if (word[i].substring(0, 1).equals("C")) {
                        tempString = word[i].replace("C", "");
                        L4PointY = Integer.parseInt(tempString);
                        ++arrayEnd;
                    } else if (word[i].substring(0, 1).equals("D")) {
                        tempString = word[i].replace("D", "");
                        L4PointX = Integer.parseInt(tempString);
                        ++arrayEnd;
                    }
                    --i;
                }
                ArrayList<int[]> mapSpotArrays = new ArrayList<int[]>();
                int i2 = 2;
                while (i2 < word.length - arrayEnd) {
                    int[] tempAry2 = new int[]{(Integer.parseInt(word[i2 + 1]) - 1) * 16, (Integer.parseInt(word[i2]) - 1) * 16, Integer.parseInt(word[i2 + 1]) * 16 + (sizeX - 1) * 16, Integer.parseInt(word[i2]) * 16 + (sizeY - 1) * 16};
                    mapSpotArrays.add(tempAry2);
                    i2 += 2;
                }
                imageLocArray.addAll(mapSpotArrays);
                String tileTag = word[1];
                if (shadowX == -1 && shadowY != -1 || shadowX != -1 && shadowY == -1) {
                    throw new GameException("Sanity check failed in Aniamtor makeMapTilesRefs: ShadowX is " + shadowX + " ShadowY is " + shadowY);
                }
                if (L4PointX == -1 && L4PointY != -1 || L4PointX != -1 && L4PointY == -1) {
                    throw new GameException("Sanity check failed in Aniamtor makeMapTilesRefs: L4PointX is " + L4PointX + " L4PointY is " + L4PointY);
                }
                tilesSearchAry2.add(new tilesSearchItems(tileTag, imageLocArray, mapNum, sizeX, sizeY, touchable, seeThough, shadowX, shadowY, L4PointX, L4PointY));
            }
            reader.close();
        }
        catch (Exception e) {
            System.err.format("Exception occurred trying to read '%s'.", "src/weapons/WeaponsFile");
            e.printStackTrace();
        }
    }

    public Animator() {
        this.initUI();
    }

    private void initUI() {
        this.setResizable(false);
        this.setTitle("HelCrash");
        this.setDefaultCloseOperation(3);
        Animator.makeMapTilesRefs();
        this.add(board);
        this.pack();
        this.setLocationRelativeTo(null);
    }

    public static void main(String[] args) {
        System.setProperty("sun.net.www.protocol.jar.disableCaching", "true");
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                Animator.board = new Board();
                enemy = new Enemies(0, 0);
                ex = new Animator();
                ex.setVisible(true);
            }
        });
    }

    public void setGameSizeVars() {
    }

    public static Board getBoard() {
        return board;
    }

    public static Enemies getEnemies() {
        return enemy;
    }

    public void setGameSize(int gameSize) {
        Animator.gameSize = gameSize;
        pixMulti = 4 * gameSize;
        scale = 16 * pixMulti;
        scaleSpeed = pixMulti / 4;
    }

    public static int[] cutSpriteSheet(int row, int coloumn, int size, Boolean revers) {
        int[] cutout = new int[4];
        if (revers.booleanValue()) {
            cutout[0] = coloumn * size;
            cutout[2] = (coloumn - 1) * size;
        } else {
            cutout[0] = (coloumn - 1) * size;
            cutout[2] = coloumn * size;
        }
        cutout[1] = (row - 1) * size;
        cutout[3] = row * size;
        return cutout;
    }

    public static float findDistance(Point a, Point b) {
        return (float)Math.sqrt(Math.pow(b.x - a.x, 2.0) + Math.pow(b.y - a.y, 2.0));
    }

    public static float[] findTrajectory(Point source, Point target) {
        float distance = Animator.findDistance(source, target);
        float distX = (float)(target.x - source.x) / distance;
        float distY = (float)(target.y - source.y) / distance;
        return new float[]{distX, distY};
    }

    public static int[][] findTrajectoryInt(Point source, Point target, int speed) {
        int i;
        String tempStr;
        int[][] ret = new int[2][10];
        int negX = 1;
        int negY = 1;
        float distance = Animator.findDistance(source, target);
        float distX = (float)(target.x - source.x) / distance;
        float distY = (float)(target.y - source.y) / distance;
        int distXint = Math.round(distX * (float)speed * 10.0f);
        int distYint = Math.round(distY * (float)speed * 10.0f);
        String distXStr = String.valueOf(distXint);
        String distYStr = String.valueOf(distYint);
        if (distXStr.charAt(0) == '-') {
            negX = -1;
            tempStr = "";
            i = 1;
            while (i < distXStr.length()) {
                tempStr = String.valueOf(tempStr) + distXStr.charAt(i);
                ++i;
            }
            distXStr = tempStr;
        }
        if (distXStr.length() == 1) {
            distXStr = "0" + distXStr;
        }
        if (distYStr.charAt(0) == '-') {
            negY = -1;
            tempStr = "";
            i = 1;
            while (i < distYStr.length()) {
                tempStr = String.valueOf(tempStr) + distYStr.charAt(i);
                ++i;
            }
            distYStr = tempStr;
        }
        if (distYStr.length() == 1) {
            distYStr = "0" + distYStr;
        }
        String[] distXSplit = distXStr.split("");
        String[] distYSplit = distYStr.split("");
        distXStr = "";
        distYStr = "";
        int i2 = 0;
        while (i2 < distXSplit.length - 1) {
            distXStr = String.valueOf(distXStr) + distXSplit[i2];
            ++i2;
        }
        i2 = 0;
        while (i2 < distYSplit.length - 1) {
            distYStr = String.valueOf(distYStr) + distYSplit[i2];
            ++i2;
        }
        int distXLast = Integer.valueOf(distXSplit[distXSplit.length - 1]);
        int distYLast = Integer.valueOf(distYSplit[distYSplit.length - 1]);
        int distXnum = Integer.valueOf(distXStr);
        int distYnum = Integer.valueOf(distYStr);
        int countXSmall = 0;
        int countXBig = 0;
        int countYSmall = 0;
        int countYBig = 0;
        int totXSmall = 0;
        int totXBig = 0;
        int totYSmall = 0;
        int totYBig = 0;
        Point distXPoint = Animator.getTrajectoryRaitos(distXLast);
        Point distYPoint = Animator.getTrajectoryRaitos(distYLast);
        int i3 = 0;
        while (i3 < 10) {
            if ((double)countXSmall == distXPoint.getX() || totXSmall >= 10 - distXLast) {
                countXBig = 0;
                ++countXSmall;
            } else if ((double)countXBig == distXPoint.getY() || totXBig >= distXLast) {
                countXSmall = 0;
                ++countXBig;
            }
            if ((double)countXSmall < distXPoint.getX() && totXSmall < 10 - distXLast) {
                ret[0][i3] = distXnum * negX;
                ++countXSmall;
                ++totXSmall;
            } else if ((double)countXBig < distXPoint.getY() && totXBig < distXLast) {
                ret[0][i3] = distXnum * negX + 1 * negX;
                ++countXBig;
                ++totXBig;
            }
            if ((double)countYSmall == distYPoint.getX() || totYSmall >= 10 - distYLast) {
                countYBig = 0;
                ++countYSmall;
            } else if ((double)countYBig == distYPoint.getY() || totYBig >= distYLast) {
                countYSmall = 0;
                ++countYBig;
            }
            if ((double)countYSmall < distYPoint.getX() && totYSmall < 10 - distYLast) {
                ret[1][i3] = distYnum * negY;
                ++countYSmall;
                ++totYSmall;
            } else if ((double)countYBig < distYPoint.getY() && totYBig < distYLast) {
                ret[1][i3] = distYnum * negY + 1 * negY;
                ++countYBig;
                ++totYBig;
            }
            ++i3;
        }
        return ret;
    }

    private static Point getTrajectoryRaitos(int dec) {
        int countSmall = 0;
        int countBig = 0;
        Point counts = new Point(0, 0);
        switch (dec) {
            case 0: {
                countSmall = 10;
                countBig = 0;
                break;
            }
            case 1: {
                countSmall = 9;
                countBig = 1;
                break;
            }
            case 2: {
                countSmall = 4;
                countBig = 1;
                break;
            }
            case 3: {
                countSmall = 2;
                countBig = 1;
                break;
            }
            case 4: {
                countSmall = 2;
                countBig = 1;
                break;
            }
            case 5: {
                countSmall = 1;
                countBig = 1;
                break;
            }
            case 6: {
                countSmall = 1;
                countBig = 2;
                break;
            }
            case 7: {
                countSmall = 1;
                countBig = 2;
                break;
            }
            case 8: {
                countSmall = 1;
                countBig = 4;
                break;
            }
            case 9: {
                countSmall = 1;
                countBig = 9;
            }
        }
        counts.setLocation(countSmall, countBig);
        return counts;
    }

    public static int[] makeSpeedArray(String moveSpeed) {
        int[] moveSpeedAry = new int[10];
        ArrayList indexAry = new ArrayList();
        String[] moveSplit = moveSpeed.split("\\.");
        int wholeNum = Integer.valueOf(moveSplit[0]);
        int decNum = Integer.valueOf(moveSplit[1]);
        if (decNum == 1) {
            Collections.addAll(indexAry, 4);
        } else if (decNum == 2) {
            Collections.addAll(indexAry, 2, 7);
        } else if (decNum == 3) {
            Collections.addAll(indexAry, 2, 5, 8);
        } else if (decNum == 4) {
            Collections.addAll(indexAry, 1, 3, 6, 8);
        } else if (decNum == 5) {
            Collections.addAll(indexAry, 0, 2, 4, 6, 8);
        } else if (decNum == 6) {
            Collections.addAll(indexAry, 0, 2, 4, 5, 7, 9);
        } else if (decNum == 7) {
            Collections.addAll(indexAry, 0, 1, 3, 4, 6, 7, 9);
        } else if (decNum == 8) {
            Collections.addAll(indexAry, 0, 1, 3, 4, 5, 6, 8, 9);
        } else if (decNum == 9) {
            Collections.addAll(indexAry, 0, 1, 2, 3, 5, 6, 7, 8, 9);
        }
        int i = 0;
        while (i < 10) {
            moveSpeedAry[i] = indexAry.contains(i) ? wholeNum + 1 : wholeNum;
            ++i;
        }
        return moveSpeedAry;
    }

    public static short[] convertIntAryToShort(int[] oldint) {
        short[] tempshort = new short[oldint.length];
        int i = 0;
        while (i < oldint.length) {
            tempshort[i] = (short)oldint[i];
            ++i;
        }
        return tempshort;
    }

    public static boolean isPointOutofBound(int x, int y) {
        return x > screenW + scale || x < -scale || y > screenH + scale || y < 0;
    }

    public static Point findCenter(Rectangle sprite) {
        Point point = new Point(0, 0);
        point.x = (int)(sprite.getX() + sprite.getWidth() / 2.0);
        point.y = (int)(sprite.getY() + sprite.getHeight() / 2.0);
        return point;
    }

    public static Point findXYByCenterPoint(Rectangle rect, Point centerPoint) {
        Point XY = new Point(0, 0);
        XY.x = centerPoint.x - rect.width / 2;
        XY.y = centerPoint.y - rect.height / 2;
        return XY;
    }

    public static ArrayList<Point> makeAOEAtkPointsDist(int range) {
        int scaleUnit = scale / 2;
        ArrayList<Point> tempPointAry = new ArrayList<Point>();
        if (range == 5) {
            tempPointAry.add(new Point(scaleUnit * -2, scaleUnit * -5));
            tempPointAry.add(new Point(scaleUnit * -1, scaleUnit * -5));
            tempPointAry.add(new Point(scaleUnit * 0, scaleUnit * -5));
            tempPointAry.add(new Point(scaleUnit * 1, scaleUnit * -5));
            tempPointAry.add(new Point(scaleUnit * 2, scaleUnit * -5));
            tempPointAry.add(new Point(scaleUnit * -2, scaleUnit * -4));
            tempPointAry.add(new Point(scaleUnit * -1, scaleUnit * -4));
            tempPointAry.add(new Point(scaleUnit * 0, scaleUnit * -4));
            tempPointAry.add(new Point(scaleUnit * 1, scaleUnit * -4));
            tempPointAry.add(new Point(scaleUnit * 2, scaleUnit * -4));
            tempPointAry.add(new Point(scaleUnit * -3, scaleUnit * -3));
            tempPointAry.add(new Point(scaleUnit * -2, scaleUnit * -3));
            tempPointAry.add(new Point(scaleUnit * 2, scaleUnit * -3));
            tempPointAry.add(new Point(scaleUnit * 3, scaleUnit * -3));
            tempPointAry.add(new Point(scaleUnit * -5, scaleUnit * -2));
            tempPointAry.add(new Point(scaleUnit * -4, scaleUnit * -2));
            tempPointAry.add(new Point(scaleUnit * -3, scaleUnit * -2));
            tempPointAry.add(new Point(scaleUnit * 3, scaleUnit * -2));
            tempPointAry.add(new Point(scaleUnit * 4, scaleUnit * -2));
            tempPointAry.add(new Point(scaleUnit * 5, scaleUnit * -2));
            tempPointAry.add(new Point(scaleUnit * -5, scaleUnit * -1));
            tempPointAry.add(new Point(scaleUnit * -4, scaleUnit * -1));
            tempPointAry.add(new Point(scaleUnit * 4, scaleUnit * -1));
            tempPointAry.add(new Point(scaleUnit * 5, scaleUnit * -1));
            tempPointAry.add(new Point(scaleUnit * -5, scaleUnit * 0));
            tempPointAry.add(new Point(scaleUnit * -4, scaleUnit * 0));
            tempPointAry.add(new Point(scaleUnit * 4, scaleUnit * 0));
            tempPointAry.add(new Point(scaleUnit * 5, scaleUnit * 0));
            tempPointAry.add(new Point(scaleUnit * -5, scaleUnit * 1));
            tempPointAry.add(new Point(scaleUnit * -4, scaleUnit * 1));
            tempPointAry.add(new Point(scaleUnit * 4, scaleUnit * 1));
            tempPointAry.add(new Point(scaleUnit * 5, scaleUnit * 1));
            tempPointAry.add(new Point(scaleUnit * -5, scaleUnit * 2));
            tempPointAry.add(new Point(scaleUnit * -4, scaleUnit * 2));
            tempPointAry.add(new Point(scaleUnit * -3, scaleUnit * 2));
            tempPointAry.add(new Point(scaleUnit * 3, scaleUnit * 2));
            tempPointAry.add(new Point(scaleUnit * 4, scaleUnit * 2));
            tempPointAry.add(new Point(scaleUnit * 5, scaleUnit * 2));
            tempPointAry.add(new Point(scaleUnit * -3, scaleUnit * 3));
            tempPointAry.add(new Point(scaleUnit * -2, scaleUnit * 3));
            tempPointAry.add(new Point(scaleUnit * 2, scaleUnit * 3));
            tempPointAry.add(new Point(scaleUnit * 3, scaleUnit * 3));
            tempPointAry.add(new Point(scaleUnit * -2, scaleUnit * 4));
            tempPointAry.add(new Point(scaleUnit * -1, scaleUnit * 4));
            tempPointAry.add(new Point(scaleUnit * 0, scaleUnit * 4));
            tempPointAry.add(new Point(scaleUnit * 1, scaleUnit * 4));
            tempPointAry.add(new Point(scaleUnit * 2, scaleUnit * 4));
            tempPointAry.add(new Point(scaleUnit * -2, scaleUnit * 5));
            tempPointAry.add(new Point(scaleUnit * -1, scaleUnit * 5));
            tempPointAry.add(new Point(scaleUnit * 0, scaleUnit * 5));
            tempPointAry.add(new Point(scaleUnit * 1, scaleUnit * 5));
            tempPointAry.add(new Point(scaleUnit * 2, scaleUnit * 5));
        } else if (range == 7) {
            tempPointAry.add(new Point(scaleUnit * -2, scaleUnit * 7));
            tempPointAry.add(new Point(scaleUnit * -1, scaleUnit * 7));
            tempPointAry.add(new Point(scaleUnit * 0, scaleUnit * 7));
            tempPointAry.add(new Point(scaleUnit * 1, scaleUnit * 7));
            tempPointAry.add(new Point(scaleUnit * 2, scaleUnit * 7));
            tempPointAry.add(new Point(scaleUnit * -4, scaleUnit * -6));
            tempPointAry.add(new Point(scaleUnit * -3, scaleUnit * -6));
            tempPointAry.add(new Point(scaleUnit * -2, scaleUnit * -6));
            tempPointAry.add(new Point(scaleUnit * -1, scaleUnit * -6));
            tempPointAry.add(new Point(scaleUnit * 0, scaleUnit * -6));
            tempPointAry.add(new Point(scaleUnit * 1, scaleUnit * -6));
            tempPointAry.add(new Point(scaleUnit * 2, scaleUnit * -6));
            tempPointAry.add(new Point(scaleUnit * 3, scaleUnit * -6));
            tempPointAry.add(new Point(scaleUnit * 4, scaleUnit * -6));
            tempPointAry.add(new Point(scaleUnit * -5, scaleUnit * -5));
            tempPointAry.add(new Point(scaleUnit * -4, scaleUnit * -5));
            tempPointAry.add(new Point(scaleUnit * -3, scaleUnit * -5));
            tempPointAry.add(new Point(scaleUnit * -2, scaleUnit * -5));
            tempPointAry.add(new Point(scaleUnit * -1, scaleUnit * -5));
            tempPointAry.add(new Point(scaleUnit * 0, scaleUnit * -5));
            tempPointAry.add(new Point(scaleUnit * 1, scaleUnit * -5));
            tempPointAry.add(new Point(scaleUnit * 2, scaleUnit * -5));
            tempPointAry.add(new Point(scaleUnit * 3, scaleUnit * -5));
            tempPointAry.add(new Point(scaleUnit * 4, scaleUnit * -5));
            tempPointAry.add(new Point(scaleUnit * 5, scaleUnit * -5));
            tempPointAry.add(new Point(scaleUnit * -6, scaleUnit * -4));
            tempPointAry.add(new Point(scaleUnit * -5, scaleUnit * -4));
            tempPointAry.add(new Point(scaleUnit * -4, scaleUnit * -4));
            tempPointAry.add(new Point(scaleUnit * -3, scaleUnit * -4));
            tempPointAry.add(new Point(scaleUnit * -2, scaleUnit * -4));
            tempPointAry.add(new Point(scaleUnit * -1, scaleUnit * -4));
            tempPointAry.add(new Point(scaleUnit * 0, scaleUnit * -4));
            tempPointAry.add(new Point(scaleUnit * 1, scaleUnit * -4));
            tempPointAry.add(new Point(scaleUnit * 2, scaleUnit * -4));
            tempPointAry.add(new Point(scaleUnit * 3, scaleUnit * -4));
            tempPointAry.add(new Point(scaleUnit * 4, scaleUnit * -4));
            tempPointAry.add(new Point(scaleUnit * 5, scaleUnit * -4));
            tempPointAry.add(new Point(scaleUnit * 6, scaleUnit * -4));
            tempPointAry.add(new Point(scaleUnit * -6, scaleUnit * -3));
            tempPointAry.add(new Point(scaleUnit * -5, scaleUnit * -3));
            tempPointAry.add(new Point(scaleUnit * -4, scaleUnit * -3));
            tempPointAry.add(new Point(scaleUnit * -3, scaleUnit * -3));
            tempPointAry.add(new Point(scaleUnit * -2, scaleUnit * -3));
            tempPointAry.add(new Point(scaleUnit * 2, scaleUnit * -3));
            tempPointAry.add(new Point(scaleUnit * 3, scaleUnit * -3));
            tempPointAry.add(new Point(scaleUnit * 4, scaleUnit * -3));
            tempPointAry.add(new Point(scaleUnit * 5, scaleUnit * -3));
            tempPointAry.add(new Point(scaleUnit * 6, scaleUnit * -3));
            tempPointAry.add(new Point(scaleUnit * 7, scaleUnit * -2));
            tempPointAry.add(new Point(scaleUnit * -6, scaleUnit * -2));
            tempPointAry.add(new Point(scaleUnit * -5, scaleUnit * -2));
            tempPointAry.add(new Point(scaleUnit * -4, scaleUnit * -2));
            tempPointAry.add(new Point(scaleUnit * -3, scaleUnit * -2));
            tempPointAry.add(new Point(scaleUnit * 3, scaleUnit * -2));
            tempPointAry.add(new Point(scaleUnit * 4, scaleUnit * -2));
            tempPointAry.add(new Point(scaleUnit * 5, scaleUnit * -2));
            tempPointAry.add(new Point(scaleUnit * 6, scaleUnit * -2));
            tempPointAry.add(new Point(scaleUnit * 7, scaleUnit * -2));
            tempPointAry.add(new Point(scaleUnit * 7, scaleUnit * -1));
            tempPointAry.add(new Point(scaleUnit * -6, scaleUnit * -1));
            tempPointAry.add(new Point(scaleUnit * -5, scaleUnit * -1));
            tempPointAry.add(new Point(scaleUnit * -4, scaleUnit * -1));
            tempPointAry.add(new Point(scaleUnit * 4, scaleUnit * -1));
            tempPointAry.add(new Point(scaleUnit * 5, scaleUnit * -1));
            tempPointAry.add(new Point(scaleUnit * 6, scaleUnit * -1));
            tempPointAry.add(new Point(scaleUnit * 7, scaleUnit * -1));
            tempPointAry.add(new Point(scaleUnit * 7, scaleUnit * 0));
            tempPointAry.add(new Point(scaleUnit * -6, scaleUnit * 0));
            tempPointAry.add(new Point(scaleUnit * -5, scaleUnit * 0));
            tempPointAry.add(new Point(scaleUnit * -4, scaleUnit * 0));
            tempPointAry.add(new Point(scaleUnit * 4, scaleUnit * 0));
            tempPointAry.add(new Point(scaleUnit * 5, scaleUnit * 0));
            tempPointAry.add(new Point(scaleUnit * 6, scaleUnit * 0));
            tempPointAry.add(new Point(scaleUnit * 7, scaleUnit * 0));
            tempPointAry.add(new Point(scaleUnit * 7, scaleUnit * 1));
            tempPointAry.add(new Point(scaleUnit * -6, scaleUnit * 1));
            tempPointAry.add(new Point(scaleUnit * -5, scaleUnit * 1));
            tempPointAry.add(new Point(scaleUnit * -4, scaleUnit * 1));
            tempPointAry.add(new Point(scaleUnit * 4, scaleUnit * 1));
            tempPointAry.add(new Point(scaleUnit * 5, scaleUnit * 1));
            tempPointAry.add(new Point(scaleUnit * 6, scaleUnit * 1));
            tempPointAry.add(new Point(scaleUnit * 7, scaleUnit * 1));
            tempPointAry.add(new Point(scaleUnit * 7, scaleUnit * 2));
            tempPointAry.add(new Point(scaleUnit * -6, scaleUnit * 2));
            tempPointAry.add(new Point(scaleUnit * -5, scaleUnit * 2));
            tempPointAry.add(new Point(scaleUnit * -4, scaleUnit * 2));
            tempPointAry.add(new Point(scaleUnit * -3, scaleUnit * 2));
            tempPointAry.add(new Point(scaleUnit * 3, scaleUnit * 2));
            tempPointAry.add(new Point(scaleUnit * 4, scaleUnit * 2));
            tempPointAry.add(new Point(scaleUnit * 5, scaleUnit * 2));
            tempPointAry.add(new Point(scaleUnit * 6, scaleUnit * 2));
            tempPointAry.add(new Point(scaleUnit * 7, scaleUnit * 2));
            tempPointAry.add(new Point(scaleUnit * -6, scaleUnit * 3));
            tempPointAry.add(new Point(scaleUnit * -5, scaleUnit * 3));
            tempPointAry.add(new Point(scaleUnit * -4, scaleUnit * 3));
            tempPointAry.add(new Point(scaleUnit * 3, scaleUnit * 3));
            tempPointAry.add(new Point(scaleUnit * -2, scaleUnit * 3));
            tempPointAry.add(new Point(scaleUnit * 2, scaleUnit * 3));
            tempPointAry.add(new Point(scaleUnit * 3, scaleUnit * 3));
            tempPointAry.add(new Point(scaleUnit * 4, scaleUnit * 3));
            tempPointAry.add(new Point(scaleUnit * 5, scaleUnit * 3));
            tempPointAry.add(new Point(scaleUnit * 6, scaleUnit * 3));
            tempPointAry.add(new Point(scaleUnit * -6, scaleUnit * 4));
            tempPointAry.add(new Point(scaleUnit * -5, scaleUnit * 4));
            tempPointAry.add(new Point(scaleUnit * 4, scaleUnit * 4));
            tempPointAry.add(new Point(scaleUnit * -3, scaleUnit * 4));
            tempPointAry.add(new Point(scaleUnit * -2, scaleUnit * 4));
            tempPointAry.add(new Point(scaleUnit * -1, scaleUnit * 4));
            tempPointAry.add(new Point(scaleUnit * 0, scaleUnit * 4));
            tempPointAry.add(new Point(scaleUnit * 1, scaleUnit * 4));
            tempPointAry.add(new Point(scaleUnit * 2, scaleUnit * 4));
            tempPointAry.add(new Point(scaleUnit * 3, scaleUnit * 4));
            tempPointAry.add(new Point(scaleUnit * 4, scaleUnit * 4));
            tempPointAry.add(new Point(scaleUnit * 5, scaleUnit * 4));
            tempPointAry.add(new Point(scaleUnit * 6, scaleUnit * 4));
            tempPointAry.add(new Point(scaleUnit * 5, scaleUnit * 5));
            tempPointAry.add(new Point(scaleUnit * -4, scaleUnit * 5));
            tempPointAry.add(new Point(scaleUnit * -3, scaleUnit * 5));
            tempPointAry.add(new Point(scaleUnit * -2, scaleUnit * 5));
            tempPointAry.add(new Point(scaleUnit * -1, scaleUnit * 5));
            tempPointAry.add(new Point(scaleUnit * 0, scaleUnit * 5));
            tempPointAry.add(new Point(scaleUnit * 1, scaleUnit * 5));
            tempPointAry.add(new Point(scaleUnit * 2, scaleUnit * 5));
            tempPointAry.add(new Point(scaleUnit * 3, scaleUnit * 5));
            tempPointAry.add(new Point(scaleUnit * 4, scaleUnit * 5));
            tempPointAry.add(new Point(scaleUnit * 5, scaleUnit * 5));
            tempPointAry.add(new Point(scaleUnit * -4, scaleUnit * 6));
            tempPointAry.add(new Point(scaleUnit * -3, scaleUnit * 6));
            tempPointAry.add(new Point(scaleUnit * -2, scaleUnit * 6));
            tempPointAry.add(new Point(scaleUnit * -1, scaleUnit * 6));
            tempPointAry.add(new Point(scaleUnit * 0, scaleUnit * 6));
            tempPointAry.add(new Point(scaleUnit * 1, scaleUnit * 6));
            tempPointAry.add(new Point(scaleUnit * 2, scaleUnit * 6));
            tempPointAry.add(new Point(scaleUnit * 3, scaleUnit * 6));
            tempPointAry.add(new Point(scaleUnit * 4, scaleUnit * 6));
            tempPointAry.add(new Point(scaleUnit * -2, scaleUnit * 7));
            tempPointAry.add(new Point(scaleUnit * -1, scaleUnit * 7));
            tempPointAry.add(new Point(scaleUnit * 0, scaleUnit * 7));
            tempPointAry.add(new Point(scaleUnit * 1, scaleUnit * 7));
            tempPointAry.add(new Point(scaleUnit * 2, scaleUnit * 7));
        }
        return tempPointAry;
    }

    public static String[] getWeaponNames() {
        return weaponNames;
    }

    public static transferTile[] getTransferTiles() {
        return transferTiles;
    }

    public static ArrayList<tilesSearchItems> getTilesSearchAry2() {
        return tilesSearchAry2;
    }

    public static HashMap<Integer, mapSaveItem> getMapSaveItems() {
        return mapSaveItems;
    }

    public static void setMapSaveItems(HashMap<Integer, mapSaveItem> mapSaveItems) {
        Animator.mapSaveItems = mapSaveItems;
    }

    public static class AnimationItems {
        int itemAniPause;
        int itemAniSpeed;
        int itemAniType;
        int itemAniCounter = 0;
        int itemAniPauseCounter = 0;
        int itemAniSpriteNum = 0;
        int itemAniSpriteNumInc = 1;
        ArrayList<int[]> imageLocArray;
        int[] imageLoc = new int[4];

        public AnimationItems(int itemAniPause, int itemAniSpeed, int itemAniType, ArrayList<int[]> imageLocArray) {
            this.itemAniPause = itemAniPause;
            this.itemAniSpeed = itemAniSpeed;
            this.itemAniType = itemAniType;
            this.imageLocArray = imageLocArray;
        }
    }

    public static class mapSaveItem {
        public ArrayList<Point> tilesExplodable = new ArrayList();
        public ArrayList<Point> itemScrews = new ArrayList();
        public ArrayList<Point> itemTech = new ArrayList();
        public ArrayList<Point> itemCoin1 = new ArrayList();
        public ArrayList<Point> itemCoin2 = new ArrayList();
        public ArrayList<Point> itemCoin3 = new ArrayList();
        public ArrayList<Point> itemCoin4 = new ArrayList();
        public ArrayList<Point> itemCoin5 = new ArrayList();
        public ArrayList<Point> itemCoin6 = new ArrayList();
        public ArrayList<Point> maxHealth1 = new ArrayList();
        public ArrayList<Point> maxHealth2 = new ArrayList();
        public ArrayList<Point> maxHealth3 = new ArrayList();
        public ArrayList<Point>[] mapBreakables = new ArrayList[6];
        public Point knife = null;
        public Point gun = null;
        public Point shotgun = null;
        public Point laser = null;
        public Point flamethrower = null;
        public Point bazooka = null;
        public Point C4 = null;
        public Point syringe = null;
        public Point shield = null;
        public Point hookshot = null;

        public mapSaveItem() {
            int i = 0;
            while (i < 6) {
                this.mapBreakables[i] = new ArrayList();
                ++i;
            }
        }
    }

    public static class tilesSearchItems {
        String tileTag;
        ArrayList<int[]> imageLocArray = new ArrayList();
        int mapNum = 0;
        int sizeX = 1;
        int sizeY = 1;
        Boolean touchable = false;
        Boolean seeThrough = false;
        int shadowX;
        int shadowY;
        int L4PointX;
        int L4PointY;

        private tilesSearchItems(String tileTag, ArrayList<int[]> imageLocArray, int mapNum, int sizeX, int sizeY, Boolean touchable, Boolean seeThrough, int shadowX, int shadowY, int L4PointX, int L4PointY) {
            this.tileTag = tileTag;
            this.imageLocArray = imageLocArray;
            this.mapNum = mapNum;
            this.touchable = touchable;
            this.seeThrough = seeThrough;
            this.shadowX = shadowX;
            this.shadowY = shadowY;
            this.L4PointX = L4PointX;
            this.L4PointY = L4PointY;
            this.sizeX = sizeX;
            this.sizeY = sizeY;
        }
    }

    public static class transferTile {
        int mapNumSource;
        int mapNumDest;
        Point mapPointSource;
        Point mapPointDest;
        Boolean isSpawn;

        private transferTile(int mapNumSource, Point mapPointSource, int mapNumDest, Point mapPointDest, Boolean isSpawn) {
            this.mapNumSource = mapNumSource;
            this.mapPointSource = mapPointSource;
            this.mapNumDest = mapNumDest;
            this.mapPointDest = mapPointDest;
            this.isSpawn = isSpawn;
        }
    }
}

