/*
 * Decompiled with CFR 0.152.
 */
package SecItemsClass;

import Engine.Animator;
import Engine.Hero;
import Engine.MapMain;
import java.util.ArrayList;
import javax.sound.sampled.Clip;
import pickups.Items;
import weapons.WeaponHit;

public class SecItemHookShot
extends WeaponHit {
    int distance;
    byte chainPiece;
    byte chainPieceHead;
    WeaponHit hookLead;
    Items hookedItem;
    ArrayList<Items> hookedItems;

    public SecItemHookShot(int x, int y) {
        x = 0;
        y = 0;
        super(0, 0);
        this.distance = 0;
        this.chainPiece = (byte)-1;
        this.chainPieceHead = (byte)-1;
        this.hookLead = null;
        this.hookedItem = null;
        this.hookedItems = new ArrayList();
        int heroX = Animator.getBoard().getHero().getX();
        int heroY = Animator.getBoard().getHero().getY();
        if (this.direction == 1) {
            this.x = heroX;
            this.y = heroY - Animator.scale;
        } else if (this.direction == 2) {
            this.x = heroX + Animator.scale;
            this.y = heroY;
        } else if (this.direction == 3) {
            this.x = heroX;
            this.y = heroY + Animator.scale;
        } else if (this.direction == 4) {
            this.x = heroX - Animator.scale;
            this.y = heroY;
        }
        this.enemyHit = true;
        this.active = true;
        this.damage = 5;
        this.imgNum = (short)13;
        this.wepNum = 201;
        this.wepType = "HookShot";
        this.direction = Animator.getBoard().getHero().getLastDir();
        this.realSpeed = this.speed = 10 * (Animator.pixMulti / 4);
        this.hookShotOut = true;
        this.hookShotPullingHero = false;
        this.durration = Animator.getBoard().getUpgradeAmts()[1][4][0][Animator.getBoard().getHero().getMakeSecItems().getHeroSecItemsArray().get(Animator.heroSecItemIndexLocs.get("Hookshot")).getUpgrade1()];
        this.createRect();
        this.makeImage();
        this.playChianSound();
        Animator.getBoard().getHero().setWeaponAtk(false);
    }

    public SecItemHookShot(int x, int y, WeaponHit hookLead, byte chainPeice) {
        super(x, y);
        this.distance = 0;
        this.chainPiece = (byte)-1;
        this.chainPieceHead = (byte)-1;
        this.hookLead = null;
        this.hookedItem = null;
        this.hookedItems = new ArrayList();
        this.touchable = false;
        this.noRect = true;
        this.imgNum = (short)13;
        this.wepNum = 202;
        this.wepType = "HookShotChain";
        this.hookLead = hookLead;
        this.chainPiece = chainPeice;
        int speacer = 8 * chainPeice * Animator.pixMulti;
        if (this.direction == 1) {
            this.x = hookLead.getX();
            this.y = hookLead.getY() + Animator.scale + speacer;
        } else if (this.direction == 2) {
            this.x = hookLead.getX() - Animator.scale - speacer;
            this.y = hookLead.getY();
        } else if (this.direction == 3) {
            this.x = hookLead.getX();
            this.y = hookLead.getY() - Animator.scale - speacer;
        } else if (this.direction == 4) {
            this.x = hookLead.getX() + Animator.scale + speacer;
            this.y = hookLead.getY();
        }
        this.makeImage();
    }

    private void createRect() {
        int pixMulti = Animator.pixMulti;
        switch (this.direction) {
            case 1: {
                this.rectSpaceX = 4 * pixMulti;
                this.rectSpaceY = 11 * pixMulti;
                this.rectW = 8 * pixMulti;
                this.rectH = 5 * pixMulti;
                break;
            }
            case 2: {
                this.rectSpaceX = 0 * pixMulti;
                this.rectSpaceY = 4 * pixMulti;
                this.rectW = 5 * pixMulti;
                this.rectH = 8 * pixMulti;
                break;
            }
            case 3: {
                this.rectSpaceX = 4 * pixMulti;
                this.rectSpaceY = 0 * pixMulti;
                this.rectW = 8 * pixMulti;
                this.rectH = 5 * pixMulti;
                break;
            }
            case 4: {
                this.rectSpaceX = 11 * pixMulti;
                this.rectSpaceY = 4 * pixMulti;
                this.rectW = 5 * pixMulti;
                this.rectH = 8 * pixMulti;
            }
        }
        this.updateRect(false);
    }

    private void makeImage() {
        int addtional = 1;
        if (this.chainPiece >= 0) {
            addtional = 5;
        }
        int spriteSheetIndex = 4 * (this.direction + addtional) - 4;
        int tempLoc = Animator.getBoard().getHero().getMakeSecItems().getSecSpriteLocation().get(Animator.heroSecItemIndexLocs.get("Hookshot"))[spriteSheetIndex];
        this.imgLocation[0] = (short)tempLoc;
        tempLoc = Animator.getBoard().getHero().getMakeSecItems().getSecSpriteLocation().get(Animator.heroSecItemIndexLocs.get("Hookshot"))[++spriteSheetIndex];
        this.imgLocation[1] = (short)tempLoc;
        tempLoc = Animator.getBoard().getHero().getMakeSecItems().getSecSpriteLocation().get(Animator.heroSecItemIndexLocs.get("Hookshot"))[++spriteSheetIndex];
        this.imgLocation[2] = (short)tempLoc;
        tempLoc = Animator.getBoard().getHero().getMakeSecItems().getSecSpriteLocation().get(Animator.heroSecItemIndexLocs.get("Hookshot"))[++spriteSheetIndex];
        this.imgLocation[3] = (short)tempLoc;
    }

    @Override
    public void update() {
        if (this.chainPiece == -1 && !this.hookShotPullingHero) {
            int heroX = Animator.getBoard().getHero().getRectX();
            int heroY = Animator.getBoard().getHero().getRectY();
            this.speed = this.active == false ? 0 : this.realSpeed;
            int multiplier = -1;
            if (this.isHookShotOut()) {
                multiplier = 1;
            }
            int itemSpeed = this.speed * multiplier;
            switch (this.direction) {
                case 1: {
                    this.y -= this.speed * multiplier;
                    break;
                }
                case 2: {
                    this.x += this.speed * multiplier;
                    break;
                }
                case 3: {
                    this.y += this.speed * multiplier;
                    break;
                }
                case 4: {
                    this.x -= this.speed * multiplier;
                }
            }
            this.moveItems(this.direction, itemSpeed);
            if (this.isHookShotOut()) {
                this.distance += this.speed;
            }
            if (this.distance > this.durration || this.x > Animator.screenW + Animator.scale || this.x < -Animator.scale || this.y > Animator.screenH + Animator.scale || this.y < 0) {
                this.hookShotOut = false;
            }
            this.updateRect(false);
            if (this.collision2local() || this.leavingArea()) {
                this.hookShotOut = false;
            }
            if (!this.isHookShotOut()) {
                this.remove = this.checkRemove(heroX, heroY);
                if (this.remove.booleanValue()) {
                    this.letHeroMove();
                    Animator.getBoard().getClipHookshotChain().stop();
                    for (Items item : this.hookedItems) {
                        item.useItem();
                    }
                }
            }
        } else if (this.chainPiece == -1 && this.hookShotPullingHero) {
            Hero theHero = Animator.getBoard().getHero();
            this.speed = this.active == false ? 0 : this.realSpeed;
            int multiplier = -1;
            if (this.isHookShotOut()) {
                multiplier = 1;
            }
            int itemSpeed = this.speed * multiplier;
            switch (this.direction) {
                case 1: {
                    theHero.setY(theHero.getY() - itemSpeed);
                    break;
                }
                case 2: {
                    theHero.setX(theHero.getX() + itemSpeed);
                    break;
                }
                case 3: {
                    theHero.setY(theHero.getY() + itemSpeed);
                    break;
                }
                case 4: {
                    theHero.setX(theHero.getX() - itemSpeed);
                }
            }
            this.updateRect(false);
            this.remove = this.checkRemove(theHero.getX(), theHero.getY());
            if (this.remove.booleanValue()) {
                this.letHeroMove();
                Animator.getBoard().getClipHookshotChain().stop();
            }
        } else {
            int spacer = 8 * this.chainPiece * Animator.pixMulti;
            switch (this.direction) {
                case 1: {
                    this.x = this.hookLead.getX();
                    this.y = this.hookLead.getY() + Animator.scale + spacer;
                    break;
                }
                case 2: {
                    this.x = this.hookLead.getX() - Animator.scale - spacer;
                    this.y = this.hookLead.getY();
                    break;
                }
                case 3: {
                    this.x = this.hookLead.getX();
                    this.y = this.hookLead.getY() - Animator.scale - spacer;
                    break;
                }
                case 4: {
                    this.x = this.hookLead.getX() + Animator.scale + spacer;
                    this.y = this.hookLead.getY();
                }
            }
        }
        if (this.chainPiece >= 0) {
            this.hookShotOut = this.hookLead.isHookShotOut();
            this.hookShotPullingHero = this.hookLead.isHookShotPullingHero();
        }
        this.addRemoveChains();
        this.itemCollision();
    }

    private void letHeroMove() {
        Animator.getBoard().getHero().setCanAct(true);
        Animator.getBoard().getHero().setCanAtk(true);
        Animator.getBoard().getHero().setCanKockBack(true);
        Animator.getBoard().getHero().setHookshoting(false);
        Animator.getBoard().getHero().setWeaponAtk(true);
    }

    private void playSounds(byte soundNum) {
        if (Animator.playsouds.booleanValue()) {
            Clip theCLip = null;
            if (soundNum == 1) {
                theCLip = Animator.getBoard().getClipheroShieldHit()[0];
            } else if (soundNum == 2) {
                theCLip = Animator.getBoard().getClipHookshotHooked();
            }
            if (theCLip.isRunning()) {
                theCLip.stop();
            }
            theCLip.setFramePosition(0);
            theCLip.start();
        }
    }

    private void playChianSound() {
        if (Animator.playsouds.booleanValue() && !Animator.getBoard().getClipHookshotChain().isRunning()) {
            Animator.getBoard().getClipHookshotChain().setLoopPoints(0, -1);
            Animator.getBoard().getClipHookshotChain().loop(-1);
        }
    }

    private boolean checkRemove(int heroX, int heroY) {
        block17: {
            block16: {
                int heroW = Animator.getBoard().getHero().getRectW();
                int heroH = Animator.getBoard().getHero().getRectH();
                if (!this.hookShotPullingHero) break block16;
                switch (this.direction) {
                    case 1: {
                        if ((double)heroY <= this.hookedItem.getRect().getY()) {
                            return true;
                        }
                        break block17;
                    }
                    case 2: {
                        if ((double)(heroX + heroW) >= this.hookedItem.getRect().getX()) {
                            System.out.println("heroX = " + heroX + " heroW = " + heroW + " hookedItem.getRect().getX() = " + this.hookedItem.getRect().getX() + " hookedItem.getRectW() " + this.hookedItem.getRectW());
                            return true;
                        }
                        break block17;
                    }
                    case 3: {
                        if ((double)(heroY + heroH) >= this.hookedItem.getRect().getY() + (double)this.hookedItem.getRectH()) {
                            return true;
                        }
                        break block17;
                    }
                    case 4: {
                        if ((double)heroX <= this.hookedItem.getRect().getX()) {
                            return true;
                        }
                        break block17;
                    }
                }
                break block17;
            }
            switch (this.direction) {
                case 1: {
                    if (!(this.rect.getY() >= (double)heroY)) break;
                    return true;
                }
                case 2: {
                    if (!(this.rect.getX() <= (double)(heroX + Animator.scale))) break;
                    return true;
                }
                case 3: {
                    if (!(this.rect.getY() <= (double)(heroY + Animator.scale))) break;
                    return true;
                }
                case 4: {
                    if (!(this.rect.getX() + this.rect.getWidth() >= (double)heroX)) break;
                    return true;
                }
            }
        }
        return false;
    }

    private boolean collision2local() {
        for (MapMain mapCol : Animator.getBoard().getMapCollisionDomain()) {
            if (!mapCol.isNoRect() && !mapCol.getSeeThrough().booleanValue() && !mapCol.getIgnorHookhot().booleanValue() && mapCol.getRect().intersects(this.rect)) {
                this.playSounds((byte)1);
                return true;
            }
            if (!mapCol.isBulletsOnTop() || this.rectXW < mapCol.getX() || this.x > mapCol.getX() + Animator.scale || this.rectYH < mapCol.getY() || this.y > mapCol.getY() + Animator.scale) continue;
            System.out.println("setting ontop " + this);
            System.out.println("rectXW " + this.rectXW + " mapCol.getX() " + mapCol.getX() + " rectYH " + this.rectYH + " mapCol.getY() " + mapCol.getY());
            this.onTop = true;
        }
        return false;
    }

    private boolean leavingArea() {
        MapMain mapTL = Animator.getBoard().getMapMainArrayL3().get(Animator.getBoard().getMapCornerTL());
        MapMain mapBR = Animator.getBoard().getMapMainArrayL3().get(Animator.getBoard().getMapCornerBR());
        return (double)this.x + this.rect.getWidth() > (double)(mapBR.getX() + Animator.scale) || this.x + 11 * Animator.pixMulti < mapTL.getX() || this.y + 11 * Animator.pixMulti < mapTL.getY() || (double)this.y + this.rect.getHeight() > (double)(mapBR.getY() + Animator.scale);
    }

    private void itemCollision() {
        if (this.chainPiece == -1) {
            for (Items item : Animator.getBoard().getItemsArray()) {
                if (item.getHookable() == 0 || !item.getRect().intersects(this.rect) || this.hookedItems.contains(item) || this.hookShotPullingHero) continue;
                if (item.getHookable() == 1) {
                    this.hookedItems.add(item);
                    this.alignItem(item);
                    this.hookShotOut = false;
                }
                if (!this.hookShotOut || item.getHookable() != 2) continue;
                System.out.println("hookshot hooked");
                Animator.getBoard().getHero().setHookshoting(true);
                this.hookShotPullingHero = true;
                this.hookedItem = item;
                this.playSounds((byte)2);
            }
        }
    }

    private void moveItems(short direction, int itemSpeed) {
        for (Items item : this.hookedItems) {
            switch (direction) {
                case 1: {
                    item.setY(item.getY() - itemSpeed);
                    break;
                }
                case 2: {
                    item.setX(item.getX() + itemSpeed);
                    break;
                }
                case 3: {
                    item.setY(item.getY() + itemSpeed);
                    break;
                }
                case 4: {
                    item.setX(item.getX() - itemSpeed);
                }
            }
        }
    }

    private void alignItem(Items item) {
        switch (this.direction) {
            case 1: {
                item.setY(this.y + 5 * Animator.pixMulti);
                break;
            }
            case 2: {
                item.setX(this.x - 5 * Animator.pixMulti);
                break;
            }
            case 3: {
                item.setY(this.y - 5 * Animator.pixMulti);
                break;
            }
            case 4: {
                item.setX(this.x + 5 * Animator.pixMulti);
            }
        }
    }

    private void addRemoveChains() {
        block20: {
            int heroY;
            int heroX;
            block19: {
                heroX = Animator.getBoard().getHero().getRectX();
                heroY = Animator.getBoard().getHero().getRectY();
                if (this.chainPiece != -1 || !this.isHookShotOut()) break block19;
                int spacer = 8 * Animator.pixMulti;
                switch (this.direction) {
                    case 1: {
                        if (this.chainPieceHead < (heroY - Animator.scale - this.y) / spacer) {
                            this.chainPieceHead = (byte)(this.chainPieceHead + 1);
                            this.hookshotChainLinkPiece.hookshotHead = this;
                            this.hookshotChainLinkPiece.chainPiece = this.chainPieceHead;
                            break;
                        }
                        break block20;
                    }
                    case 2: {
                        if (this.chainPieceHead < (this.x - (heroX + Animator.scale)) / spacer) {
                            this.chainPieceHead = (byte)(this.chainPieceHead + 1);
                            this.hookshotChainLinkPiece.hookshotHead = this;
                            this.hookshotChainLinkPiece.chainPiece = this.chainPieceHead;
                            break;
                        }
                        break block20;
                    }
                    case 3: {
                        if (this.chainPieceHead < (this.y - (heroY + Animator.scale)) / spacer) {
                            this.chainPieceHead = (byte)(this.chainPieceHead + 1);
                            this.hookshotChainLinkPiece.hookshotHead = this;
                            this.hookshotChainLinkPiece.chainPiece = this.chainPieceHead;
                            break;
                        }
                        break block20;
                    }
                    case 4: {
                        if (this.chainPieceHead >= (heroX - Animator.scale - this.x) / spacer) break block20;
                        this.chainPieceHead = (byte)(this.chainPieceHead + 1);
                        this.hookshotChainLinkPiece.hookshotHead = this;
                        this.hookshotChainLinkPiece.chainPiece = this.chainPieceHead;
                    }
                    default: {
                        break;
                    }
                    {
                    }
                }
                break block20;
            }
            if (this.chainPiece >= 0 && (!this.isHookShotOut() || this.hookShotPullingHero)) {
                switch (this.direction) {
                    case 1: {
                        if (this.y < heroY) break;
                        this.remove = true;
                        break;
                    }
                    case 2: {
                        if (this.x > heroX) break;
                        this.remove = true;
                        break;
                    }
                    case 3: {
                        if (this.y > heroY) break;
                        this.remove = true;
                        break;
                    }
                    case 4: {
                        if (this.x < heroX) break;
                        this.remove = true;
                    }
                }
            }
        }
    }
}

