/*
 * Decompiled with CFR 0.152.
 */
package SecItemsClass;

import Engine.Animator;
import Engine.Hero;
import Engine.Sprite;
import java.awt.Rectangle;
import javax.sound.sampled.Clip;
import weapons.WeaponHit;

public class SecItemShield
extends Sprite {
    private int shieldUpgradeStregthAmt = 43;
    private int shieldUpgradeRegenAmt = 50;
    private int shieldHPMax = 530;
    private int shieldHP = 315;
    private int shieldHPBase = 315;
    private int shieldColorHP = 45;
    private int shieldRegen = 600;
    private int shieldRegenBase = 600;
    private int shieldRegenCounter = 0;
    private boolean shieldActive = false;
    private int xend = 0;
    private int yend = 0;
    private int[] imageLocs = new int[4];
    private boolean turnedOn = false;
    private Rectangle[] shieldRects = new Rectangle[5];
    private int pixMulti;
    private int shieldCooldownCounter;
    private int shieldCooldown;

    public SecItemShield(int x, int y) {
        super(x, y);
        int i = 0;
        while (i < this.shieldRects.length) {
            this.shieldRects[i] = new Rectangle();
            ++i;
        }
        this.pixMulti = Animator.pixMulti;
        this.shieldCooldownCounter = 0;
        this.shieldCooldown = 3600;
        this.touchable = false;
        this.noRect = true;
    }

    public void update() {
        if (this.shieldCooldownCounter > 0) {
            this.shieldActive = false;
            ++this.shieldCooldownCounter;
            if (this.shieldCooldownCounter >= this.shieldCooldown) {
                this.shieldCooldownCounter = 0;
                this.playSounds((byte)1);
            }
        } else {
            this.shieldActive = true;
            if (this.turnedOn) {
                this.playSounds((byte)1);
            }
        }
        this.turnedOn = false;
        Hero hero = Animator.getBoard().getHero();
        int sizeUpgade = hero.getMakeSecItems().getHeroSecItemsArray().get(Animator.heroSecItemIndexLocs.get("Shield")).getUpgrade2();
        this.shieldHPMax = this.shieldHPBase + hero.getMakeSecItems().getHeroSecItemsArray().get(Animator.heroSecItemIndexLocs.get("Shield")).getUpgrade1() * this.shieldUpgradeStregthAmt;
        this.shieldRegen = this.shieldRegenBase - hero.getMakeSecItems().getHeroSecItemsArray().get(Animator.heroSecItemIndexLocs.get("Shield")).getUpgrade1() * this.shieldUpgradeRegenAmt;
        int xoffset = 5 - sizeUpgade;
        int yoffset = 5 - sizeUpgade;
        this.setXY(hero, xoffset, yoffset);
        this.setSheildRects(hero, xoffset, yoffset, sizeUpgade);
        this.imageLocs = this.setImages(hero.getLastDir(), xoffset, yoffset, false);
        if (this.shieldActive && hero.getHeroSec() == Animator.heroSecItemIndexLocs.get("Shield").intValue()) {
            this.checkCols();
        }
        this.doRegen();
    }

    public void maxOut() {
        System.out.println("shieldHPMax " + this.shieldHPMax);
        this.update();
        System.out.println("shieldHPMax2 " + this.shieldHPMax);
        this.shieldHP = this.shieldHPMax;
    }

    private void playSounds(byte soundNum) {
        Clip theCLip = null;
        Clip[] theClipAry = null;
        if (soundNum == 1) {
            theCLip = Animator.getBoard().getClipheroShieldUp();
        } else if (soundNum == 2) {
            theCLip = Animator.getBoard().getClipheroShieldDown();
        } else if (soundNum == 3) {
            theClipAry = Animator.getBoard().getClipheroShieldHit();
            int clipIndex = 0;
            if (theClipAry[0].isRunning()) {
                clipIndex = 1;
            }
            theClipAry[0].setFramePosition(0);
            theClipAry[1].setFramePosition(0);
            theClipAry[clipIndex].start();
        }
        if (theCLip != null) {
            if (theCLip.isRunning()) {
                theCLip.stop();
            }
            theCLip.setFramePosition(0);
            theCLip.start();
        }
    }

    private void doRegen() {
        if (this.shieldHP < this.shieldHPMax) {
            ++this.shieldRegenCounter;
            if (this.shieldRegenCounter >= this.shieldRegen) {
                ++this.shieldHP;
                this.shieldRegenCounter = 0;
                if (this.shieldHP >= this.shieldHPMax) {
                    this.shieldHP = this.shieldHPMax;
                    this.playSounds((byte)1);
                }
            }
        } else {
            this.shieldRegenCounter = 0;
        }
    }

    private void setXY(Hero hero, int xoffset, int yoffset) {
        short heroDiection = hero.getLastDir();
        int xwoffset = 5 - xoffset;
        int yhoffset = 5 - yoffset;
        if (heroDiection == 1) {
            this.x = hero.getX() + xoffset * this.pixMulti;
            this.y = hero.getY() + 4 * this.pixMulti;
            this.xend = this.x + (6 + xwoffset * 2) * this.pixMulti;
            this.yend = this.y - 6 * this.pixMulti;
        } else if (heroDiection == 2) {
            this.x = hero.getX() + 12 * this.pixMulti;
            this.y = hero.getY() + yoffset * this.pixMulti;
            this.xend = this.x + 6 * this.pixMulti;
            this.yend = this.y + (6 + yhoffset * 2) * this.pixMulti;
        } else if (heroDiection == 3) {
            this.x = hero.getX() + xoffset * this.pixMulti;
            this.y = hero.getY() + 12 * this.pixMulti;
            this.xend = this.x + (6 + xwoffset * 2) * this.pixMulti;
            this.yend = this.y + 6 * this.pixMulti;
        } else if (heroDiection == 4) {
            this.x = hero.getX() + 4 * this.pixMulti;
            this.y = hero.getY() + yoffset * this.pixMulti;
            this.xend = this.x - 6 * this.pixMulti;
            this.yend = this.y + (6 + yhoffset * 2) * this.pixMulti;
        }
    }

    private void setSheildRects(Hero hero, int xoffset, int yoffset, int sizeUpgrade) {
        short heroDiection = hero.getLastDir();
        int shieldRectOffset = sizeUpgrade - 1;
        if (heroDiection == 1) {
            if (sizeUpgrade == 0) {
                this.shieldRects[0].setBounds(hero.getX() + 4 * this.pixMulti, hero.getY() + -2 * this.pixMulti, 6 * this.pixMulti, 3 * this.pixMulti);
            }
            if (sizeUpgrade > 0) {
                this.shieldRects[0].setBounds(hero.getX() + 4 * this.pixMulti, hero.getY() + -2 * this.pixMulti, 8 * this.pixMulti, 3 * this.pixMulti);
            }
            if (sizeUpgrade > 1) {
                this.shieldRects[1].setBounds(hero.getX() + 3 * this.pixMulti, hero.getY() + -1 * this.pixMulti, 10 * this.pixMulti, 2 * this.pixMulti);
            }
            if (sizeUpgrade > 2) {
                this.shieldRects[2].setBounds(hero.getX() + 2 * this.pixMulti, hero.getY() + 0 * this.pixMulti, 12 * this.pixMulti, 2 * this.pixMulti);
            }
            if (sizeUpgrade > 3) {
                this.shieldRects[3].setBounds(hero.getX() + 1 * this.pixMulti, hero.getY() + 1 * this.pixMulti, 14 * this.pixMulti, 2 * this.pixMulti);
            }
            if (sizeUpgrade > 4) {
                this.shieldRects[4].setBounds(hero.getX() + 0 * this.pixMulti, hero.getY() + 2 * this.pixMulti, 16 * this.pixMulti, 2 * this.pixMulti);
            }
        } else if (heroDiection == 2) {
            if (sizeUpgrade == 0) {
                this.shieldRects[0].setBounds(hero.getX() + 15 * this.pixMulti, hero.getY() + 4 * this.pixMulti, 3 * this.pixMulti, 6 * this.pixMulti);
            }
            if (sizeUpgrade > 0) {
                this.shieldRects[0].setBounds(hero.getX() + 15 * this.pixMulti, hero.getY() + 4 * this.pixMulti, 3 * this.pixMulti, 8 * this.pixMulti);
            }
            if (sizeUpgrade > 1) {
                this.shieldRects[1].setBounds(hero.getX() + 15 * this.pixMulti, hero.getY() + 3 * this.pixMulti, 2 * this.pixMulti, 10 * this.pixMulti);
            }
            if (sizeUpgrade > 2) {
                this.shieldRects[2].setBounds(hero.getX() + 14 * this.pixMulti, hero.getY() + 2 * this.pixMulti, 2 * this.pixMulti, 12 * this.pixMulti);
            }
            if (sizeUpgrade > 3) {
                this.shieldRects[3].setBounds(hero.getX() + 13 * this.pixMulti, hero.getY() + 1 * this.pixMulti, 2 * this.pixMulti, 14 * this.pixMulti);
            }
            if (sizeUpgrade > 4) {
                this.shieldRects[4].setBounds(hero.getX() + 12 * this.pixMulti, hero.getY() + 0 * this.pixMulti, 2 * this.pixMulti, 16 * this.pixMulti);
            }
        } else if (heroDiection == 3) {
            if (sizeUpgrade == 0) {
                this.shieldRects[0].setBounds(hero.getX() + 4 * this.pixMulti, hero.getY() + 15 * this.pixMulti, 6 * this.pixMulti, 3 * this.pixMulti);
            }
            if (sizeUpgrade > 0) {
                this.shieldRects[0].setBounds(hero.getX() + 4 * this.pixMulti, hero.getY() + 15 * this.pixMulti, 8 * this.pixMulti, 3 * this.pixMulti);
            }
            if (sizeUpgrade > 1) {
                this.shieldRects[1].setBounds(hero.getX() + 3 * this.pixMulti, hero.getY() + 15 * this.pixMulti, 10 * this.pixMulti, 2 * this.pixMulti);
            }
            if (sizeUpgrade > 2) {
                this.shieldRects[2].setBounds(hero.getX() + 2 * this.pixMulti, hero.getY() + 14 * this.pixMulti, 12 * this.pixMulti, 2 * this.pixMulti);
            }
            if (sizeUpgrade > 3) {
                this.shieldRects[3].setBounds(hero.getX() + 1 * this.pixMulti, hero.getY() + 13 * this.pixMulti, 14 * this.pixMulti, 2 * this.pixMulti);
            }
            if (sizeUpgrade > 4) {
                this.shieldRects[4].setBounds(hero.getX() + 0 * this.pixMulti, hero.getY() + 12 * this.pixMulti, 16 * this.pixMulti, 2 * this.pixMulti);
            }
        } else if (heroDiection == 4) {
            if (sizeUpgrade == 0) {
                this.shieldRects[0].setBounds(hero.getX() + -2 * this.pixMulti, hero.getY() + 4 * this.pixMulti, 3 * this.pixMulti, 6 * this.pixMulti);
            }
            if (sizeUpgrade > 0) {
                this.shieldRects[0].setBounds(hero.getX() + -2 * this.pixMulti, hero.getY() + 4 * this.pixMulti, 3 * this.pixMulti, 8 * this.pixMulti);
            }
            if (sizeUpgrade > 1) {
                this.shieldRects[1].setBounds(hero.getX() + -1 * this.pixMulti, hero.getY() + 3 * this.pixMulti, 2 * this.pixMulti, 10 * this.pixMulti);
            }
            if (sizeUpgrade > 2) {
                this.shieldRects[2].setBounds(hero.getX() + 0 * this.pixMulti, hero.getY() + 2 * this.pixMulti, 2 * this.pixMulti, 12 * this.pixMulti);
            }
            if (sizeUpgrade > 3) {
                this.shieldRects[3].setBounds(hero.getX() + 1 * this.pixMulti, hero.getY() + 1 * this.pixMulti, 2 * this.pixMulti, 14 * this.pixMulti);
            }
            if (sizeUpgrade > 4) {
                this.shieldRects[4].setBounds(hero.getX() + 2 * this.pixMulti, hero.getY() + 0 * this.pixMulti, 2 * this.pixMulti, 16 * this.pixMulti);
            }
        }
        int i = 2;
        while (i <= this.shieldRects.length) {
            if (sizeUpgrade < i) {
                this.shieldRects[i - 1].setBounds(0, 0, 0, 0);
            }
            ++i;
        }
    }

    public int[] setImages(short heroDirection, int xoffset, int yoffset, boolean forHUD) {
        int colorOffset = this.shieldHP / this.shieldColorHP;
        int yloc = 0;
        int xloc = 0;
        int xwidth = 0;
        int ywidth = 0;
        if (forHUD) {
            xoffset = 0;
            yoffset = 0;
        }
        if (heroDirection == 1 || heroDirection == 3) {
            yloc = colorOffset * 6;
            xloc = xoffset;
            xwidth = xloc + (5 - xoffset) * 2 + 6;
            ywidth = yloc + 6;
        }
        if (heroDirection == 2 || heroDirection == 4) {
            yloc = colorOffset / 3 * 16 + yoffset;
            xloc = colorOffset % 3 * 6 + 16;
            xwidth = xloc + 6;
            ywidth = yloc + (5 - yoffset) * 2 + 6;
        }
        return new int[]{xloc, yloc, xwidth, ywidth};
    }

    public static int[][] getPickUpImage(int x, int y) {
        int pixMulti = Animator.pixMulti;
        int[][] ret = new int[][]{{28, 48, 34, 64}, {x + 9 * pixMulti, y, x + 9 * pixMulti + 6 * pixMulti, y + 16 * pixMulti, x + 7 * pixMulti, y, x + 7 * pixMulti - 6 * pixMulti, y + 16 * pixMulti}};
        return ret;
    }

    private void checkCols() {
        block0: for (WeaponHit wepHits : Animator.getBoard().getWeaponHitArray()) {
            if (!wepHits.isShieldBlcok()) continue;
            int i = 0;
            while (i < this.shieldRects.length) {
                if (this.shieldRects[i] != null && this.shieldRects[i].intersects(wepHits.getRect())) {
                    wepHits.setRemove(true);
                    this.shieldHP -= wepHits.getDamage();
                    this.playSounds((byte)3);
                    if (this.shieldHP >= 1) continue block0;
                    this.shieldHP = 0;
                    this.shieldCooldownCounter = 1;
                    this.playSounds((byte)2);
                    break block0;
                }
                ++i;
            }
        }
    }

    public Rectangle[] getShieldRect() {
        return this.shieldRects;
    }

    public int getXend() {
        return this.xend;
    }

    public int getYend() {
        return this.yend;
    }

    public int[] getImageLocs() {
        return this.imageLocs;
    }

    public void setShieldActive(boolean shieldActive) {
        this.shieldActive = shieldActive;
    }

    public boolean isShieldActive() {
        return this.shieldActive;
    }

    public int getShieldHP() {
        return this.shieldHP;
    }

    public void setShieldHP(int shieldHP) {
        this.shieldHP = shieldHP;
    }

    public int getShieldHPBase() {
        return this.shieldHPBase;
    }

    public void setTurnedOn(boolean turnedOn) {
        this.turnedOn = turnedOn;
    }

    public int getShieldCooldownCounter() {
        return this.shieldCooldownCounter;
    }
}

