/*
 * Decompiled with CFR 0.152.
 */
package enemiesClass;

import Engine.Animator;
import Engine.Board;
import Engine.MapMain;
import enemiesClass.AstarNode;
import enemiesClass.Enemies;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.PriorityQueue;
import java.util.Queue;

public class Astar3 {
    private Point nodeStart;
    private Point nodeEnd;
    private AstarNode astarEnd;
    private AstarNode astarStart;
    private int astarMinX;
    private int astarMinY;
    private Enemies enemy;
    private boolean diag;
    private boolean isPath;
    private ArrayList<Point> pathToEnd = new ArrayList();
    private int sightDistance;
    private int sightDistanceOG;
    private Point heroCent;
    private Queue<AstarNode> openSet;
    private List<AstarNode> grid;
    private AstarNode[][] grid2;
    private Comparator<AstarNode> nodeComparator;

    public Astar3(MapMain nodeStart, MapMain nodeEnd, Enemies enemy, boolean diag) {
        Animator.getBoard();
        this.heroCent = Board.findCenter(Animator.getBoard().getHero().getRect());
        this.grid = new ArrayList<AstarNode>();
        this.nodeComparator = new Comparator<AstarNode>(){

            @Override
            public int compare(AstarNode a1, AstarNode a2) {
                return a1.getPathF() - a2.getPathF();
            }
        };
        this.nodeEnd = nodeEnd.getMapPoint();
        this.nodeStart = nodeStart.getMapPoint();
        this.enemy = enemy;
        this.diag = diag;
        this.sightDistanceOG = enemy.sightAttackRange;
        this.grid2 = new AstarNode[this.sightDistanceOG * 2 + 1][this.sightDistanceOG * 2 + 1];
        this.sightDistance = enemy.sightAttackRange * Animator.scale;
        this.openSet = new PriorityQueue<AstarNode>(11, this.nodeComparator);
        this.makeNodes();
        this.isPath = this.findPath();
    }

    private void makeNodes() {
        boolean foundMins = false;
        Point heroMapPoint = Animator.getBoard().getMapFromPoint(this.heroCent).getMapPoint();
        for (MapMain map : Animator.getBoard().getMapAstarDomain()) {
            if (heroMapPoint.x + this.sightDistanceOG < map.getMapPoint().x || heroMapPoint.x - this.sightDistanceOG > map.getMapPoint().x || heroMapPoint.y + this.sightDistanceOG < map.getMapPoint().y || heroMapPoint.y - this.sightDistanceOG > map.getMapPoint().y) continue;
            if (!foundMins) {
                this.astarMinX = map.getMapPoint().x;
                this.astarMinY = map.getMapPoint().y;
                foundMins = true;
            }
            if (map.getRect() != null) continue;
            AstarNode tempNode = new AstarNode(map.getMapPoint(), map.getX(), map.getY());
            if (map.getMapPoint().x == this.nodeStart.x && map.getMapPoint().y == this.nodeStart.y) {
                this.astarStart = tempNode;
                this.astarStart.setPathG(0);
                this.setHvlaue(this.astarStart);
                this.astarStart.setPathF(this.astarStart.getPathG() + this.astarStart.getPathH());
                this.openSet.add(this.astarStart);
            }
            if (map.getMapPoint().x == this.nodeEnd.x && map.getMapPoint().y == this.nodeEnd.y) {
                this.astarEnd = tempNode;
                this.astarEnd.setPathH(0);
            }
            this.grid2[map.getMapPoint().x - this.astarMinX][map.getMapPoint().y - this.astarMinY] = tempNode;
        }
    }

    private void setHvlaue(AstarNode anode) {
        anode.setPathH(this.getDistance(anode.getMapPoint(), this.nodeEnd));
    }

    private boolean findPath() {
        while (!this.openSet.isEmpty()) {
            AstarNode currentNode = this.openSet.poll();
            currentNode.setInClosed(true);
            if (currentNode.equals(this.astarEnd)) {
                this.makePathToEnd();
                return true;
            }
            AstarNode[] astarNodeArray = this.findNeighbors(currentNode);
            int n = astarNodeArray.length;
            int n2 = 0;
            while (n2 < n) {
                AstarNode map = astarNodeArray[n2];
                if (map != null) {
                    Point mapCent = Animator.getBoard().findMapTileCenter(map.getX(), map.getY());
                    if (!map.isInClosed()) {
                        if (Animator.getBoard().isRectInTile(map.getMapPoint())) {
                            map.setInClosed(true);
                        } else if (mapCent.x > this.enemy.mapAreaBR.getX() + Animator.scale || mapCent.x < this.enemy.mapAreaTL.getX() || mapCent.y > this.enemy.mapAreaBR.getY() + Animator.scale || mapCent.y < this.enemy.mapAreaTL.getY()) {
                            map.setInClosed(true);
                        } else if (mapCent.x > Animator.screenW + Animator.scale || mapCent.x < -Animator.scale || mapCent.y > Animator.screenH + Animator.scale || mapCent.y < 0) {
                            map.setInClosed(true);
                        } else if (!this.checkRange(mapCent)) {
                            map.setInClosed(true);
                        } else {
                            int tempG = currentNode.getPathG() + this.getDistance(currentNode.getMapPoint(), map.getMapPoint());
                            if (tempG < map.getPathG()) {
                                if (map.getPathG() != Integer.MAX_VALUE) {
                                    this.openSet.remove(map);
                                } else {
                                    this.setHvlaue(map);
                                }
                                map.setPathG(tempG);
                                map.setPathF(map.getPathH() + map.getPathG());
                                map.setPathParent(currentNode);
                                this.openSet.add(map);
                            }
                        }
                    }
                }
                ++n2;
            }
        }
        return false;
    }

    private AstarNode[] findNeighbors(AstarNode node) {
        int neighborCount = 4;
        if (this.diag) {
            neighborCount = 8;
        }
        AstarNode[] maps = new AstarNode[neighborCount];
        int index = 0;
        int ix = -1;
        while (ix < 2) {
            int iy = -1;
            while (iy < 2) {
                if ((ix != 0 || iy != 0) && node.getMapPoint().x - this.astarMinX + ix >= 0 && node.getMapPoint().x - this.astarMinX + ix < this.sightDistanceOG * 2 + 1 && node.getMapPoint().y - this.astarMinY + iy >= 0 && node.getMapPoint().y - this.astarMinY + iy < this.sightDistanceOG * 2 + 1) {
                    if (ix == 0 || iy == 0) {
                        if (this.grid2[node.getMapPoint().x - this.astarMinX + ix][node.getMapPoint().y - this.astarMinY + iy] != null) {
                            maps[index] = this.grid2[node.getMapPoint().x - this.astarMinX + ix][node.getMapPoint().y - this.astarMinY + iy];
                        }
                        ++index;
                    } else if (this.diag) {
                        if (this.grid2[node.getMapPoint().x - this.astarMinX + ix][node.getMapPoint().y - this.astarMinY + iy] != null) {
                            maps[index] = this.grid2[node.getMapPoint().x - this.astarMinX + ix][node.getMapPoint().y - this.astarMinY + iy];
                        }
                        ++index;
                    }
                }
                ++iy;
            }
            ++ix;
        }
        return maps;
    }

    private void makePathToEnd() {
        AstarNode nodeCurrent = this.astarEnd;
        this.pathToEnd.add(new Point(nodeCurrent.getX(), nodeCurrent.getY()));
        while (!nodeCurrent.equals(this.astarStart)) {
            nodeCurrent = nodeCurrent.getPathParent();
            this.pathToEnd.add(new Point(nodeCurrent.getX(), nodeCurrent.getY()));
        }
        Collections.reverse(this.pathToEnd);
    }

    private boolean checkRange(Point point) {
        return this.heroCent.y > point.y - this.sightDistance && this.heroCent.y < point.y + this.sightDistance && this.heroCent.x > point.x - this.sightDistance && this.heroCent.x < point.x + this.sightDistance;
    }

    private int getDistance(Point map1, Point map2) {
        int distY;
        int distX = Math.abs(map1.x - map2.x);
        if (distX > (distY = Math.abs(map1.y - map2.y))) {
            return 14 * distY + 10 * (distX - distY);
        }
        return 14 * distX + 10 * (distY - distX);
    }

    public boolean isPath() {
        return this.isPath;
    }

    public ArrayList<Point> getPathToEnd() {
        return this.pathToEnd;
    }
}

