/*
 * Decompiled with CFR 0.152.
 */
package enemiesClass;

import Engine.Animator;
import Engine.Font2;
import Engine.Hero;
import Engine.MapMain;
import Engine.Sprite;
import enemiesClass.Astar4;
import exceptions.GameException;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Line2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import java.util.TreeMap;
import javax.sound.sampled.Clip;
import javax.sound.sampled.FloatControl;
import mapClass.Areas;
import pickups.BulletPickups;
import pickups.Coins;
import pickups.PickUpHealth;
import weapons.AOEelectricHit;
import weapons.WeaponHit;
import weapons.heroGunHit;
import weapons.projectileHit;
import weapons.slime1Stationary;
import weapons.slimeAttack1;

public class Enemies
extends Sprite {
    protected final int imgSize = 16;
    protected final int gameSize = Animator.gameSize;
    protected int[][] moveUp;
    protected int[][] moveDown;
    protected int[][] moveLeft;
    protected int[][] moveRight;
    protected int[][] death;
    protected int[][] sleepUp;
    protected int[][] sleepDown;
    protected int[][] sleepRight;
    protected int[][] sleepLeft;
    protected int[][] attackUp;
    protected int[][] attackDown;
    protected int[][] attackRight;
    protected int[][] attackLeft;
    protected int[][] attackAlertUp;
    protected int[][] attackAlertDown;
    protected int[][] attackAlertRight;
    protected int[][] attackAlertLeft;
    protected int enemyStep;
    protected int pixMulti = Animator.pixMulti;
    protected int gameScale = Animator.scale;
    protected int enemyActiveRange = 3;
    protected String enemyType = "default";
    protected int enemyNum;
    protected boolean canSleep = false;
    protected boolean isSleeping = false;
    protected boolean hasAtkAni = false;
    protected boolean corrected = false;
    protected int lastX;
    protected int lastY;
    protected int dx = 0;
    protected int dy = 0;
    protected MapMain mapAreaTL;
    protected MapMain mapAreaBR;
    protected String areaName;
    protected Random rand = new Random();
    protected int rangeDamage;
    protected int physicalDamage;
    protected int projectileRange;
    protected int speed;
    protected int walkingSpeed = -1;
    protected int attackSpeed = -1;
    protected float attackSpeedFloat;
    protected byte attackSlideDirection = 1;
    protected Boolean alwaysStep = false;
    protected int attackSpeedCounter = 0;
    protected int[] attackSpeedAry;
    protected int chargeSpeed;
    protected int health;
    protected int walkingSpeedCounter = 0;
    protected int[] walkingSpeedAry;
    protected int[] projectileRect;
    protected int[][] enemyAttackObjtRect = new int[4][4];
    protected int attackImgeIndex;
    protected short direction;
    protected int totalDirections = 4;
    protected short stepCounter;
    protected short stepCounterMax = (short)120;
    protected short stepCounterInc;
    protected short lastDir;
    protected int moveCounter;
    private MapMain collidingMapTile;
    private MapMain collidingMapTileL1;
    private byte collisionWall = 1;
    protected byte collisionType = 0;
    protected int runslow = 0;
    protected int runslowCounter = 0;
    protected int runslowMax = 0;
    protected boolean soundSilence = false;
    public int soundSilenceTrigger = 0;
    public int soundSilenceCounter = 0;
    private String[] soundSilenceType = new String[]{"wolf", "bat"};
    protected int pauseTime = 0;
    protected int moveTime;
    protected Point pauseTimeRange = new Point(0, 0);
    protected Point moveTimeRange = new Point(0, 0);
    protected int dropWepTime;
    protected Point dropTimeRange;
    protected int dropWepCounter = 0;
    protected int rectVertSpaceX;
    protected int rectVertSpaceY;
    protected int rectVertX;
    protected int rectVertY;
    protected int rectVertW;
    protected int rectVertH;
    protected int rectHorzSpaceX;
    protected int rectHorzSpaceY;
    protected int rectHorzX;
    protected int rectHorzY;
    protected int rectHorzW;
    protected int rectHorzH;
    protected int enemyArraySpot;
    protected Boolean moving = false;
    protected Boolean active = false;
    protected Boolean gettingHit = false;
    private int gettingHitCounter = 0;
    private int gettingHitCounterMax = 250;
    protected Boolean dying = false;
    protected Boolean isAstarPath = true;
    protected Boolean isInvincible = false;
    protected Boolean colliding = false;
    protected Point heroPoint;
    protected Point heroRectXYPoint;
    protected int heroRectH;
    protected int heroRectW;
    protected int heroRectXW;
    protected int heroRectYH;
    protected Point enemyPoint = new Point(0, 0);
    protected Point testPoint = new Point(0, 0);
    protected int attackStyle;
    protected int sightRange;
    protected int sightAttackRange;
    protected int attackNotice;
    protected int attackRange = 0;
    protected int attackDuration;
    protected int attackIndent;
    protected int attackChargeTime;
    protected int attackDirection = 0;
    protected boolean canStopMidAttack = true;
    protected boolean removeAttackObj = false;
    protected boolean attackFinished = false;
    protected int attackPostPauseCounter = 0;
    protected int attackPostPauseTigger = 0;
    protected boolean attackAlertState = false;
    public ArrayList<Point> AOEPointsDist = new ArrayList();
    private ArrayList<AOEPoints> AOEPointsAry = new ArrayList();
    private ArrayList<cBurnedEnemies<Enemies, Integer>> BurnedEnemies = new ArrayList();
    protected Line2D attackLine = new Line2D.Double();
    protected Boolean attackHero = false;
    protected boolean attacking = false;
    protected boolean isAttackAlert = false;
    protected boolean heroGotHit = false;
    protected int attackPostPause = 0;
    protected int attackPostPauseTemp;
    protected int attackHoldCounter = 0;
    protected int attackHold;
    protected Point attackPauseRange = new Point(0, 0);
    protected int attackPause = 0;
    protected int attackPauseRangeValue = 0;
    protected Boolean attackPauseFinished = false;
    protected int attackCounter = 0;
    protected Point attackPoint = new Point(0, 0);
    private Point[] attackPoints = new Point[2];
    protected Point attackPoint2 = new Point(0, 0);
    protected int[][] trajectoryAry;
    protected int trajCounter = 0;
    protected int totTravel = 0;
    protected int chargeRange;
    private ArrayList<Point> astarPath = new ArrayList();
    protected Boolean canBurn = true;
    protected Boolean isBurning = false;
    protected int burnCounter = 0;
    protected int burnDamage;
    protected int[] imgFlameLoc = new int[4];
    protected int dropRate;
    protected int[][] dropItems = new int[8][14];
    protected Boolean remove = false;
    protected short hitDir;
    protected short colDir;
    protected int hitCounter = 0;
    protected int hitKnockBack = 7;
    protected int hitPause = 50;
    protected int hitInvincible = 0;
    protected int invincibleAttackCounter = 0;
    ArrayList<Integer> triggerTemp = new ArrayList();
    protected int[][] dirDraw;

    public Enemies(int x, int y) {
        super(x, y);
        this.setAreaCorners();
        this.attackLine.setLine(0.0, 0.0, 0.0, 0.0);
        int[][] nArrayArray = new int[4][];
        int[] nArray = new int[4];
        nArray[2] = 16;
        nArray[3] = 16;
        nArrayArray[0] = nArray;
        int[] nArray2 = new int[4];
        nArray2[0] = 16;
        nArray2[2] = 32;
        nArray2[3] = 16;
        nArrayArray[1] = nArray2;
        int[] nArray3 = new int[4];
        nArray3[0] = 32;
        nArray3[2] = 48;
        nArray3[3] = 16;
        nArrayArray[2] = nArray3;
        int[] nArray4 = new int[4];
        nArray4[0] = 48;
        nArray4[2] = 64;
        nArray4[3] = 16;
        nArrayArray[3] = nArray4;
        this.death = nArrayArray;
        this.setPickupArray();
        this.setDropRatios();
        this.direction = (short)(this.rand.nextInt(this.totalDirections) + 1);
    }

    protected void setDropRatios() {
    }

    protected void localUpdate() {
    }

    public void update() {
        if (!Animator.getBoard().getFreezGame().booleanValue() && this.x > -(Animator.scale * this.enemyActiveRange) && this.x < Animator.screenW + Animator.scale * this.enemyActiveRange && this.y > -(Animator.scale * this.enemyActiveRange) && this.y < Animator.screenH + Animator.scale * this.enemyActiveRange) {
            if (!this.active.booleanValue()) {
                this.active = true;
            }
        } else if (this.active.booleanValue()) {
            this.active = false;
        }
        if (this.attackPostPauseCounter != 0) {
            ++this.attackPostPauseCounter;
        }
        if (this.attackPostPauseCounter == this.attackPostPauseTigger) {
            this.attackPostPauseCounter = 0;
        }
        if (this.gettingHitCounter != 0) {
            ++this.gettingHitCounter;
        }
        if (this.gettingHitCounter > this.gettingHitCounterMax) {
            this.gettingHitCounter = 0;
        }
        if (this.direction == 2 || this.direction == 4) {
            this.rectSpaceX = this.rectHorzSpaceX;
            this.rectSpaceY = this.rectHorzSpaceY;
            this.rectW = this.rectHorzW;
            this.rectH = this.rectHorzH;
        } else {
            this.rectSpaceX = this.rectVertSpaceX;
            this.rectSpaceY = this.rectVertSpaceY;
            this.rectW = this.rectVertW;
            this.rectH = this.rectVertH;
        }
        if (this.active.booleanValue()) {
            this.x += this.dx;
            this.y += this.dy;
            this.updateRect(false);
            this.enemyPoint = this.findCenter(this.getRect());
            this.heroPoint = this.findCenter(Animator.getBoard().getHero().getRect());
            this.heroRectXYPoint = Animator.getBoard().getHero().getRect().getLocation();
            this.heroRectH = (int)Animator.getBoard().getHero().getRect().getHeight();
            this.heroRectW = (int)Animator.getBoard().getHero().getRect().getWidth();
            this.heroRectXW = Animator.getBoard().getHero().getRectXW();
            this.heroRectYH = Animator.getBoard().getHero().getRectYH();
            if (this.attackHoldCounter != 0) {
                ++this.attackHoldCounter;
            }
            if (this.attackHoldCounter >= this.attackHold) {
                this.attackHoldCounter = 0;
            }
            this.localUpdate();
            this.lastX = this.x;
            this.lastY = this.y;
            this.setDirDraw();
            this.doGettingHit();
            this.checkArea();
            this.doBurn();
            this.collision();
        }
    }

    protected Boolean checkHeroArea() {
        int xHero = Animator.getBoard().getHero().getRectX();
        int yHero = Animator.getBoard().getHero().getRectY();
        int wHero = Animator.getBoard().getHero().getRectW();
        int hHero = Animator.getBoard().getHero().getRectH();
        if (yHero + hHero >= this.mapAreaTL.getY() && yHero <= this.mapAreaBR.getY() + Animator.scale && xHero <= this.mapAreaBR.getX() + Animator.scale && xHero + wHero >= this.mapAreaTL.getX()) {
            return true;
        }
        if (this.attackHero.booleanValue()) {
            System.out.println("Enemy stop attack 3");
            this.stopAttack();
        }
        return false;
    }

    protected boolean checkAtk2() {
        Boolean inRange = false;
        int localSightRange = this.sightRange * (Animator.scale / 2);
        if (this.attackHero.booleanValue() || this.gettingHitCounter > 0) {
            localSightRange = this.sightAttackRange * (Animator.scale / 2);
        }
        block0 : switch (this.attackNotice) {
            case 1: {
                switch (this.direction) {
                    case 1: 
                    case 5: 
                    case 8: {
                        if (!((double)this.heroPoint.y < this.rect.getY() + this.rect.getHeight()) || this.heroPoint.y <= this.enemyPoint.y - localSightRange || this.heroRectXYPoint.x + this.heroRectW <= this.enemyPoint.x - localSightRange / 2 || this.heroRectXYPoint.x >= this.enemyPoint.x + localSightRange / 2) break block0;
                        inRange = true;
                        break block0;
                    }
                    case 2: {
                        if (!((double)this.heroPoint.x > this.rect.getX()) || this.heroPoint.x >= this.enemyPoint.x + localSightRange || this.heroRectXYPoint.y <= this.enemyPoint.y - localSightRange / 2 || this.heroRectXYPoint.y - this.heroRectH >= this.enemyPoint.y + localSightRange / 2) break block0;
                        inRange = true;
                        break block0;
                    }
                    case 3: 
                    case 6: 
                    case 7: {
                        if (!((double)this.heroPoint.y > this.rect.getY()) || this.heroPoint.y >= this.enemyPoint.y + localSightRange || this.heroRectXYPoint.x >= this.enemyPoint.x + localSightRange / 2 || this.heroRectXYPoint.x + this.heroRectW <= this.enemyPoint.x - localSightRange / 2) break block0;
                        inRange = true;
                        break block0;
                    }
                    case 4: {
                        if (!((double)this.heroPoint.x < this.rect.getX() + this.rect.getWidth()) || this.heroPoint.x <= this.enemyPoint.x - localSightRange || this.heroRectXYPoint.y <= this.enemyPoint.y - localSightRange / 2 || this.heroRectXYPoint.y - this.heroRectH >= this.enemyPoint.y + localSightRange / 2) break block0;
                        inRange = true;
                        break block0;
                    }
                }
                inRange = false;
                break;
            }
            case 2: {
                if (this.heroPoint.y <= this.enemyPoint.y - localSightRange || this.heroPoint.y >= this.enemyPoint.y + localSightRange || this.heroPoint.x <= this.enemyPoint.x - localSightRange || this.heroPoint.x >= this.enemyPoint.x + localSightRange) break;
                inRange = true;
                break;
            }
            case 3: {
                if (!this.attackAlertState) {
                    this.attackDirection = this.checkHVAttack(localSightRange);
                    if (this.attackDirection == 0) break;
                    if (this.direction == 5 || this.direction == 8) {
                        this.attackDirection = 1;
                    } else if (this.direction == 6 || this.direction == 6) {
                        this.attackDirection = 1;
                    } else {
                        this.direction = (short)this.attackDirection;
                    }
                    inRange = true;
                    break;
                }
                inRange = true;
            }
        }
        return inRange;
    }

    protected void checkAtk() {
        Boolean inRange = false;
        int localSightRange = this.sightRange * (Animator.scale / 2);
        if (this.attackHero.booleanValue() || this.gettingHitCounter > 0) {
            localSightRange = this.sightAttackRange * (Animator.scale / 2);
        }
        block0 : switch (this.attackNotice) {
            case 1: {
                switch (this.direction) {
                    case 1: 
                    case 5: 
                    case 8: {
                        if (!((double)this.heroPoint.y < this.rect.getY() + this.rect.getHeight()) || this.heroPoint.y <= this.enemyPoint.y - localSightRange || this.heroRectXYPoint.x + this.heroRectW <= this.enemyPoint.x - localSightRange / 2 || this.heroRectXYPoint.x >= this.enemyPoint.x + localSightRange / 2) break block0;
                        inRange = true;
                        break block0;
                    }
                    case 2: {
                        if (!((double)this.heroPoint.x > this.rect.getX()) || this.heroPoint.x >= this.enemyPoint.x + localSightRange || this.heroRectXYPoint.y <= this.enemyPoint.y - localSightRange / 2 || this.heroRectXYPoint.y - this.heroRectH >= this.enemyPoint.y + localSightRange / 2) break block0;
                        inRange = true;
                        break block0;
                    }
                    case 3: 
                    case 6: 
                    case 7: {
                        if (!((double)this.heroPoint.y > this.rect.getY()) || this.heroPoint.y >= this.enemyPoint.y + localSightRange || this.heroRectXYPoint.x >= this.enemyPoint.x + localSightRange / 2 || this.heroRectXYPoint.x + this.heroRectW <= this.enemyPoint.x - localSightRange / 2) break block0;
                        inRange = true;
                        break block0;
                    }
                    case 4: {
                        if (!((double)this.heroPoint.x < this.rect.getX() + this.rect.getWidth()) || this.heroPoint.x <= this.enemyPoint.x - localSightRange || this.heroRectXYPoint.y <= this.enemyPoint.y - localSightRange / 2 || this.heroRectXYPoint.y - this.heroRectH >= this.enemyPoint.y + localSightRange / 2) break block0;
                        inRange = true;
                        break block0;
                    }
                }
                inRange = false;
                break;
            }
            case 2: {
                if (this.heroPoint.y <= this.enemyPoint.y - localSightRange || this.heroPoint.y >= this.enemyPoint.y + localSightRange || this.heroPoint.x <= this.enemyPoint.x - localSightRange || this.heroPoint.x >= this.enemyPoint.x + localSightRange) break;
                inRange = true;
                break;
            }
            case 3: {
                if (!this.attackAlertState) {
                    this.attackDirection = this.checkHVAttack(localSightRange);
                    if (this.attackDirection == 0) break;
                    this.direction = (short)this.attackDirection;
                    inRange = true;
                    break;
                }
                inRange = true;
            }
        }
        if (inRange.booleanValue()) {
            this.attackLine.setLine(this.enemyPoint, this.heroPoint);
            boolean inSight = this.checkSight();
            if (!this.attackHero.booleanValue() && inSight) {
                System.out.println("Setting attackHero true 3 " + this.attackHero);
                this.attackHero = true;
                this.isSleeping = false;
                this.attackAlertState = true;
                this.dx = 0;
                this.dy = 0;
            }
            if (this.attackHero.booleanValue() && !inSight || this.attackHero.booleanValue() && !this.checkHeroArea().booleanValue()) {
                System.out.println("Enemy stop attack 2");
                this.stopAttack();
            }
            this.attackLine.setLine(0.0, 0.0, 0.0, 0.0);
        } else if (this.attackHero.booleanValue()) {
            System.out.println("Enemy stop attack 1");
            this.stopAttack();
        }
    }

    private int checkHVAttack(int localSightRange) {
        int attackDirection = 0;
        if (this.heroRectXYPoint.x + this.heroRectW >= this.enemyPoint.x && this.heroRectXYPoint.x <= this.enemyPoint.x) {
            if (this.heroRectXYPoint.y + this.heroRectH <= this.rectY && this.rectY - (this.heroRectXYPoint.y + this.heroRectH) < localSightRange) {
                attackDirection = 1;
            }
            if (this.heroRectXYPoint.y >= this.rectY + this.rectH && this.heroRectXYPoint.y - (this.rectY + this.rectH) < localSightRange) {
                attackDirection = 3;
            }
        }
        if (this.heroRectXYPoint.y + this.heroRectH >= this.enemyPoint.y && this.heroRectXYPoint.y <= this.enemyPoint.y) {
            if (this.heroRectXYPoint.x + this.heroRectW <= this.rectX && this.rectX - (this.heroRectXYPoint.x + this.heroRectW) < localSightRange) {
                attackDirection = 4;
            }
            if (this.heroRectXYPoint.x >= this.rectX + this.rectW && this.heroRectXYPoint.x - (this.rectX + this.rectW) < localSightRange) {
                attackDirection = 2;
            }
        }
        return attackDirection;
    }

    protected boolean checkLineCol(boolean checkSeeThrough, Line2D l2d) {
        if (checkSeeThrough) {
            for (MapMain map : Animator.getBoard().getMapCollisionDomain()) {
                if (map.getRect() == null || !l2d.intersects(map.getRect()) || map.getSeeThrough().booleanValue()) continue;
                return true;
            }
        } else {
            for (MapMain map : Animator.getBoard().getMapCollisionDomain()) {
                if (map.getRect() == null || !l2d.intersects(map.getRect())) continue;
                return true;
            }
        }
        return false;
    }

    protected boolean checkSight() {
        Boolean insite = true;
        if (!this.attackHero.booleanValue() && this.checkLineCol(true, this.attackLine)) {
            insite = false;
        }
        return insite;
    }

    protected boolean checkSight(Line2D attackLine, boolean chkSeeThrough) {
        Boolean insite = true;
        if (!this.attackHero.booleanValue() && this.checkLineCol(chkSeeThrough, attackLine)) {
            insite = false;
        }
        return insite;
    }

    protected boolean checkSight2(Line2D attackLine, boolean chkSeeThrough) {
        Boolean insite = true;
        if (this.checkLineCol(chkSeeThrough, attackLine)) {
            insite = false;
        }
        return insite;
    }

    public void stopAttack() {
        this.attacking = false;
        this.isAttackAlert = false;
        this.attackAlertState = false;
        this.direction = (short)this.attackDirection;
        this.attackPause = 0;
        System.out.println("Setting attackHero false 5 " + this.attackHero);
        this.attackHero = false;
        this.moving = false;
        this.moveCounter = 0;
        this.attackCounter = 0;
        this.invincibleAttackCounter = 0;
        this.dx = 0;
        this.dy = 0;
    }

    public void pauseAttack() {
        this.attacking = false;
        this.isAttackAlert = false;
        this.attackAlertState = true;
        this.attackPause = 0;
        System.out.println("Setting attackHero false 6 " + this.attackHero);
        this.attackHero = false;
        this.moving = false;
        this.moveCounter = 0;
        this.attackCounter = 0;
        this.invincibleAttackCounter = 0;
        this.dx = 0;
        this.dy = 0;
    }

    private void stopMidAttack() {
        this.attacking = false;
        this.attackCounter = 0;
        this.attackPause = 0;
    }

    private Point findCenter(Rectangle sprite) {
        Point point = new Point(0, 0);
        point.x = (int)(sprite.getX() + sprite.getWidth() / 2.0);
        point.y = (int)(sprite.getY() + sprite.getHeight() / 2.0);
        return point;
    }

    private void setPickupArray() {
        int i = 0;
        while (i < this.dropItems.length) {
            int i2 = 0;
            while (i2 < this.dropItems[i].length) {
                this.dropItems[i][i2] = 0;
                ++i2;
            }
            ++i;
        }
    }

    public boolean atkAOECheck(Point center, Point target, int range, boolean charge) {
        int halfscale = this.gameScale / 2;
        Boolean isInRange = false;
        if (range == 5) {
            if (target.x >= center.x - halfscale * 2 && target.y >= center.y - halfscale * 5 && target.x <= center.x + halfscale * 2 && target.y <= center.y - halfscale * 4) {
                isInRange = true;
            }
            if (target.x >= center.x - halfscale * 3 && target.y >= center.y - halfscale * 4 && target.x <= center.x + halfscale * 3 && target.y <= center.y - halfscale * 3) {
                isInRange = true;
            }
            if (target.x >= center.x - halfscale * 4 && target.y >= center.y - halfscale * 3 && target.x <= center.x + halfscale * 4 && target.y <= center.y - halfscale * 2) {
                isInRange = true;
            }
            if (target.x >= center.x - halfscale * 5 && target.y >= center.y - halfscale * 2 && target.x <= center.x + halfscale * 5 && target.y <= center.y + halfscale * 2) {
                isInRange = true;
            }
            if (target.x >= center.x - halfscale * 4 && target.y >= center.y + halfscale * 2 && target.x <= center.x + halfscale * 4 && target.y <= center.y + halfscale * 3) {
                isInRange = true;
            }
            if (target.x >= center.x - halfscale * 3 && target.y >= center.y + halfscale * 3 && target.x <= center.x + halfscale * 3 && target.y <= center.y + halfscale * 4) {
                isInRange = true;
            }
            if (target.x >= center.x - halfscale * 2 && target.y >= center.y + halfscale * 4 && target.x <= center.x + halfscale * 2 && target.y <= center.y + halfscale * 5) {
                isInRange = true;
            }
        } else if (range == 7) {
            if (target.x >= center.x - halfscale * 2 && target.y >= center.y - halfscale * 7 && target.x <= center.x + halfscale * 2 && target.y <= center.y - halfscale * 6) {
                isInRange = true;
            }
            if (target.x >= center.x - halfscale * 4 && target.y >= center.y - halfscale * 6 && target.x <= center.x + halfscale * 4 && target.y <= center.y - halfscale * 5) {
                isInRange = true;
            }
            if (target.x >= center.x - halfscale * 5 && target.y >= center.y - halfscale * 5 && target.x <= center.x + halfscale * 5 && target.y <= center.y - halfscale * 4) {
                isInRange = true;
            }
            if (target.x >= center.x - halfscale * 6 && target.y >= center.y - halfscale * 4 && target.x <= center.x + halfscale * 6 && target.y <= center.y - halfscale * 2) {
                isInRange = true;
            }
            if (target.x >= center.x - halfscale * 7 && target.y >= center.y - halfscale * 2 && target.x <= center.x + halfscale * 7 && target.y <= center.y + halfscale * 2) {
                isInRange = true;
            }
            if (target.x >= center.x - halfscale * 6 && target.y >= center.y + halfscale * 2 && target.x <= center.x + halfscale * 6 && target.y <= center.y + halfscale * 4) {
                isInRange = true;
            }
            if (target.x >= center.x - halfscale * 5 && target.y >= center.y + halfscale * 4 && target.x <= center.x + halfscale * 5 && target.y <= center.y + halfscale * 5) {
                isInRange = true;
            }
            if (target.x >= center.x - halfscale * 4 && target.y >= center.y + halfscale * 5 && target.x <= center.x + halfscale * 4 && target.y <= center.y + halfscale * 6) {
                isInRange = true;
            }
            if (target.x >= center.x - halfscale * 2 && target.y >= center.y + halfscale * 6 && target.x <= center.x + halfscale * 2 && target.y <= center.y + halfscale * 7) {
                isInRange = true;
            }
        }
        if (isInRange.booleanValue()) {
            if (charge) {
                Point[] sourcePoints = new Point[4];
                Point[] targetPoints = new Point[4];
                sourcePoints[0] = this.rect.getLocation();
                targetPoints[0] = this.heroRectXYPoint;
                sourcePoints[1] = new Point(this.rectXW, this.rectY);
                targetPoints[1] = new Point(this.heroRectXW, (int)this.heroRectXYPoint.getY());
                sourcePoints[2] = new Point(this.rectX, this.rectYH);
                targetPoints[2] = new Point((int)this.heroRectXYPoint.getX(), this.heroRectYH);
                sourcePoints[3] = new Point(this.rectXW, this.rectYH);
                targetPoints[3] = new Point(this.heroRectXW, this.heroRectYH);
                if (!this.chkCharge(sourcePoints, targetPoints)) {
                    isInRange = false;
                }
            }
            return true;
        }
        return false;
    }

    private boolean chkCharge(Point[] sourcePoints, Point[] targetPoints) {
        this.attackLine.setLine(sourcePoints[0], targetPoints[0]);
        if (!this.checkSight(this.attackLine, false)) {
            return false;
        }
        this.attackLine.setLine(sourcePoints[1], targetPoints[1]);
        if (!this.checkSight(this.attackLine, false)) {
            return false;
        }
        this.attackLine.setLine(sourcePoints[2], targetPoints[2]);
        if (!this.checkSight(this.attackLine, false)) {
            return false;
        }
        this.attackLine.setLine(sourcePoints[3], targetPoints[3]);
        if (!this.checkSight(this.attackLine, false)) {
            return false;
        }
        this.attackLine.setLine(0.0, 0.0, 0.0, 0.0);
        return true;
    }

    protected void collision() {
        int damageDone = 0;
        if (!this.isInvincible.booleanValue() && this.invincibleAttackCounter == 0) {
            for (WeaponHit wepHit : Animator.getBoard().getWeaponHitArray()) {
                if (!wepHit.getEnemyHit().booleanValue() || !wepHit.getRect().intersects(this.rect)) continue;
                String[] stringArray = this.soundSilenceType;
                int n = this.soundSilenceType.length;
                int n2 = 0;
                while (n2 < n) {
                    String s = stringArray[n2];
                    if (this.enemyType.contains(s)) {
                        this.soundSilence = true;
                    }
                    ++n2;
                }
                if (wepHit.getWepNum() == 8) {
                    damageDone = wepHit.getDamage();
                    this.health -= wepHit.getDamage();
                    this.hitDir = this.getCollisionDir(wepHit.getRect().intersection(this.rect));
                    this.gettingHit = true;
                    this.gettingHitCounter = 1;
                    this.isInvincible = true;
                    if (wepHit.getWepNum() != 8) {
                        wepHit.setRemove(true);
                    }
                    if (this.health > 0) {
                        this.playSounds((short)1);
                    } else {
                        this.playSounds((short)2);
                    }
                } else if (wepHit.getWepNum() >= 1 && wepHit.getWepNum() <= 5 || wepHit.getWepNum() == 201) {
                    damageDone = wepHit.getDamage();
                    this.health -= wepHit.getDamage();
                    this.hitDir = wepHit.getDirection();
                    this.gettingHit = true;
                    this.gettingHitCounter = 1;
                    this.isInvincible = true;
                    if (wepHit.getWepNum() != 1 && wepHit.getWepNum() != 201) {
                        wepHit.setRemove(true);
                    }
                    if (wepHit.getWepNum() == 201) {
                        wepHit.setHookShotOut(false);
                    }
                    if (this.health > 0) {
                        this.playSounds((short)1);
                    } else {
                        this.playSounds((short)2);
                    }
                    if (wepHit.getWepNum() == 5 && this.canBurn.booleanValue() && !this.isBurning.booleanValue()) {
                        this.isBurning = true;
                        this.burnCounter = 0;
                        this.burnDamage = wepHit.getDamage() / 6;
                    }
                } else if (wepHit.getWepNum() == 6) {
                    wepHit.makeExplosion();
                }
                if (this.gettingHit.booleanValue()) {
                    this.faceHero();
                }
                if (wepHit.getWepNum() == 6) break;
                String damageStr = "-" + String.valueOf(damageDone);
                Animator.getBoard().fontArray.add(new Font2(damageStr, "red", this, 90));
                break;
            }
        }
        TreeMap<Integer, MapMain> treeMap = new TreeMap<Integer, MapMain>();
        int tot = 0;
        this.colliding = false;
        if (this.collisionType != 2) {
            for (MapMain map : Animator.getBoard().getMapCollisionDomain()) {
                if (map.getRect() == null || (this.collisionType != 0 || !map.getRect().intersects(this.rect)) && (this.collisionType != 1 || map.getSeeThrough().booleanValue() || !map.getRect().intersects(this.rect))) continue;
                Rectangle r = map.getRect().intersection(this.rect);
                tot = r.height + r.width;
                while (treeMap.containsKey(tot)) {
                    ++tot;
                }
                treeMap.put(tot, map);
            }
        }
        this.doWallCol(treeMap);
        if (this.rect.intersects(Animator.getBoard().getHero().getRect()) && !Animator.getBoard().getHero().getGettingHit().booleanValue() && !this.attacking) {
            this.attackPostPauseCounter = 1;
        }
    }

    private void doWallCol(Map<Integer, MapMain> treeMap) {
        for (Integer entry : ((TreeMap)treeMap).descendingKeySet()) {
            Point point = new Point(0, 0);
            point = treeMap.get(entry).checkCol4(0, this.x, this.y, this.rectSpaceX, this.rectSpaceY, this.rectW, this.rectH, this.rect, false);
            if (point.x != this.x || point.y != this.y) {
                this.colliding = true;
                this.collidingMapTile = treeMap.get(entry);
                Rectangle interRect = this.collidingMapTile.getRect().intersection(this.rect);
                this.collisionWall = interRect.width > interRect.height ? (byte)2 : (interRect.width < interRect.height ? (byte)1 : (byte)3);
                this.collidingMapTileL1 = Animator.getBoard().getMapFromPoint(new Point(this.collidingMapTile.getX(), this.collidingMapTile.getY()));
            }
            if (!(point.x == this.x && point.y == this.y || this.gettingHit.booleanValue() || this.attackHero.booleanValue())) {
                this.changeDir();
            }
            this.x = point.x;
            this.y = point.y;
            this.updateRect(false);
        }
    }

    private void doBurn() {
        if (this.isBurning.booleanValue()) {
            this.spredBurn();
            if (Animator.playsouds.booleanValue() && !Animator.getBoard().clipBurning.isRunning()) {
                Animator.getBoard().clipBurning.setLoopPoints(0, -1);
                Animator.getBoard().clipBurning.loop(-1);
            }
            ++this.burnCounter;
            if (this.burnCounter % 90 == 0) {
                this.health -= this.burnDamage;
                String damageStr = "-" + String.valueOf(this.burnDamage);
                this.playSounds((short)1);
                Animator.getBoard().fontArray.add(new Font2(damageStr, "red", this, 90));
            }
            if (this.burnCounter % 10 == 0) {
                this.flameImgLoc(this.rand.nextInt(6) + 1);
            }
            if (this.burnCounter > 220) {
                this.isBurning = false;
                Animator.getBoard().clipBurning.stop();
            }
            if (this.dying.booleanValue()) {
                this.isBurning = false;
                this.burnCounter = 0;
                Animator.getBoard().clipBurning.stop();
            }
        }
        ArrayList<cBurnedEnemies<Enemies, Integer>> removeBurned = new ArrayList<cBurnedEnemies<Enemies, Integer>>();
        Iterator<cBurnedEnemies<Enemies, Integer>> iterator = this.BurnedEnemies.iterator();
        while (iterator.hasNext()) {
            cBurnedEnemies<Enemies, Integer> map;
            cBurnedEnemies<Enemies, Integer> cBurnedEnemies2 = map = iterator.next();
            ((cBurnedEnemies)cBurnedEnemies2).coolDownTimer = ((cBurnedEnemies)cBurnedEnemies2).coolDownTimer + 1;
            if (((cBurnedEnemies)map).coolDownTimer <= 1200) continue;
            removeBurned.add(map);
        }
        for (cBurnedEnemies<Enemies, Integer> map : removeBurned) {
            this.BurnedEnemies.remove(map);
        }
    }

    private void spredBurn() {
        block0: for (Enemies enemy : Animator.getBoard().getEnemyArray()) {
            if (!enemy.mapAreaTL.equals(this.mapAreaTL) || !enemy.rect.intersects(this.rect) || enemy.equals(this) || enemy.isBurning.booleanValue()) continue;
            for (cBurnedEnemies<Enemies, Integer> map : this.BurnedEnemies) {
                if (((cBurnedEnemies)map).enemy == enemy) continue block0;
            }
            enemy.setIsBurning(true);
            enemy.setBurnDamage(this.burnDamage);
            enemy.burnCounter = 0;
            cBurnedEnemies burnEntry = new cBurnedEnemies(enemy, 0);
            this.BurnedEnemies.add(burnEntry);
        }
    }

    private void flameImgLoc(int i) {
        switch (i) {
            case 1: {
                this.imgFlameLoc[0] = 0;
                this.imgFlameLoc[1] = 80;
                this.imgFlameLoc[2] = 16;
                this.imgFlameLoc[3] = 96;
                break;
            }
            case 2: {
                this.imgFlameLoc[0] = 16;
                this.imgFlameLoc[1] = 80;
                this.imgFlameLoc[2] = 32;
                this.imgFlameLoc[3] = 96;
                break;
            }
            case 3: {
                this.imgFlameLoc[0] = 32;
                this.imgFlameLoc[1] = 80;
                this.imgFlameLoc[2] = 48;
                this.imgFlameLoc[3] = 96;
                break;
            }
            case 4: {
                this.imgFlameLoc[0] = 48;
                this.imgFlameLoc[1] = 80;
                this.imgFlameLoc[2] = 64;
                this.imgFlameLoc[3] = 96;
                break;
            }
            case 5: {
                this.imgFlameLoc[0] = 0;
                this.imgFlameLoc[1] = 96;
                this.imgFlameLoc[2] = 16;
                this.imgFlameLoc[3] = 112;
                break;
            }
            case 6: {
                this.imgFlameLoc[0] = 16;
                this.imgFlameLoc[1] = 96;
                this.imgFlameLoc[2] = 32;
                this.imgFlameLoc[3] = 112;
            }
        }
    }

    protected void stopMovment() {
        this.moving = false;
        this.attackCounter = -1;
        this.moveCounter = 0;
        this.dx = 0;
        this.dy = 0;
    }

    protected void playSounds(short num) {
        if (Animator.playsouds.booleanValue()) {
            switch (num) {
                case 1: {
                    if (Animator.getBoard().getClipEnemyHit().isRunning()) {
                        Animator.getBoard().getClipEnemyHit().stop();
                    }
                    Animator.getBoard().getClipEnemyHit().setFramePosition(0);
                    Animator.getBoard().getClipEnemyHit().start();
                    break;
                }
                case 2: {
                    if (Animator.getBoard().getClipEnemyKill().isRunning()) {
                        Animator.getBoard().getClipEnemyKill().stop();
                    }
                    Animator.getBoard().getClipEnemyKill().setFramePosition(0);
                    Animator.getBoard().getClipEnemyKill().start();
                    break;
                }
                case 3: {
                    if (Animator.getBoard().getClipDogGrowl().isRunning()) {
                        Animator.getBoard().getClipDogGrowl().stop();
                    }
                    Animator.getBoard().getClipDogGrowl().setFramePosition(0);
                    Animator.getBoard().getClipDogGrowl().start();
                    break;
                }
                case 4: {
                    if (Animator.getBoard().getClipDogBark().isRunning()) {
                        Animator.getBoard().getClipDogBark().stop();
                    }
                    if (Animator.getBoard().getClipDogGrowl().isRunning()) {
                        Animator.getBoard().getClipDogGrowl().stop();
                    }
                    Animator.getBoard().getClipDogBark().setFramePosition(0);
                    Animator.getBoard().getClipDogBark().start();
                    break;
                }
                case 5: {
                    if (Animator.getBoard().getClipRobotAlert().isRunning()) {
                        Animator.getBoard().getClipRobotAlert().stop();
                    }
                    Animator.getBoard().getClipRobotAlert().setFramePosition(0);
                    Animator.getBoard().getClipRobotAlert().start();
                    break;
                }
                case 6: {
                    if (Animator.getBoard().getClipEnemyChargeWep().isRunning()) {
                        Animator.getBoard().getClipEnemyChargeWep().stop();
                    }
                    FloatControl volumeControl = (FloatControl)Animator.getBoard().getClipEnemyChargeWep().getControl(FloatControl.Type.MASTER_GAIN);
                    float volume = -10.0f;
                    volumeControl.setValue(volume);
                    Animator.getBoard().getClipEnemyChargeWep().setFramePosition(0);
                    Animator.getBoard().getClipEnemyChargeWep().start();
                    break;
                }
                case 7: {
                    if (Animator.getBoard().getClipWepSlimeAttackAlert1().isRunning()) {
                        Animator.getBoard().getClipWepSlimeAttackAlert1().stop();
                    }
                    Animator.getBoard().getClipWepSlimeAttackAlert1().setFramePosition(0);
                    Animator.getBoard().getClipWepSlimeAttackAlert1().start();
                    break;
                }
                case 8: {
                    if (Animator.getBoard().getClipWepSlimeAttackAlert1().isRunning()) {
                        Animator.getBoard().getClipBat1().stop();
                    }
                    Animator.getBoard().getClipBat1().setFramePosition(0);
                    Animator.getBoard().getClipBat1().start();
                }
            }
        }
    }

    private void stopSounds() {
        Animator.getBoard().getClipDogGrowl().stop();
        Animator.getBoard().getClipDogBark().stop();
        Animator.getBoard().getClipWepElecCharge().stop();
        Animator.getBoard().getClipWepElecAttack().stop();
        Animator.getBoard().getClipRobotAlert().stop();
        Animator.getBoard().getClipWepSlimeAttack1().stop();
        Animator.getBoard().getClipWepSlimeAttackAlert1().stop();
    }

    private void setAreaCorners() {
        for (Areas area : Animator.getBoard().getAreas()) {
            if (this.x < area.getMapTL().getX() || this.x > area.getMapBR().getX() || this.y < area.getMapTL().getY() || this.y > area.getMapBR().getY()) continue;
            this.mapAreaTL = area.getMapTL();
            this.mapAreaBR = area.getMapBR();
            this.areaName = area.getAreaName();
            break;
        }
    }

    private void changeDir() {
        switch (this.direction) {
            case 1: {
                if (this.lastDir != 3) {
                    this.lastDir = this.direction;
                    this.direction = (short)3;
                    break;
                }
                this.anotherDirection();
                break;
            }
            case 2: {
                if (this.lastDir != 4) {
                    this.lastDir = this.direction;
                    this.direction = (short)4;
                    break;
                }
                this.anotherDirection();
                break;
            }
            case 3: {
                if (this.lastDir != 1) {
                    this.lastDir = this.direction;
                    this.direction = 1;
                    break;
                }
                this.anotherDirection();
                break;
            }
            case 4: {
                if (this.lastDir != 2) {
                    this.lastDir = this.direction;
                    this.direction = (short)2;
                    break;
                }
                this.anotherDirection();
                break;
            }
            case 5: {
                if (this.collisionWall == 1) {
                    this.direction = (short)8;
                    break;
                }
                if (this.collisionWall == 2) {
                    this.direction = (short)6;
                    break;
                }
                if (this.collisionWall != 3) break;
                this.direction = (short)7;
                break;
            }
            case 8: {
                if (this.collisionWall == 1) {
                    this.direction = (short)5;
                    break;
                }
                if (this.collisionWall == 2) {
                    this.direction = (short)7;
                    break;
                }
                if (this.collisionWall != 3) break;
                this.direction = (short)6;
                break;
            }
            case 6: {
                if (this.collisionWall == 1) {
                    this.direction = (short)7;
                    break;
                }
                if (this.collisionWall == 2) {
                    this.direction = (short)5;
                    break;
                }
                if (this.collisionWall != 3) break;
                this.direction = (short)8;
                break;
            }
            case 7: {
                if (this.collisionWall == 1) {
                    this.direction = (short)6;
                    break;
                }
                if (this.collisionWall == 2) {
                    this.direction = (short)8;
                    break;
                }
                if (this.collisionWall != 3) break;
                this.direction = (short)5;
            }
        }
        this.dx = 0;
        this.dy = 0;
    }

    private void checkArea() {
        if (Animator.getBoard().getCounter() > 1) {
            int scale = Animator.scale;
            int tlX = this.mapAreaTL.getX();
            int tlY = this.mapAreaTL.getY();
            int brX = this.mapAreaBR.getX();
            int brY = this.mapAreaBR.getY();
            if (this.rectX + this.rectW > brX + scale) {
                this.x = brX + scale - (this.rectW + this.rectSpaceX);
                this.collisionWall = 1;
                if (!this.gettingHit.booleanValue()) {
                    this.changeDir();
                }
            }
            if (this.rectX < tlX) {
                this.x = tlX - this.rectSpaceX;
                this.collisionWall = 1;
                if (!this.gettingHit.booleanValue()) {
                    this.changeDir();
                }
            }
            if (this.rectY + this.rectH > brY + scale) {
                this.y = brY + scale - (this.rectSpaceY + this.rectH);
                this.collisionWall = (byte)2;
                if (!this.gettingHit.booleanValue()) {
                    this.changeDir();
                }
            }
            if (this.rectY < tlY) {
                this.y = tlY - this.rectSpaceY;
                this.collisionWall = (byte)2;
                if (!this.gettingHit.booleanValue()) {
                    this.changeDir();
                }
            }
        }
        this.updateRect(false);
    }

    private void anotherDirection() {
        int[] dirs = new int[3];
        int indexSpot = 0;
        int i = 1;
        while (i <= 4) {
            if (this.direction != i) {
                dirs[indexSpot] = i;
                ++indexSpot;
            }
            ++i;
        }
        this.lastDir = this.direction;
        this.direction = (short)dirs[this.rand.nextInt(3)];
    }

    protected void setDirDraw() {
        if (this.isAttackAlert) {
            this.setAttackAlertDraw();
        } else if (this.attacking) {
            this.setAttackDraw();
        } else if (this.isSleeping) {
            this.setSleepDraw();
        } else if (this.direction == 1 || this.direction == 5 || this.direction == 8) {
            this.dirDraw = this.moveUp;
        } else if (this.direction == 2) {
            this.dirDraw = this.moveRight;
        } else if (this.direction == 3 || this.direction == 6 || this.direction == 7) {
            this.dirDraw = this.moveDown;
        } else if (this.direction == 4) {
            this.dirDraw = this.moveLeft;
        }
    }

    protected void setSleepDraw() {
        this.enemyStep = 0;
        if (this.direction == 1 || this.direction == 5 || this.direction == 8) {
            this.dirDraw = this.sleepUp;
        } else if (this.direction == 2) {
            this.dirDraw = this.sleepRight;
        } else if (this.direction == 3 || this.direction == 6 || this.direction == 7) {
            this.dirDraw = this.sleepDown;
        } else if (this.direction == 4) {
            this.dirDraw = this.sleepLeft;
        }
    }

    protected void setAttackDraw() {
        this.enemyStep = 0;
        if (this.direction == 1 || this.direction == 5 || this.direction == 8) {
            this.dirDraw = this.attackUp;
        } else if (this.direction == 2) {
            this.dirDraw = this.attackRight;
        } else if (this.direction == 3 || this.direction == 6 || this.direction == 7) {
            this.dirDraw = this.attackDown;
        } else if (this.direction == 4) {
            this.dirDraw = this.attackLeft;
        }
    }

    protected void setAttackAlertDraw() {
        this.enemyStep = 0;
        if (this.direction == 1 || this.direction == 5 || this.direction == 8) {
            this.dirDraw = this.attackAlertUp;
        } else if (this.direction == 2) {
            this.dirDraw = this.attackAlertRight;
        } else if (this.direction == 3 || this.direction == 6 || this.direction == 7) {
            this.dirDraw = this.attackAlertDown;
        } else if (this.direction == 4) {
            this.dirDraw = this.attackAlertLeft;
        }
    }

    protected void doSteps() {
        if (this.moving.booleanValue() && !this.gettingHit.booleanValue()) {
            if (!this.attackHero.booleanValue()) {
                if (this.walkingSpeed != -1) {
                    this.speed = this.walkingSpeed;
                } else {
                    this.speed = this.walkingSpeedAry[this.walkingSpeedCounter];
                    ++this.walkingSpeedCounter;
                    if (this.walkingSpeedCounter >= this.walkingSpeedAry.length) {
                        this.walkingSpeedCounter = 0;
                    }
                }
                switch (this.direction) {
                    case 1: {
                        this.dy = -this.speed;
                        break;
                    }
                    case 2: {
                        this.dx = this.speed;
                        break;
                    }
                    case 3: {
                        this.dy = this.speed;
                        break;
                    }
                    case 4: {
                        this.dx = -this.speed;
                        break;
                    }
                    case 5: {
                        this.dx = this.speed;
                        this.dy = -this.speed;
                        break;
                    }
                    case 6: {
                        this.dx = this.speed;
                        this.dy = this.speed;
                        break;
                    }
                    case 7: {
                        this.dx = -this.speed;
                        this.dy = this.speed;
                        break;
                    }
                    case 8: {
                        this.dx = -this.speed;
                        this.dy = -this.speed;
                        break;
                    }
                    default: {
                        throw new GameException("Enemies: Unknown enemy direction " + this.direction);
                    }
                }
            }
            this.stepCounterInc = (short)this.speed;
            if (this.attackHero.booleanValue() && this.attackStyle == 1) {
                this.stepCounterInc = (short)this.attackSpeedFloat;
            }
            this.doStepCounters();
        } else if (this.alwaysStep.booleanValue()) {
            this.doStepCounters();
            this.dx = 0;
            this.dy = 0;
        } else {
            if (!this.dying.booleanValue()) {
                this.enemyStep = 0;
            }
            this.stepCounter = 0;
            this.dx = 0;
            this.dy = 0;
        }
    }

    private void doStepCounters() {
        this.stepCounter = (short)(this.stepCounter + this.stepCounterInc);
        if (this.stepCounter > this.stepCounterMax) {
            this.stepCounter = 0;
        }
        if (this.stepCounter > this.stepCounterMax / 4 * 3) {
            this.enemyStep = 0;
        } else if (this.stepCounter > this.stepCounterMax / 4 * 2) {
            this.enemyStep = 1;
        } else if (this.stepCounter > this.stepCounterMax / 4) {
            this.enemyStep = 2;
        } else if (this.stepCounter > 0) {
            this.enemyStep = 3;
        }
    }

    protected void doGettingHit() {
        if (this.health > 0) {
            if (this.isInvincible.booleanValue()) {
                if (this.hitCounter == 0) {
                    if (this.canStopMidAttack) {
                        this.stopMidAttack();
                    }
                    this.triggerTemp.clear();
                    this.triggerTemp.add(this.hitKnockBack);
                    this.triggerTemp.add(this.hitKnockBack + this.hitPause);
                    this.triggerTemp.add(this.hitKnockBack + this.hitPause + this.hitInvincible);
                    this.soundSilenceCounter = 1;
                }
                ++this.hitCounter;
                if (this.hitCounter < this.triggerTemp.get(0)) {
                    switch (this.hitDir) {
                        case 1: {
                            this.y -= 10 * this.gameSize;
                            break;
                        }
                        case 2: {
                            this.x += 10 * this.gameSize;
                            break;
                        }
                        case 3: {
                            this.y += 10 * this.gameSize;
                            break;
                        }
                        case 4: {
                            this.x -= 10 * this.gameSize;
                        }
                    }
                }
                if (this.hitCounter == this.triggerTemp.get(1)) {
                    this.gettingHit = false;
                    this.direction = this.hitDir + 2 < 5 ? (short)(this.hitDir + 2) : (short)(this.hitDir - 2);
                }
                if (this.hitCounter == this.triggerTemp.get(2)) {
                    this.hitCounter = 0;
                    this.isInvincible = false;
                }
            }
        } else {
            this.doDeath();
        }
    }

    protected void doDeath() {
        this.moving = false;
        this.dying = true;
        this.dirDraw = this.death;
        this.enemyArraySpot = 0;
        if (this.hitCounter > 30) {
            this.enemyStep = 3;
        } else if (this.hitCounter > 20) {
            this.enemyStep = 2;
        } else if (this.hitCounter > 10) {
            this.enemyStep = 1;
        } else if (this.hitCounter > 0) {
            this.enemyStep = 0;
        }
        ++this.hitCounter;
        if (this.hitCounter > 40) {
            this.findDrop();
            this.remove = true;
        }
        this.stopSounds();
    }

    protected void findDrop() {
        int itemTot = 0;
        int itemSelect = 0;
        int amtSelect = 0;
        if (this.rand.nextInt(100) < this.dropRate) {
            int i = 0;
            while (i < this.dropItems.length) {
                if (i < 2 || Animator.getBoard().getHero().getHeroWeps().get(i) != -1) {
                    itemTot += this.dropItems[i][0];
                }
                ++i;
            }
            itemSelect = this.rand.nextInt(itemTot);
            itemTot = 0;
            i = 0;
            while (i < this.dropItems.length) {
                if (this.dropItems[i][0] >= 1) {
                    if (i < 2 || Animator.getBoard().getHero().getHeroWeps().get(i) != -1) {
                        itemTot += this.dropItems[i][0];
                    }
                    if (itemSelect < itemTot) {
                        itemSelect = i;
                        break;
                    }
                }
                ++i;
            }
            itemTot = 0;
            i = 1;
            while (i < this.dropItems[itemSelect].length) {
                itemTot += this.dropItems[itemSelect][i];
                ++i;
            }
            amtSelect = this.rand.nextInt(itemTot);
            itemTot = 0;
            i = 1;
            while (i < this.dropItems[itemSelect].length) {
                if (this.dropItems[itemSelect][i] >= 1 && amtSelect < (itemTot += this.dropItems[itemSelect][i])) {
                    amtSelect = i;
                    break;
                }
                ++i;
            }
            this.dropItem(itemSelect, amtSelect);
        }
    }

    private void dropItem(int item, int amt) {
        amt = item == 0 ? Animator.itemCoinAmts[amt - 1] : (item == 1 ? Animator.itemAmts[amt - 1] * 3 : Animator.itemAmts[amt - 1]);
        switch (item) {
            case 0: {
                Animator.getBoard().itemsArray.add(new Coins(this.x, this.y, amt));
                break;
            }
            case 1: {
                Animator.getBoard().itemsArray.add(new PickUpHealth(this.x, this.y, amt));
                break;
            }
            default: {
                Animator.getBoard().itemsArray.add(new BulletPickups(this.x, this.y, item - 2, amt, false));
            }
        }
    }

    protected void moveEnemy() {
        if (!this.moving.booleanValue() && this.moveCounter == 0) {
            this.pauseTime = this.rand.nextInt(this.pauseTimeRange.y - this.pauseTimeRange.x);
            this.pauseTime += this.pauseTimeRange.x;
            this.setMoveTime();
        }
        if (!this.moving.booleanValue() && this.canSleep && this.pauseTime > 200 && this.moveCounter > 30) {
            this.isSleeping = true;
        }
        if (this.isSleeping && this.pauseTime - this.moveCounter < 30) {
            this.isSleeping = false;
        }
        ++this.moveCounter;
        if (!this.moving.booleanValue() && this.moveCounter >= this.pauseTime) {
            if (this.enemyNum == 15) {
                System.out.println("moving enemy");
            }
            this.lastDir = this.direction;
            this.direction = (short)(this.rand.nextInt(this.totalDirections) + 1);
            this.moveCounter = 0;
            this.moving = true;
            this.isSleeping = false;
        }
        if (this.moving.booleanValue() && this.moveCounter > this.moveTime) {
            if (this.enemyNum == 15) {
                System.out.println("stopping enemy");
            }
            this.moving = false;
            this.moveCounter = 0;
        }
    }

    protected void setMoveTime() {
        this.moveTime = this.rand.nextInt(this.moveTimeRange.y - this.moveTimeRange.x);
        this.moveTime += this.moveTimeRange.x;
    }

    protected void attackAlert() {
        this.faceHero();
        int gameSize = Animator.gameSize;
        if (this.attackPause == 0 || this.attackPause == 15) {
            this.playSounds((short)5);
        }
        if (this.attackPause >= 0 && this.attackPause <= 4) {
            this.y -= 6 * gameSize;
            this.isAttackAlert = true;
        }
        if (this.attackPause >= 5 && this.attackPause <= 9) {
            this.y += 6 * gameSize;
            this.isAttackAlert = true;
        }
        if (this.attackPause >= 10 && this.attackPause <= 14) {
            this.isAttackAlert = false;
        }
        if (this.attackPause >= 15 && this.attackPause <= 19) {
            this.y -= 6 * gameSize;
            this.isAttackAlert = true;
        }
        if (this.attackPause >= 20 && this.attackPause <= 24) {
            this.y += 6 * gameSize;
            this.isAttackAlert = true;
        }
        if (this.attackPause < 29) {
            ++this.attackPause;
        }
        if (this.attackPause >= 29) {
            this.isAttackAlert = false;
        }
        this.updateRect(false);
    }

    protected void setAttackSpeed() {
        if (this.attackSpeed == -1) {
            this.speed = this.attackSpeedAry[this.attackSpeedCounter];
            ++this.attackSpeedCounter;
            if (this.attackSpeedCounter >= this.attackSpeedAry.length) {
                this.attackSpeedCounter = 0;
            }
        } else {
            this.speed = this.attackSpeed;
        }
    }

    protected void attacking() {
        this.setAttackSpeed();
        if (this.runslowMax > 0 && this.runslowCounter == 0 && this.rand.nextInt(this.runslow) == this.runslow - 1) {
            this.runslowCounter = 1;
        }
        if (this.runslowCounter > 0) {
            ++this.runslowCounter;
            this.speed = this.attackSpeed - 1;
        }
        if (this.runslowCounter > this.runslowMax) {
            this.runslowCounter = 0;
        }
        float distance = Animator.findDistance(this.enemyPoint, this.heroPoint);
        float distX = (float)(this.heroPoint.x - this.enemyPoint.x) / distance;
        float distY = (float)(this.heroPoint.y - this.enemyPoint.y) / distance;
        this.direction = distX > 0.0f ? (short)2 : (short)4;
        if (distY > 0.0f && Math.abs(distY) > Math.abs(distX)) {
            this.direction = (short)3;
        } else if (distY < 0.0f && Math.abs(distY) > Math.abs(distX)) {
            this.direction = 1;
        }
        if (this.attackCounter == 0 && this.soundSilenceCounter == 0) {
            this.attackPause = this.rand.nextInt(this.attackPauseRange.y - this.attackPauseRange.x);
            this.attackPause += this.attackPauseRange.x;
            if (this.enemyNum == 1 || this.enemyNum == 2) {
                this.playSounds((short)3);
            } else if (this.enemyNum == 14) {
                this.playSounds((short)8);
            }
        }
        if (this.attackCounter == this.attackPause) {
            if (this.enemyNum == 1 || this.enemyNum == 2) {
                this.playSounds((short)4);
            }
            ++this.attackCounter;
        }
        if (this.attackCounter < this.attackPause) {
            ++this.attackCounter;
            this.moving = false;
        } else {
            this.moving = true;
            switch (this.attackStyle) {
                case 1: {
                    this.dx = (int)(distX * this.attackSpeedFloat);
                    this.dy = (int)(distY * this.attackSpeedFloat);
                }
            }
        }
        this.slideEnemy();
    }

    public Point getAtkDir(short lastDir) {
        int scale = Animator.scale;
        Point point = new Point(this.x, this.y);
        switch (lastDir) {
            case 1: 
            case 5: 
            case 8: {
                point.y = this.y - scale;
                break;
            }
            case 2: {
                point.x = this.x + scale;
                break;
            }
            case 3: 
            case 6: 
            case 7: {
                point.y = this.y + scale;
                break;
            }
            case 4: {
                point.x = this.x - scale;
            }
        }
        return point;
    }

    protected Astar4 findAttackSpot4() {
        Astar4 astar;
        boolean horz = true;
        boolean plus = false;
        Hero hero = Animator.getBoard().getHero();
        if (Math.abs(this.heroPoint.y - this.enemyPoint.y) > Math.abs(this.heroPoint.x - this.enemyPoint.x)) {
            horz = false;
        }
        plus = this.setAttackDirections(horz);
        Point[] tempAttackPoints = new Point[2];
        tempAttackPoints[0] = new Point(this.attackPoints[0]);
        int APindex = 0;
        boolean switchPoint = false;
        boolean tryOther = true;
        boolean reversed = false;
        boolean atkPtReachable = true;
        while (true) {
            if (this.checkPathRectCol(this.makePointRect(tempAttackPoints[APindex], (int)this.rect.getWidth(), (int)this.rect.getHeight())) || Animator.getBoard().isRectInTile(Animator.getBoard().getMapFromPoint(tempAttackPoints[APindex])) || tempAttackPoints[APindex].x > hero.getX() - Animator.scale / 2 && tempAttackPoints[APindex].x < hero.getX() + Animator.scale + Animator.scale / 2 && tempAttackPoints[APindex].y > hero.getY() - Animator.scale / 2 && tempAttackPoints[APindex].y < hero.getY() + Animator.scale + Animator.scale / 2 || this.checkAttackPoint(tempAttackPoints[APindex]) || !atkPtReachable) {
                atkPtReachable = true;
                APindex = !switchPoint || tempAttackPoints[1] == null ? 0 : 1;
                boolean bl = switchPoint = !switchPoint;
                if (horz) {
                    tempAttackPoints[APindex].x = plus ? (tempAttackPoints[APindex].x += Animator.scale / 2) : (tempAttackPoints[APindex].x -= Animator.scale / 2);
                } else {
                    tempAttackPoints[APindex].y = plus ? (tempAttackPoints[APindex].y += Animator.scale / 2) : (tempAttackPoints[APindex].y -= Animator.scale / 2);
                }
                if (plus && !reversed && (horz && tempAttackPoints[APindex].x > hero.getX() || !horz && tempAttackPoints[APindex].y > hero.getY())) {
                    plus = false;
                    reversed = true;
                    tempAttackPoints[APindex] = this.attackPoints[APindex];
                } else if (!plus && !reversed && (horz && tempAttackPoints[APindex].x < hero.getX() + Animator.scale || !horz && tempAttackPoints[APindex].y < hero.getY() + Animator.scale)) {
                    plus = true;
                    reversed = true;
                    tempAttackPoints[APindex] = this.attackPoints[APindex];
                    continue;
                }
                if (reversed && tryOther && this.checkAttackPoint(tempAttackPoints[APindex])) {
                    tryOther = false;
                    horz = !horz;
                    reversed = false;
                    plus = this.setAttackDirections(horz);
                    tempAttackPoints[APindex] = this.attackPoints[APindex];
                    continue;
                }
                if (!reversed || tryOther || !this.checkAttackPoint(tempAttackPoints[APindex])) continue;
                return null;
            }
            this.attackPoint = tempAttackPoints[APindex];
            astar = new Astar4(this.findClosestTile(), Animator.getBoard().getMapFromPoint(this.attackPoint), this, false);
            atkPtReachable = astar.isPath();
            if (atkPtReachable) break;
        }
        return astar;
    }

    public Point gridAttackPoint(Point OGAttackPoint) {
        MapMain map = Animator.getBoard().getMapFromPoint(OGAttackPoint);
        int mapx = map.getX();
        int mapy = map.getY();
        int section = Animator.scale / 4;
        if (OGAttackPoint.x < mapx + section) {
            if (OGAttackPoint.y < mapy + section) {
                OGAttackPoint.setLocation(mapx, mapy);
                return OGAttackPoint;
            }
            if (OGAttackPoint.y < mapy + section * 3) {
                OGAttackPoint.setLocation(mapx, mapy + section * 2);
                return OGAttackPoint;
            }
            OGAttackPoint.setLocation(mapx, mapy + section * 4);
            return OGAttackPoint;
        }
        if (OGAttackPoint.x < mapx + section * 3) {
            if (OGAttackPoint.y < mapy + section) {
                OGAttackPoint.setLocation(mapx + section * 2, mapy);
                return OGAttackPoint;
            }
            if (OGAttackPoint.y < mapy + section * 3) {
                OGAttackPoint.setLocation(mapx + section * 2, mapy + section * 2);
                return OGAttackPoint;
            }
            OGAttackPoint.setLocation(mapx + section * 2, mapy + section * 4);
            return OGAttackPoint;
        }
        if (OGAttackPoint.y < mapy + section) {
            OGAttackPoint.setLocation(mapx + section * 4, mapy);
            return OGAttackPoint;
        }
        if (OGAttackPoint.y < mapy + section * 3) {
            OGAttackPoint.setLocation(mapx + section * 4, mapy + section * 2);
            return OGAttackPoint;
        }
        OGAttackPoint.setLocation(mapx + section * 4, mapy + section * 4);
        return OGAttackPoint;
    }

    private boolean setAttackDirections(Boolean horz) {
        this.attackPoint = this.setAttackPointArorss3(horz);
        this.attackPoint = this.gridAttackPoint(this.attackPoint);
        this.checkAttackPointStrait(horz);
        this.testPoint = this.attackPoint;
        if (horz.booleanValue() && this.heroPoint.x > this.attackPoint.x) {
            return true;
        }
        return horz == false && this.heroPoint.y > this.attackPoint.y;
    }

    private boolean checkAttackPoint(Point point) {
        int range = this.sightAttackRange * Animator.scale;
        if (Math.abs(point.x - this.heroPoint.x) > range || Math.abs(point.y - this.heroPoint.y) > range) {
            return true;
        }
        if (point.x > Animator.screenW || point.x < 0 || point.y > Animator.screenH || point.y < 0) {
            return true;
        }
        return (double)point.x + this.rect.getWidth() / 2.0 > (double)(this.mapAreaBR.getX() + Animator.scale / 2) || (double)point.x - this.rect.getWidth() / 2.0 < (double)this.mapAreaTL.getX() || (double)point.y + this.rect.getHeight() / 2.0 > (double)(this.mapAreaBR.getY() + Animator.scale / 2) || (double)point.y - this.rect.getHeight() / 2.0 < (double)this.mapAreaTL.getY();
    }

    private void checkAttackPointStrait(boolean horz) {
        Hero hero = Animator.getBoard().getHero();
        int scale = Animator.scale / 2;
        int neg = 1;
        int indent1 = 0;
        int indent2 = 0;
        this.attackPoints[0] = new Point(0, 0);
        this.attackPoints[1] = null;
        if (horz) {
            if (this.enemyPoint.y > hero.getRectYH() - this.attackIndent) {
                indent2 = this.attackIndent;
            }
            if (this.enemyPoint.y < hero.getRectY() + this.attackIndent) {
                indent1 = this.attackIndent;
            }
            if (this.attackPoint.y >= hero.getRectY() + indent1 && this.attackPoint.y <= hero.getRectYH() - indent2) {
                this.attackPoints[0].setLocation(this.attackPoint);
                int i = -1;
                while (i < 2) {
                    if (i != 0 && this.attackPoint.y + scale * i >= hero.getRectY() + indent1 && this.attackPoint.y + scale * i <= hero.getRectYH() - indent2) {
                        this.attackPoints[1] = new Point(this.attackPoint.x, this.attackPoint.y + scale * i);
                    }
                    ++i;
                }
            } else {
                if (this.attackPoint.y > hero.getRectYH()) {
                    neg = -1;
                }
                int i = 1;
                while (i <= 2) {
                    if (this.attackPoint.y + scale * i * neg >= hero.getRectY() + indent1 && this.attackPoint.y + scale * i * neg <= hero.getRectYH() - indent2) {
                        if (i == 1) {
                            this.attackPoints[0].setLocation(this.attackPoint.x, this.attackPoint.y + scale * i * neg);
                        } else {
                            this.attackPoints[1] = new Point(this.attackPoint.x, this.attackPoint.y + scale * i * neg);
                        }
                    }
                    ++i;
                }
            }
        } else {
            if (this.enemyPoint.x > hero.getRectXW() - this.attackIndent) {
                indent2 = this.attackIndent;
            }
            if (this.enemyPoint.x < hero.getRectX() + this.attackIndent) {
                indent1 = this.attackIndent;
            }
            if (this.attackPoint.x >= hero.getRectX() + indent1 && this.attackPoint.x <= hero.getRectXW() - indent2) {
                this.attackPoints[0].setLocation(this.attackPoint);
                int i = -1;
                while (i < 2) {
                    if (i != 0 && this.attackPoint.x + scale * i >= hero.getRectX() + indent1 && this.attackPoint.x + scale * i <= hero.getRectXW() - indent2) {
                        this.attackPoints[1] = new Point(this.attackPoint.x + scale * i, this.attackPoint.y);
                    }
                    ++i;
                }
            } else {
                if (this.attackPoint.x > hero.getRectX() + hero.getRectW()) {
                    neg = -1;
                }
                int i = 1;
                while (i <= 2) {
                    if (this.attackPoint.x + scale * i * neg >= hero.getRectX() + indent1 && this.attackPoint.x + scale * i * neg <= hero.getRectXW() - indent2) {
                        if (i == 1) {
                            this.attackPoints[0].setLocation(this.attackPoint.x + scale * i * neg, this.attackPoint.y);
                        } else {
                            this.attackPoints[1] = new Point(this.attackPoint.x + scale * i * neg, this.attackPoint.y);
                        }
                    }
                    ++i;
                }
            }
        }
    }

    private Point setAttackPointArorss3(boolean horz) {
        if (horz) {
            return new Point(this.enemyPoint.x, this.heroPoint.y);
        }
        return new Point(this.heroPoint.x, this.enemyPoint.y);
    }

    private Rectangle makePointRect(Point point, int width, int hight) {
        return new Rectangle(point.x - width / 2, point.y - hight / 2, width, hight);
    }

    private byte findRectLocationInMapTile(Point map, Point[] points) {
        int location = 5;
        int minx = map.x;
        int maxx = map.x + Animator.scale;
        int miny = map.y;
        int maxy = map.y + Animator.scale;
        if (points[0].x < minx && points[0].y < miny) {
            location = 7;
        }
        if (points[1].x > maxx && points[1].y < miny) {
            location = 9;
        }
        if (points[2].x < minx && points[2].y > maxy) {
            location = 1;
        }
        if (points[3].x > maxx && points[3].y > maxy) {
            location = 3;
        }
        if (points[0].x >= minx && points[1].x <= maxx) {
            if (points[0].y < miny) {
                location = 8;
            }
            if (points[2].y > maxy) {
                location = 2;
            }
        }
        if (points[0].y >= miny && points[2].y <= maxy) {
            if (points[0].x < minx) {
                location = 4;
            }
            if (points[1].x > maxx) {
                location = 6;
            }
        }
        return (byte)location;
    }

    private MapMain findClosestTile() {
        int size = 0;
        int sizeTemp = 0;
        MapMain mapTile = null;
        for (MapMain map : Animator.getBoard().getMapMainArrayL1()) {
            sizeTemp = 0;
            if (!((double)map.getX() <= this.rect.getX() && (double)(map.getX() + Animator.scale) > this.rect.getX() || (double)map.getX() <= this.rect.getX() + this.rect.getWidth() && (double)(map.getX() + Animator.scale) > this.rect.getX() + this.rect.getWidth()) && (!((double)map.getX() <= this.rect.getX()) || !((double)(map.getX() + Animator.scale) > this.rect.getX() + this.rect.getWidth())) || !((double)map.getY() <= this.rect.getY() && (double)(map.getY() + Animator.scale) > this.rect.getY() || (double)map.getY() <= this.rect.getY() + this.rect.getHeight() && (double)(map.getY() + Animator.scale) > this.rect.getY() + this.rect.getHeight()) && (!((double)map.getY() <= this.rect.getY()) || !((double)(map.getY() + Animator.scale) > this.rect.getY() + this.rect.getHeight())) || map.getRect() != null) continue;
            if ((double)map.getX() <= this.rect.getX() && (double)(map.getX() + Animator.scale) > this.rect.getX()) {
                sizeTemp = (int)((double)sizeTemp + ((double)(map.getX() + Animator.scale - 1) - this.rect.getX()));
            } else if ((double)map.getX() <= this.rect.getX() + this.rect.getWidth() && (double)(map.getX() + Animator.scale) > this.rect.getX() + this.rect.getWidth()) {
                sizeTemp = (int)((double)sizeTemp + (this.rect.getX() + this.rect.getWidth() - (double)map.getX()));
            } else if ((double)map.getX() <= this.rect.getX() && (double)(map.getX() + Animator.scale) > this.rect.getX() + this.rect.getWidth()) {
                sizeTemp = (int)((double)sizeTemp + this.rect.getWidth());
            }
            if ((double)map.getY() <= this.rect.getY() && (double)(map.getY() + Animator.scale) > this.rect.getY()) {
                sizeTemp = (int)((double)sizeTemp + ((double)(map.getY() + Animator.scale - 1) - this.rect.getY()));
            } else if ((double)map.getY() <= this.rect.getY() + this.rect.getHeight() && (double)(map.getY() + Animator.scale) > this.rect.getY() + this.rect.getHeight()) {
                sizeTemp = (int)((double)sizeTemp + (this.rect.getY() + this.rect.getHeight() - (double)map.getY()));
            } else if ((double)map.getY() <= this.rect.getY() && (double)(map.getY() + Animator.scale) > this.rect.getY() + this.rect.getHeight()) {
                sizeTemp = (int)((double)sizeTemp + this.rect.getHeight());
            }
            if (sizeTemp <= size) continue;
            size = sizeTemp;
            mapTile = map;
        }
        return mapTile;
    }

    private boolean checkPathRectCol(Rectangle rect) {
        if (this.collisionType != 3) {
            for (MapMain map : Animator.getBoard().getMapCollisionDomain()) {
                if (map.getRect() == null || (this.collisionType != 0 || !map.getRect().intersects(rect)) && (this.collisionType != 1 || map.getSeeThrough().booleanValue() || !map.getRect().intersects(rect))) continue;
                return true;
            }
        }
        return false;
    }

    protected void followAstar(Astar4 astar) {
        if (astar.isPath()) {
            this.isAstarPath = true;
            if (this.attackPause < 29) {
                this.attackAlert();
                return;
            }
            this.setAttackSpeed();
            this.faceHero();
            this.dy = 0;
            this.dx = 0;
            this.moving = true;
            this.astarPath = astar.getPathToEnd();
            byte tileLoc = this.findRectLocationInMapTile(this.astarPath.get(0), Animator.getBoard().getRectCorners(this.rect));
            byte nextLoc = 0;
            if (this.astarPath.size() > 1) {
                nextLoc = this.getAttackNextTile();
            }
            if (this.astarPath.size() > 2) {
                this.moveAttackPath(tileLoc, nextLoc);
            } else {
                this.moveAttackPathFinal(tileLoc, nextLoc);
            }
        } else {
            this.isAttackAlert = false;
            System.out.println("Setting attackHero false 1 " + this.attackHero);
            this.attackHero = false;
            this.attackCounter = 0;
            this.attackPause = 0;
            System.out.println("6 attackPause = " + this.attackPause);
            this.isAstarPath = false;
        }
    }

    protected void followAstar2(Astar4 astar, int minPathSize) {
        if (astar.isPath()) {
            this.isAstarPath = true;
            this.setAttackSpeed();
            this.faceHero();
            this.dy = 0;
            this.dx = 0;
            this.moving = true;
            this.astarPath = astar.getPathToEnd();
            Point[] rectPoints = Animator.getBoard().getRectCorners(this.rect);
            byte tileLoc = this.findRectLocationInMapTile(this.astarPath.get(0), rectPoints);
            byte nextLoc = 0;
            if (this.astarPath.size() > 1) {
                nextLoc = this.getAttackNextTile();
            }
            if (this.astarPath.size() > minPathSize) {
                this.moveAttackPath(tileLoc, nextLoc);
            } else {
                this.moveAttackPathFinal(tileLoc, nextLoc);
            }
        } else {
            this.isAttackAlert = false;
            System.out.println("Setting attackHero false 2 " + this.attackHero);
            this.attackHero = false;
            this.attackCounter = 0;
            this.attackPause = 0;
            this.isAstarPath = false;
        }
    }

    protected void doAttackStyle2() {
        if (!this.gettingHit.booleanValue() && this.checkHeroAcross2() || this.attacking) {
            this.setAttackDraw();
            this.attack3bullet();
            return;
        }
        Astar4 astar = this.findAttackSpot4();
        if (astar == null) {
            this.isAttackAlert = false;
            this.attackHero = false;
            this.attackCounter = 0;
            this.attackPause = 0;
            return;
        }
        this.followAstar(astar);
    }

    protected void doAttackStyle2_2() {
        if (!this.gettingHit.booleanValue() && this.checkHeroAcross2_2() || this.attacking) {
            this.setAttackDraw();
            this.attack3bullet();
            return;
        }
        Astar4 astar = this.findAttackSpot4();
        if (astar == null) {
            this.isAttackAlert = false;
            this.attackHero = false;
            this.attackCounter = 0;
            this.attackPause = 0;
            return;
        }
        this.followAstar(astar);
    }

    protected void doAttackStyle3(Astar4 astar, int soundNum, int astarMin) {
        if (astar.isPath()) {
            if (this.attackPause == 0) {
                if (soundNum != -1) {
                    this.playSound(soundNum);
                }
                this.attackPauseRangeValue = this.rand.nextInt(this.attackPauseRange.y - this.attackPauseRange.x);
                this.attackPauseRangeValue += this.attackPauseRange.x;
            }
            if (this.attackPause == this.attackPauseRangeValue - 1) {
                this.attackPauseFinished = true;
                ++this.attackPause;
            }
            if (this.attackPause < this.attackPauseRangeValue) {
                ++this.attackPause;
                this.isAttackAlert = true;
                this.faceHero();
            } else {
                this.followAstar2(astar, astarMin);
                this.isAttackAlert = false;
            }
        } else if (this.attacking || this.isAttackAlert || this.attackAlertState || this.attackHero.booleanValue()) {
            System.out.println("Enemy stop attack 5");
            this.stopAttack();
        }
    }

    protected void doAttackStyle4() {
        if (this.attackCounter == 0) {
            this.attackPause = this.rand.nextInt(this.attackPauseRange.y - this.attackPauseRange.x);
            this.attackPause += this.attackPauseRange.x;
            this.playSounds((short)7);
        }
        if (this.attackCounter < this.attackPause) {
            this.isAttackAlert = true;
        }
        if (this.attackCounter == this.attackPause) {
            short imgNum;
            String slimeNeckName;
            String slimeHeadName;
            this.isAttackAlert = false;
            this.attacking = true;
            System.out.println("Setting attackHero true 1 " + this.attackHero);
            this.attackHero = true;
            if (this.enemyType == "slimeBlue") {
                slimeHeadName = "slimeBlueHead";
                slimeNeckName = "slimeBlueNeck";
                imgNum = 6;
            } else if (this.enemyType == "slimeRed") {
                slimeHeadName = "slimeRedHead";
                slimeNeckName = "slimeRedNeck";
                imgNum = 7;
            } else {
                slimeHeadName = "default";
                slimeNeckName = "default";
                imgNum = -1;
            }
            slimeAttack1 slimeHit = new slimeAttack1(this.getX(), this.getY(), this.rangeDamage, this.projectileRange, this.direction, true, slimeHeadName, this, 0, 4, null, imgNum);
            Animator.getBoard().getWeaponHitArray().add(slimeHit);
            int i = 1;
            while (i <= this.projectileRange + 1) {
                Animator.getBoard().getWeaponHitArray().add(new slimeAttack1(this.getX(), this.getY(), this.rangeDamage, this.projectileRange, this.direction, true, slimeNeckName, this, (short)i, 4, slimeHit, imgNum));
                ++i;
            }
        }
        ++this.attackCounter;
    }

    protected void doAttackStyle5() {
        if (this.attackCounter == 0) {
            this.attackPause = this.rand.nextInt(this.attackPauseRange.y - this.attackPauseRange.x);
            this.attackPause += this.attackPauseRange.x;
            this.isAttackAlert = true;
            this.playSounds((short)7);
        } else if (this.attackCounter < this.attackPause) {
            this.isAttackAlert = true;
        } else if (this.attackCounter == this.attackPause) {
            int[][] trajectory = Animator.findTrajectoryInt(this.enemyPoint, this.heroPoint, this.attackSpeed);
            Animator.getBoard().getWeaponHitArray().add(new projectileHit(this.getX(), this.getY(), this.rangeDamage, (short)this.attackImgeIndex, trajectory, this.projectileRange, this.projectileRect));
            this.isAttackAlert = false;
            this.attacking = true;
            System.out.println("Setting attackHero true 2 " + this.attackHero);
            this.attackHero = true;
            this.attackPostPauseTemp = this.attackPostPause + this.attackCounter;
        } else if (this.attackCounter >= this.attackPostPauseTemp) {
            this.attackHoldCounter = 1;
            System.out.println("Enemy stop attack 4");
            this.stopAttack();
            --this.attackCounter;
        }
        ++this.attackCounter;
    }

    protected void doAttackStyle6() {
        this.dx = this.trajectoryAry[0][this.trajCounter];
        this.dy = this.trajectoryAry[1][this.trajCounter];
        this.totTravel += Math.abs(this.trajectoryAry[0][this.trajCounter]);
        this.totTravel += Math.abs(this.trajectoryAry[1][this.trajCounter]);
        ++this.trajCounter;
        if (this.trajCounter >= 10) {
            this.trajCounter = 0;
        }
        if (this.totTravel > this.attackRange * 2 * (Animator.scale / 2)) {
            this.attackFinished = true;
        }
    }

    protected void doAttackStyle7(int x, int y, int damage, int durraiton, short imgNum, int wepType, Clip sound) {
        if (this.dropWepCounter == 0) {
            this.dropWepTime = this.rand.nextInt(this.dropTimeRange.y - this.dropTimeRange.x);
            this.dropWepTime += this.dropTimeRange.x;
            this.dropWepCounter = 1;
        } else if (this.dropWepCounter > 0) {
            if (this.dropWepCounter > this.dropWepTime) {
                this.dropWepCounter = 0;
                slime1Stationary tempWep = null;
                switch (wepType) {
                    case 1: {
                        tempWep = new slime1Stationary(x, y, damage, durraiton, imgNum);
                        break;
                    }
                    default: {
                        throw new GameException("Enemies doAttackStyle7 : No wepType found for " + wepType);
                    }
                }
                Animator.getBoard().getWeaponHitArray().add(tempWep);
                if (sound != null) {
                    Animator.getBoard().playSounds(sound, null);
                }
            } else {
                ++this.dropWepCounter;
            }
        }
    }

    protected Astar4 getAOEAttackSpot(Point target, boolean charge) {
        Point tempPoint = new Point(0, 0);
        Astar4 astar = null;
        boolean atkPtReachable = true;
        target = this.gridAttackPoint(target);
        this.AOEPointsAry.clear();
        int i = 0;
        while (i < this.AOEPointsDist.size()) {
            tempPoint.setLocation(target.x + this.AOEPointsDist.get((int)i).x, target.y + this.AOEPointsDist.get((int)i).y);
            this.AOEPointsAry.add(new AOEPoints(tempPoint.getLocation(), (int)(Animator.findDistance(tempPoint, this.enemyPoint) * 1000.0f)));
            ++i;
        }
        Collections.sort(this.AOEPointsAry);
        while (true) {
            if (this.AOEPointsAry.size() > 0 && (this.checkAttackPoint(this.AOEPointsAry.get((int)0).spot) || this.checkPathRectCol(this.makePointRect(this.AOEPointsAry.get((int)0).spot, (int)this.rect.getWidth(), (int)this.rect.getHeight())) || Animator.getBoard().isRectInTile(Animator.getBoard().getMapFromPoint(this.AOEPointsAry.get((int)0).spot)) || !atkPtReachable)) {
                atkPtReachable = true;
                this.AOEPointsAry.remove(0);
                continue;
            }
            if (this.AOEPointsAry.size() < 1) {
                return null;
            }
            astar = new Astar4(this.findClosestTile(), Animator.getBoard().getMapFromPoint(this.AOEPointsAry.get((int)0).spot), this, false);
            atkPtReachable = astar.isPath();
            if (charge && atkPtReachable) {
                Point[] sourcePoints = new Point[4];
                Point[] targetPoints = new Point[4];
                sourcePoints[0] = this.rect.getLocation();
                targetPoints[0] = this.heroRectXYPoint;
                sourcePoints[1] = new Point(this.rectXW, this.rectY);
                targetPoints[1] = new Point(this.heroRectXW, (int)this.heroRectXYPoint.getY());
                sourcePoints[2] = new Point(this.rectX, this.rectYH);
                targetPoints[2] = new Point((int)this.heroRectXYPoint.getX(), this.heroRectYH);
                sourcePoints[3] = new Point(this.rectXW, this.rectYH);
                targetPoints[3] = new Point(this.heroRectXW, this.heroRectYH);
                atkPtReachable = this.chkCharge(sourcePoints, targetPoints);
            }
            if (atkPtReachable) break;
        }
        this.attackPoint = this.AOEPointsAry.get((int)0).spot;
        return astar;
    }

    private boolean checkHeroAcross2() {
        int heroX = Animator.getBoard().getHero().getRectX();
        int heroY = Animator.getBoard().getHero().getRectY();
        int heroXW = Animator.getBoard().getHero().getRectXW();
        int heroYH = Animator.getBoard().getHero().getRectYH();
        if ((this.direction == 1 || this.direction == 3 || this.direction == 5 || this.direction == 6 || this.direction == 7 || this.direction == 8) && this.enemyPoint.x >= heroX + this.attackIndent && this.enemyPoint.x <= heroXW - this.attackIndent || (this.direction == 2 || this.direction == 4) && this.enemyPoint.y >= heroY + this.attackIndent && this.enemyPoint.y <= heroYH - this.attackIndent) {
            if (!this.attacking) {
                this.faceHero();
            }
            this.attacking = true;
            return true;
        }
        return false;
    }

    protected boolean checkHeroAcross2_2() {
        int heroX = Animator.getBoard().getHero().getRectX();
        int heroY = Animator.getBoard().getHero().getRectY();
        int heroXW = Animator.getBoard().getHero().getRectXW();
        int heroYH = Animator.getBoard().getHero().getRectYH();
        return (this.direction == 1 || this.direction == 3 || this.direction == 5 || this.direction == 6 || this.direction == 7 || this.direction == 8) && this.enemyPoint.x >= heroX + this.attackIndent && this.enemyPoint.x <= heroXW - this.attackIndent || (this.direction == 2 || this.direction == 4) && this.enemyPoint.y >= heroY + this.attackIndent && this.enemyPoint.y <= heroYH - this.attackIndent;
    }

    protected void attack3bullet() {
        this.dy = 0;
        this.dx = 0;
        if (this.attackCounter == 0) {
            this.playSounds((short)6);
        }
        if (this.attacking && !this.gettingHit.booleanValue()) {
            ++this.attackCounter;
            if (this.attackCounter % 20 == 0 && this.attackCounter >= 40 && this.attackCounter <= 80) {
                Point bulletPoint = this.getAtkDir(this.direction);
                Animator.getBoard().getWeaponHitArray().add(new heroGunHit(bulletPoint.x, bulletPoint.y, true, this.rangeDamage, this.projectileRange, this.direction));
            }
            if (this.attackCounter > 100) {
                this.attackCounter = 0;
                this.attacking = false;
            }
        }
    }

    protected void attackAOE5() {
        this.dy = 0;
        this.dx = 0;
        if (this.attackCounter == 0) {
            this.playSounds((short)6);
        }
        if (this.attacking && !this.gettingHit.booleanValue()) {
            ++this.attackCounter;
            if (this.attackCounter == this.attackChargeTime) {
                Point AOECenterPoint = this.enemyPoint.getLocation();
                Animator.getBoard().getWeaponHitArray().add(new AOEelectricHit((int)AOECenterPoint.getX(), (int)AOECenterPoint.getY(), this.rangeDamage, this.attackDuration, this.attackRange, this.attackChargeTime, this.enemyPoint.getLocation(), this));
            }
            if (this.attackCounter > this.attackDuration) {
                this.attackCounter = 0;
                this.attacking = false;
            }
        }
    }

    private Boolean checkRectAstarNeighbor(Point mapPoint, byte direction) {
        if (direction == 7 || direction == 8 || direction == 9) {
            mapPoint.y -= Animator.scale;
        }
        if (direction == 1 || direction == 2 || direction == 3) {
            mapPoint.y += Animator.scale;
        }
        if (direction == 1 || direction == 4 || direction == 7) {
            mapPoint.x -= Animator.scale;
        }
        if (direction == 9 || direction == 6 || direction == 3) {
            mapPoint.x += Animator.scale;
        }
        return Animator.getBoard().isRectInTile(Animator.getBoard().getMapFromPoint(mapPoint));
    }

    private void moveAttackPath(byte tileLoc, byte nextLoc) {
        byte direction = -1;
        Boolean goDirect = false;
        if (this.astarPath.size() > 2) {
            int i;
            Boolean foundRect;
            int neg = 1;
            if (nextLoc == 4 || nextLoc == 8) {
                neg = -1;
            }
            if (nextLoc == 6 || nextLoc == 4) {
                int i2 = 2;
                while (i2 < this.astarPath.size()) {
                    if (this.astarPath.get((int)i2).y < this.astarPath.get((int)0).y) {
                        direction = 8;
                        break;
                    }
                    if (this.astarPath.get((int)i2).y > this.astarPath.get((int)0).y) {
                        direction = 2;
                        break;
                    }
                    ++i2;
                }
                foundRect = false;
                if ((tileLoc == 7 || tileLoc == 8 || tileLoc == 9) && direction == 8) {
                    i = 0;
                    while (i < 2) {
                        if (this.checkRectAstarNeighbor(this.astarPath.get(i).getLocation(), direction).booleanValue()) {
                            foundRect = true;
                            break;
                        }
                        ++i;
                    }
                    if (!foundRect.booleanValue()) {
                        this.dx = this.speed * neg;
                        goDirect = true;
                    }
                } else if ((tileLoc == 1 || tileLoc == 2 || tileLoc == 3) && direction == 2) {
                    i = 0;
                    while (i < 2) {
                        if (this.checkRectAstarNeighbor(this.astarPath.get(i).getLocation(), direction).booleanValue()) {
                            foundRect = true;
                            break;
                        }
                        ++i;
                    }
                    if (!foundRect.booleanValue()) {
                        this.dx = this.speed * neg;
                        goDirect = true;
                    }
                }
            } else if (nextLoc == 8 || nextLoc == 2) {
                int i3 = 2;
                while (i3 < this.astarPath.size()) {
                    if (this.astarPath.get((int)i3).x < this.astarPath.get((int)0).x) {
                        direction = 4;
                        break;
                    }
                    if (this.astarPath.get((int)i3).x > this.astarPath.get((int)0).x) {
                        direction = 6;
                        break;
                    }
                    ++i3;
                }
                foundRect = false;
                if ((tileLoc == 1 || tileLoc == 4 || tileLoc == 7) && direction == 4) {
                    i = 0;
                    while (i < 2) {
                        if (this.checkRectAstarNeighbor(this.astarPath.get(i).getLocation(), direction).booleanValue()) {
                            foundRect = true;
                            break;
                        }
                        ++i;
                    }
                    if (!foundRect.booleanValue()) {
                        this.dy = this.speed * neg;
                        goDirect = true;
                    }
                } else if ((tileLoc == 3 || tileLoc == 6 || tileLoc == 9) && direction == 6) {
                    i = 0;
                    while (i < 2) {
                        if (this.checkRectAstarNeighbor(this.astarPath.get(i).getLocation(), direction).booleanValue()) {
                            foundRect = true;
                            break;
                        }
                        ++i;
                    }
                    if (!foundRect.booleanValue()) {
                        this.dy = this.speed * neg;
                        goDirect = true;
                    }
                }
            }
        } else {
            this.astarPath.size();
        }
        if (!goDirect.booleanValue()) {
            int minx = this.astarPath.get((int)1).x;
            int maxx = this.astarPath.get((int)1).x + Animator.scale;
            int miny = this.astarPath.get((int)1).y;
            int maxy = this.astarPath.get((int)1).y + Animator.scale;
            if (nextLoc == 8) {
                this.dy = -this.speed;
            } else if (nextLoc == 6) {
                this.dx = this.speed;
            } else if (nextLoc == 4) {
                this.dx = -this.speed;
            } else if (nextLoc == 2) {
                this.dy = this.speed;
            } else if (nextLoc == 7) {
                this.dy = -this.speed;
                this.dx = -this.speed;
            } else if (nextLoc == 9) {
                this.dy = -this.speed;
                this.dx = this.speed;
            } else if (nextLoc == 1) {
                this.dy = this.speed;
                this.dx = -this.speed;
            } else if (nextLoc == 3) {
                this.dy = this.speed;
                this.dx = this.speed;
            }
            if (nextLoc == 8 || nextLoc == 2) {
                if (tileLoc == 7 || tileLoc == 4 || tileLoc == 1) {
                    this.dx = this.speed;
                    if (this.rect.getX() + (double)this.dx > (double)minx) {
                        this.dx = (int)((double)minx - this.rect.getX());
                    }
                } else if (tileLoc == 9 || tileLoc == 6 || tileLoc == 3) {
                    this.dx = -this.speed;
                    if (this.rect.getX() + this.rect.getWidth() + (double)this.dx < (double)maxx) {
                        this.dx = (int)((double)maxx - (this.rect.getX() + this.rect.getWidth()));
                    }
                }
            } else if (nextLoc == 6 || nextLoc == 4) {
                if (tileLoc == 7 || tileLoc == 8 || tileLoc == 9) {
                    this.dy = this.speed;
                    if (this.rect.getY() + (double)this.dy > (double)miny) {
                        this.dy = (int)((double)miny - this.rect.getY());
                    }
                } else if (tileLoc == 1 || tileLoc == 2 || tileLoc == 3) {
                    this.dy = -this.speed;
                    if (this.rect.getY() + this.rect.getHeight() + (double)this.dy < (double)maxy) {
                        this.dy = (int)((double)maxy - (this.rect.getY() + this.rect.getHeight()));
                    }
                }
            }
        }
    }

    private void moveAttackPathFinal(byte tileLoc, byte nextLoc) {
        Boolean goDirect = true;
        Point checkPoint = new Point(0, 0);
        if (this.astarPath.size() != 1) {
            if (nextLoc == 8 || nextLoc == 2) {
                if (tileLoc == 9 || tileLoc == 6 || tileLoc == 3) {
                    checkPoint.setLocation(this.astarPath.get((int)1).x + Animator.scale, this.astarPath.get((int)1).y);
                    if (Animator.getBoard().isRectInTile(Animator.getBoard().getMapFromPoint(checkPoint.getLocation()))) {
                        this.moveAttackPath(tileLoc, nextLoc);
                        goDirect = false;
                    }
                }
                if (tileLoc == 7 || tileLoc == 4 || tileLoc == 1) {
                    checkPoint.setLocation(this.astarPath.get((int)1).x - Animator.scale, this.astarPath.get((int)1).y);
                    if (Animator.getBoard().isRectInTile(Animator.getBoard().getMapFromPoint(checkPoint.getLocation()))) {
                        this.moveAttackPath(tileLoc, nextLoc);
                        goDirect = false;
                    }
                }
            } else if (nextLoc == 4 || nextLoc == 6) {
                if (tileLoc == 7 || tileLoc == 8 || tileLoc == 9) {
                    checkPoint.setLocation(this.astarPath.get((int)1).x, this.astarPath.get((int)1).y - Animator.scale);
                    if (Animator.getBoard().isRectInTile(Animator.getBoard().getMapFromPoint(checkPoint.getLocation()))) {
                        this.moveAttackPath(tileLoc, nextLoc);
                        goDirect = false;
                    }
                }
                if (tileLoc == 1 || tileLoc == 2 || tileLoc == 3) {
                    checkPoint.setLocation(this.astarPath.get((int)1).x, this.astarPath.get((int)1).y + Animator.scale);
                    if (Animator.getBoard().isRectInTile(Animator.getBoard().getMapFromPoint(checkPoint.getLocation()))) {
                        this.moveAttackPath(tileLoc, nextLoc);
                        goDirect = false;
                    }
                }
            }
        }
        if (goDirect.booleanValue()) {
            if (this.attackPoint.x > this.enemyPoint.x) {
                this.dx = this.speed;
                if (this.dx + this.enemyPoint.x > this.attackPoint.x) {
                    this.dx = this.attackPoint.x - this.enemyPoint.x;
                }
            } else if (this.attackPoint.x < this.enemyPoint.x) {
                this.dx = -this.speed;
                if (this.dx + this.enemyPoint.x < this.attackPoint.x) {
                    this.dx = this.attackPoint.x - this.enemyPoint.x;
                }
            }
            if (this.attackPoint.y > this.enemyPoint.y) {
                this.dy = this.speed;
                if (this.dy + this.enemyPoint.y > this.attackPoint.y) {
                    this.dy = this.attackPoint.y - this.enemyPoint.y;
                }
            } else if (this.attackPoint.y < this.enemyPoint.y) {
                this.dy = -this.speed;
                if (this.dy + this.enemyPoint.y < this.attackPoint.y) {
                    this.dy = this.attackPoint.y - this.enemyPoint.y;
                }
            }
        }
    }

    private byte getAttackNextTile() {
        int nextLoc = -1;
        Boolean checkAdjTile = false;
        Point checkTileRect = new Point(0, 0);
        Point tile1 = null;
        Point tile2 = null;
        if (this.astarPath.size() > 2) {
            if (this.astarPath.get((int)0).y < this.astarPath.get((int)2).y && this.astarPath.get((int)0).x != this.astarPath.get((int)1).x) {
                checkTileRect.x = this.astarPath.get((int)0).x;
                checkTileRect.y = this.astarPath.get((int)0).y + Animator.scale;
                checkAdjTile = true;
            } else if (this.astarPath.get((int)0).x > this.astarPath.get((int)2).x && this.astarPath.get((int)0).y != this.astarPath.get((int)1).y) {
                checkTileRect.x = this.astarPath.get((int)0).x - Animator.scale;
                checkTileRect.y = this.astarPath.get((int)0).y;
                checkAdjTile = true;
            } else if (this.astarPath.get((int)0).y > this.astarPath.get((int)2).y && this.astarPath.get((int)0).x != this.astarPath.get((int)1).x) {
                checkTileRect.x = this.astarPath.get((int)0).x;
                checkTileRect.y = this.astarPath.get((int)0).y - Animator.scale;
                checkAdjTile = true;
            } else if (this.astarPath.get((int)0).x < this.astarPath.get((int)2).x && this.astarPath.get((int)0).y != this.astarPath.get((int)1).y) {
                checkTileRect.x = this.astarPath.get((int)0).x + Animator.scale;
                checkTileRect.y = this.astarPath.get((int)0).y;
                checkAdjTile = true;
            }
            if (checkAdjTile.booleanValue() && !Animator.getBoard().isRectInTile(Animator.getBoard().getMapFromPoint(checkTileRect.getLocation()))) {
                tile1 = this.astarPath.get(0);
                tile2 = this.astarPath.get(2);
            } else {
                tile1 = this.astarPath.get(0);
                tile2 = this.astarPath.get(1);
            }
        } else {
            tile1 = this.astarPath.get(0);
            tile2 = this.astarPath.get(1);
        }
        if (tile1.x == tile2.x || tile1.y == tile2.y) {
            if (tile1.x < tile2.x) {
                nextLoc = 6;
            }
            if (tile1.x > tile2.x) {
                nextLoc = 4;
            }
            if (tile1.y < tile2.y) {
                nextLoc = 2;
            }
            if (tile1.y > tile2.y) {
                nextLoc = 8;
            }
        } else {
            if (tile1.x < tile2.x && tile1.y < tile2.y) {
                nextLoc = 3;
            }
            if (tile1.x > tile2.x && tile1.y < tile2.y) {
                nextLoc = 1;
            }
            if (tile1.x < tile2.x && tile1.y > tile2.y) {
                nextLoc = 9;
            }
            if (tile1.x > tile2.x && tile1.y > tile2.y) {
                nextLoc = 7;
            }
        }
        return (byte)nextLoc;
    }

    protected void faceHero() {
        this.direction = this.heroPoint.x < this.enemyPoint.x ? (short)4 : (short)2;
        if (Math.abs(this.heroPoint.y - this.enemyPoint.y) > Math.abs(this.heroPoint.x - this.enemyPoint.x)) {
            this.direction = this.heroPoint.y < this.enemyPoint.y ? (short)1 : (short)3;
        }
    }

    private void slideEnemy() {
        if (this.colliding.booleanValue() && !this.gettingHit.booleanValue()) {
            if ((this.direction == 1 || this.direction == 3) && this.heroPoint.x > this.enemyPoint.x) {
                this.dx = (int)(this.attackSpeedFloat / 2.0f);
                if (this.dx + this.enemyPoint.x > this.heroPoint.x) {
                    this.dx = this.enemyPoint.x - this.heroPoint.x;
                }
            } else if ((this.direction == 1 || this.direction == 3) && this.heroPoint.x < this.enemyPoint.x) {
                this.dx = -((int)(this.attackSpeedFloat / 2.0f));
                if (this.dx + this.enemyPoint.x < this.heroPoint.x) {
                    this.dx = this.enemyPoint.x - this.heroPoint.x;
                }
            } else if ((this.direction == 2 || this.direction == 4) && this.heroPoint.y > this.enemyPoint.y) {
                this.dy = (int)(this.attackSpeedFloat / 2.0f);
                if (this.dy + this.enemyPoint.y > this.heroPoint.y) {
                    this.dy = this.enemyPoint.y - this.heroPoint.y;
                }
            } else if ((this.direction == 2 || this.direction == 4) && this.heroPoint.y < this.enemyPoint.y) {
                this.dy = -((int)(this.attackSpeedFloat / 2.0f));
                if (this.dy + this.enemyPoint.y < this.heroPoint.y) {
                    this.dy = this.enemyPoint.y - this.heroPoint.y;
                }
            }
            if (this.direction == 1 || this.direction == 3) {
                boolean rightFree = false;
                boolean leftFree = false;
                if (this.heroRectXYPoint.x < this.collidingMapTileL1.getX() + Animator.scale && this.heroRectXW > this.collidingMapTileL1.getX()) {
                    if (!Animator.getBoard().isRectInTile(Animator.getBoard().getMapTileRealtion(this.collidingMapTileL1, 1, 0))) {
                        rightFree = true;
                    }
                    if (!Animator.getBoard().isRectInTile(Animator.getBoard().getMapTileRealtion(this.collidingMapTileL1, -1, 0))) {
                        leftFree = true;
                    }
                }
                if (rightFree && !leftFree) {
                    this.dx = (int)(this.attackSpeedFloat / 2.0f);
                } else if (!rightFree && leftFree) {
                    this.dx = -((int)(this.attackSpeedFloat / 2.0f));
                } else if (rightFree && leftFree) {
                    this.dx = this.enemyPoint.x > this.collidingMapTileL1.getX() + Animator.scale / 2 ? (int)(this.attackSpeedFloat / 2.0f) : -((int)(this.attackSpeedFloat / 2.0f));
                }
            }
            if (this.direction == 2 || this.direction == 4) {
                boolean upFree = false;
                boolean downFree = false;
                if (this.heroRectXYPoint.y < this.collidingMapTileL1.getY() + Animator.scale && this.heroRectYH > this.collidingMapTileL1.getY()) {
                    if (!Animator.getBoard().isRectInTile(Animator.getBoard().getMapTileRealtion(this.collidingMapTileL1, 0, -1))) {
                        upFree = true;
                    }
                    if (!Animator.getBoard().isRectInTile(Animator.getBoard().getMapTileRealtion(this.collidingMapTileL1, 0, 1))) {
                        downFree = true;
                    }
                }
                if (upFree && !downFree) {
                    this.dy = -((int)(this.attackSpeedFloat / 2.0f));
                } else if (!upFree && downFree) {
                    this.dy = (int)(this.attackSpeedFloat / 2.0f);
                } else if (upFree && downFree) {
                    this.dy = this.enemyPoint.y > this.collidingMapTileL1.getY() + Animator.scale / 2 ? (int)(this.attackSpeedFloat / 2.0f) : -((int)(this.attackSpeedFloat / 2.0f));
                }
            }
        }
    }

    public int[][] getDirDraw() {
        return this.dirDraw;
    }

    public int getEnemyStep() {
        return this.enemyStep;
    }

    public void setEnemyStep(int enemyStep) {
        this.enemyStep = enemyStep;
    }

    public short getDirection() {
        return this.direction;
    }

    public int getEnemyArraySpot() {
        return this.enemyArraySpot;
    }

    public int getHitCounter() {
        return this.hitCounter;
    }

    public int getRangeDamage() {
        return this.rangeDamage;
    }

    public int getPhysicalDamage() {
        return this.physicalDamage;
    }

    public Boolean getGettingHit() {
        return this.gettingHit;
    }

    public Boolean getRemove() {
        return this.remove;
    }

    public int getHealth() {
        return this.health;
    }

    public Line2D getAttackLine() {
        return this.attackLine;
    }

    public Boolean getIsBurning() {
        return this.isBurning;
    }

    public void setIsBurning(Boolean isBurning) {
        this.isBurning = isBurning;
    }

    public void setBurnDamage(int burnDamage) {
        this.burnDamage = burnDamage;
    }

    public int[] getImgFlameLoc() {
        return this.imgFlameLoc;
    }

    public void setMapAreaTL(MapMain mapAreaTL) {
        this.mapAreaTL = mapAreaTL;
    }

    public Point getHeroPoint() {
        return this.heroPoint;
    }

    public int getinvincibleAttackCounter() {
        return this.invincibleAttackCounter;
    }

    public void setAttackHero(Boolean attackHero) {
        this.attackHero = attackHero;
    }

    public void setAttacking(Boolean attacking) {
        this.attacking = attacking;
    }

    public Point getEnemyPoint() {
        return this.enemyPoint;
    }

    public int getAttackPostPause() {
        return this.attackPostPause;
    }

    public void setIsAttackAlert(Boolean isAttackAlert) {
        this.isAttackAlert = isAttackAlert;
    }

    public void setAttackPause(int attackPuse) {
        this.attackPause = attackPuse;
        System.out.println("4 attackPause = " + this.attackPause);
    }

    public boolean getRemoveAttackObj() {
        return this.removeAttackObj;
    }

    public void setHeroGotHit(Boolean heroGotHit) {
        this.heroGotHit = heroGotHit;
    }

    public MapMain getFindClosestTile() {
        return this.findClosestTile();
    }

    public void playSound(int soundNum) {
    }

    private class AOEPoints
    implements Comparable<AOEPoints> {
        Point spot;
        int range;

        public AOEPoints(Point spot, int range) {
            this.spot = spot;
            this.range = range;
        }

        public int getRange() {
            return this.range;
        }

        @Override
        public int compareTo(AOEPoints comps) {
            int compareQuantity = comps.getRange();
            return this.range - compareQuantity;
        }
    }

    private class cBurnedEnemies<burnEnemies, coolDownTimer> {
        private Enemies enemy;
        private int coolDownTimer;

        public cBurnedEnemies(Enemies enemy, int coolDownTimer) {
            this.enemy = enemy;
            this.coolDownTimer = coolDownTimer;
        }
    }
}

