/*
 * Decompiled with CFR 0.152.
 */
package mapClass;

import Engine.Animator;
import Engine.MapMain;
import SecItemsClass.hookShotRing;
import enemiesClass.BrownWolf;
import enemiesClass.Glork1;
import enemiesClass.RedWolf;
import enemiesClass.Robot1;
import enemiesClass.RobotElec;
import enemiesClass.bat1;
import enemiesClass.manCharge;
import enemiesClass.slimeBlack;
import enemiesClass.slimeBlue;
import enemiesClass.slimeGreen;
import enemiesClass.slimeGreenUnder;
import enemiesClass.slimeRed;
import enemiesClass.slimeSilver;
import enemiesClass.slimeYellow;
import exceptions.GameException;
import java.awt.Point;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import mapClass.Areas;
import mapClass.MapEnemies;
import pickups.Bazooka;
import pickups.Coins;
import pickups.FlameThrower;
import pickups.Gun;
import pickups.Knife;
import pickups.LaserGun;
import pickups.PickUpC4;
import pickups.PickUpHealthUpgarde;
import pickups.PickUpHookshot;
import pickups.PickUpScrew;
import pickups.PickUpShield;
import pickups.PickUpTech;
import pickups.ShotGun;
import pickups.Syringe;

public class MakeMaps {
    private static ArrayList<MapEnemies> mapEnemies = new ArrayList();

    public static void loadMap(int mapNum) {
        String line = "";
        String map = "";
        mapEnemies.clear();
        try {
            InputStream is = MakeMaps.class.getResourceAsStream(MakeMaps.setMapFile(mapNum));
            BufferedReader reader = new BufferedReader(new InputStreamReader(is));
            while ((line = reader.readLine()) != null) {
                map = String.valueOf(map) + line;
            }
            reader.close();
        }
        catch (Exception e) {
            System.err.format("Exception occurred trying to read '%s'.", MakeMaps.setMapFile(mapNum));
            e.printStackTrace();
        }
        map.equals(map.replace("\n", ""));
        int x = 0;
        int y = 0;
        int i = 0;
        while (i < map.length() - 10) {
            String l1 = map.substring(i + 1, i + 3);
            String l1s = map.substring(i + 3, i + 4);
            String sanity = String.valueOf(l1) + l1s;
            if (l1.equals(",,")) break;
            if (sanity.contains("\"") || sanity.contains(",")) {
                throw new GameException("L1 sanity check not passed at x: " + x + " and y: " + y + " l1 = " + l1);
            }
            if (!l1.equals("--") && !l1.equals("QQ") && MakeMaps.setNoTiles(l1, l1s, x, y, mapNum).booleanValue()) {
                Animator.getBoard().getMapMainArrayL1().add(new MapMain(x, y, l1, l1s, new Point(x, y), 0, mapNum));
            }
            String l2 = map.substring(i + 4, i + 6);
            String l2s = map.substring(i + 6, i + 7);
            sanity = String.valueOf(l2) + l2s;
            if (sanity.contains("\"") || sanity.contains(",")) {
                throw new GameException("L2 sanity check not passed at x: " + x + " and y: " + y + " l2 = " + l2);
            }
            if (!l2.equals("--") && MakeMaps.setNoTiles(l2, l2s, x, y, mapNum).booleanValue()) {
                Animator.getBoard().getMapMainArrayL2().add(new MapMain(x, y, l2, l2s, new Point(x, y), 1, mapNum));
            }
            String l3 = map.substring(i + 7, i + 9);
            String l3s = map.substring(i + 9, i + 10);
            sanity = String.valueOf(l3) + l3s;
            if (sanity.contains("\"") || sanity.contains(",")) {
                throw new GameException("L3 sanity check not passed at x: " + x + " and y: " + y + " l3 = " + l3);
            }
            if (!l3.equals("--") && MakeMaps.setNoTiles(l3, l3s, x, y, mapNum).booleanValue()) {
                l3.equals("WY");
                Animator.getBoard().getMapMainArrayL3().add(new MapMain(x, y, l3, l3s, new Point(x, y), 2, mapNum));
            }
            ++x;
            if (i < map.length() - 11 && map.charAt(i + 11) == ',') {
                ++i;
            } else {
                Animator.getBoard().setMapLen(x);
                x = 0;
                ++y;
            }
            i += 11;
        }
        Animator.getBoard().setMapHight(y);
        MakeMaps.mapSanityCheck();
        MakeMaps.createEnemies();
        if (Animator.getBoard().getHero().getHeroTransTileDest().x != 0 || Animator.getBoard().getHero().getHeroTransTileDest().y != 0) {
            Animator.getBoard().getHero().setX(Animator.getBoard().getHero().getHeroTransTileDest().x);
            Animator.getBoard().getHero().setY(Animator.getBoard().getHero().getHeroTransTileDest().y);
            Animator.getBoard().getHero().setHeroTransTileDest(new Point(0, 0));
        }
    }

    private static void createEnemies() {
        for (MapEnemies me : mapEnemies) {
            MakeMaps.createEnemy(me.getTag(), me.getX(), me.getY());
        }
    }

    private static void mapSanityCheck() {
        if (Animator.getBoard().getAreas().size() == 0) {
            throw new GameException("No areas found in map file mapNum");
        }
        for (Areas areaAry : Animator.getBoard().getAreas()) {
            if (!areaAry.getMapBR().equals(null)) continue;
            throw new GameException("Missing BR in areas array: " + areaAry.getAreaName());
        }
        int i = 0;
        while (i < Animator.getBoard().getAreas().size()) {
            int i2 = i + 1;
            while (i2 < Animator.getBoard().getAreas().size()) {
                if (Animator.getBoard().getAreas().get(i).getAreaName().equals(Animator.getBoard().getAreas().get(i2).getAreaName())) {
                    throw new GameException("Duplicate area found in map: " + Animator.getBoard().getAreas().get(i).getAreaName() + " at " + i + " and " + i2);
                }
                ++i2;
            }
            ++i;
        }
    }

    private static Boolean setNoTiles(String tileTag, String secret, int x, int y, int mapNum) {
        switch (secret) {
            case "H": {
                if (Animator.getBoard().getHero().getHeroTransTileDest().x == 0 && Animator.getBoard().getHero().getHeroTransTileDest().y == 0) {
                    Animator.getBoard().getHero().setX(x);
                    Animator.getBoard().getHero().setY(y);
                } else {
                    Animator.getBoard().getHero().setX(Animator.getBoard().getHero().getHeroTransTileDest().x);
                    Animator.getBoard().getHero().setY(Animator.getBoard().getHero().getHeroTransTileDest().y);
                    Animator.getBoard().getHero().setHeroTransTileDest(new Point(0, 0));
                }
                return false;
            }
            case "E": {
                mapEnemies.add(new MapEnemies(tileTag, x, y));
                return false;
            }
            case "I": {
                MakeMaps.setItem(tileTag, x, y, mapNum);
                return false;
            }
        }
        return true;
    }

    private static void createEnemy(String tileTag, int x, int y) {
        switch (tileTag) {
            case "BW": {
                Animator.getBoard().addEnemyArray(new BrownWolf(x, y));
                break;
            }
            case "RW": {
                Animator.getBoard().addEnemyArray(new RedWolf(x, y));
                break;
            }
            case "R1": {
                Animator.getBoard().addEnemyArray(new Robot1(x, y));
                break;
            }
            case "R2": {
                Animator.getBoard().addEnemyArray(new RobotElec(x, y));
                break;
            }
            case "Sb": {
                Animator.getBoard().addEnemyArray(new slimeBlue(x, y));
                break;
            }
            case "Sr": {
                Animator.getBoard().addEnemyArray(new slimeRed(x, y));
                break;
            }
            case "Sg": {
                Animator.getBoard().addEnemyArray(new slimeGreen(x, y));
                break;
            }
            case "Sy": {
                Animator.getBoard().addEnemyArray(new slimeYellow(x, y));
                break;
            }
            case "SB": {
                Animator.getBoard().addEnemyArray(new slimeBlack(x, y));
                break;
            }
            case "Ss": {
                Animator.getBoard().addEnemyArray(new slimeSilver(x, y));
                break;
            }
            case "G1": {
                Animator.getBoard().addEnemyArray(new Glork1(x, y));
                break;
            }
            case "M1": {
                Animator.getBoard().addEnemyArray(new manCharge(x, y));
                break;
            }
            case "B1": {
                Animator.getBoard().addEnemyArray(new bat1(x, y));
                break;
            }
            case "SG": {
                Animator.getBoard().addEnemyArray(new slimeGreenUnder(x, y));
                break;
            }
            default: {
                throw new GameException("No enemy found: " + tileTag + " at " + x + " " + y);
            }
        }
    }

    private static void setItem(String tileTag, int x, int y, int mapNum) {
        switch (tileTag) {
            case "KN": {
                if (!MakeMaps.checkmapSaveWeaponsAndItems(1, new Point(x, y), mapNum).booleanValue()) break;
                Animator.getBoard().itemsArray.add(new Knife(x, y, true, new Point(x, y)));
                break;
            }
            case "GN": {
                if (!MakeMaps.checkmapSaveWeaponsAndItems(2, new Point(x, y), mapNum).booleanValue()) break;
                Animator.getBoard().itemsArray.add(new Gun(x, y, true, new Point(x, y)));
                break;
            }
            case "SG": {
                if (!MakeMaps.checkmapSaveWeaponsAndItems(3, new Point(x, y), mapNum).booleanValue()) break;
                Animator.getBoard().itemsArray.add(new ShotGun(x, y, true, new Point(x, y)));
                break;
            }
            case "LG": {
                if (!MakeMaps.checkmapSaveWeaponsAndItems(4, new Point(x, y), mapNum).booleanValue()) break;
                Animator.getBoard().itemsArray.add(new LaserGun(x, y, true, new Point(x, y)));
                break;
            }
            case "FT": {
                if (!MakeMaps.checkmapSaveWeaponsAndItems(5, new Point(x, y), mapNum).booleanValue()) break;
                Animator.getBoard().itemsArray.add(new FlameThrower(x, y, true, new Point(x, y)));
                break;
            }
            case "BZ": {
                if (!MakeMaps.checkmapSaveWeaponsAndItems(6, new Point(x, y), mapNum).booleanValue()) break;
                Animator.getBoard().itemsArray.add(new Bazooka(x, y, true, new Point(x, y)));
                break;
            }
            case "SY": {
                if (!MakeMaps.checkmapSaveWeaponsAndItems(8, new Point(x, y), mapNum).booleanValue()) break;
                Animator.getBoard().itemsArray.add(new Syringe(x, y, true, new Point(x, y)));
                break;
            }
            case "C4": {
                if (!MakeMaps.checkmapSaveWeaponsAndItems(7, new Point(x, y), mapNum).booleanValue()) break;
                Animator.getBoard().itemsArray.add(new PickUpC4(x, y, true, new Point(x, y)));
                break;
            }
            case "SH": {
                if (!MakeMaps.checkmapSaveWeaponsAndItems(9, new Point(x, y), mapNum).booleanValue()) break;
                Animator.getBoard().itemsArray.add(new PickUpShield(x, y, true, new Point(x, y)));
                break;
            }
            case "HR": {
                Animator.getBoard().itemsArray.add(new hookShotRing(x, y));
                break;
            }
            case "HS": {
                if (!MakeMaps.checkmapSaveWeaponsAndItems(10, new Point(x, y), mapNum).booleanValue()) break;
                Animator.getBoard().itemsArray.add(new PickUpHookshot(x, y, true, new Point(x, y)));
                break;
            }
            case "SC": {
                if (!MakeMaps.checkmapSaveScrewsAndTech(1, new Point(x, y), mapNum).booleanValue()) break;
                Animator.getBoard().itemsArray.add(new PickUpScrew(x, y, true, new Point(x, y)));
                break;
            }
            case "TE": {
                if (!MakeMaps.checkmapSaveScrewsAndTech(2, new Point(x, y), mapNum).booleanValue()) break;
                Animator.getBoard().itemsArray.add(new PickUpTech(x, y, true, new Point(x, y)));
                break;
            }
            case "H1": {
                if (!MakeMaps.checkmapSaveMaxHealth(1, new Point(x, y), mapNum).booleanValue()) break;
                Animator.getBoard().itemsArray.add(new PickUpHealthUpgarde(x, y, 1));
                break;
            }
            case "H2": {
                if (!MakeMaps.checkmapSaveMaxHealth(2, new Point(x, y), mapNum).booleanValue()) break;
                Animator.getBoard().itemsArray.add(new PickUpHealthUpgarde(x, y, 2));
                break;
            }
            case "H3": {
                if (!MakeMaps.checkmapSaveMaxHealth(3, new Point(x, y), mapNum).booleanValue()) break;
                Animator.getBoard().itemsArray.add(new PickUpHealthUpgarde(x, y, 3));
                break;
            }
            case "M1": {
                if (!MakeMaps.checkmapSaveItemsCoins(1, new Point(x, y), mapNum).booleanValue()) break;
                Animator.getBoard().itemsArray.add(new Coins(x, y, 1, true, new Point(x, y)));
                break;
            }
            case "M2": {
                if (!MakeMaps.checkmapSaveItemsCoins(2, new Point(x, y), mapNum).booleanValue()) break;
                Animator.getBoard().itemsArray.add(new Coins(x, y, 5, true, new Point(x, y)));
                break;
            }
            case "M3": {
                if (!MakeMaps.checkmapSaveItemsCoins(3, new Point(x, y), mapNum).booleanValue()) break;
                Animator.getBoard().itemsArray.add(new Coins(x, y, 10, true, new Point(x, y)));
                break;
            }
            case "M4": {
                if (!MakeMaps.checkmapSaveItemsCoins(4, new Point(x, y), mapNum).booleanValue()) break;
                Animator.getBoard().itemsArray.add(new Coins(x, y, 20, true, new Point(x, y)));
                break;
            }
            case "M5": {
                if (!MakeMaps.checkmapSaveItemsCoins(5, new Point(x, y), mapNum).booleanValue()) break;
                Animator.getBoard().itemsArray.add(new Coins(x, y, 50, true, new Point(x, y)));
                break;
            }
            case "M6": {
                if (!MakeMaps.checkmapSaveItemsCoins(6, new Point(x, y), mapNum).booleanValue()) break;
                Animator.getBoard().itemsArray.add(new Coins(x, y, 100, true, new Point(x, y)));
                break;
            }
            default: {
                throw new GameException("Cannot locate item to add to map: " + tileTag);
            }
        }
    }

    private static Boolean checkmapSaveScrewsAndTech(int type, Point itemXY, int mapNum) {
        if (Animator.getMapSaveItems().containsKey(mapNum)) {
            switch (type) {
                case 1: {
                    if (Animator.getMapSaveItems().get((Object)Integer.valueOf((int)mapNum)).itemScrews.contains(itemXY)) {
                        return false;
                    }
                    return true;
                }
                case 2: {
                    if (Animator.getMapSaveItems().get((Object)Integer.valueOf((int)mapNum)).itemTech.contains(itemXY)) {
                        return false;
                    }
                    return true;
                }
            }
            throw new GameException("MakeMaps: No screw or tech for type " + type + " for map save data");
        }
        return true;
    }

    private static Boolean checkmapSaveItemsCoins(int coinNum, Point itemXY, int mapNum) {
        if (Animator.getMapSaveItems().containsKey(mapNum)) {
            switch (coinNum) {
                case 1: {
                    if (Animator.getMapSaveItems().get((Object)Integer.valueOf((int)mapNum)).itemCoin1.contains(itemXY)) {
                        return false;
                    }
                    return true;
                }
                case 2: {
                    if (Animator.getMapSaveItems().get((Object)Integer.valueOf((int)mapNum)).itemCoin2.contains(itemXY)) {
                        return false;
                    }
                    return true;
                }
                case 3: {
                    if (Animator.getMapSaveItems().get((Object)Integer.valueOf((int)mapNum)).itemCoin3.contains(itemXY)) {
                        return false;
                    }
                    return true;
                }
                case 4: {
                    if (Animator.getMapSaveItems().get((Object)Integer.valueOf((int)mapNum)).itemCoin4.contains(itemXY)) {
                        return false;
                    }
                    return true;
                }
                case 5: {
                    if (Animator.getMapSaveItems().get((Object)Integer.valueOf((int)mapNum)).itemCoin5.contains(itemXY)) {
                        return false;
                    }
                    return true;
                }
                case 6: {
                    if (Animator.getMapSaveItems().get((Object)Integer.valueOf((int)mapNum)).itemCoin6.contains(itemXY)) {
                        return false;
                    }
                    return true;
                }
            }
            throw new GameException("MakeMaps: No Coin number " + coinNum + " for map save data");
        }
        return true;
    }

    private static Boolean checkmapSaveWeaponsAndItems(int type, Point itemXY, int mapNum) {
        if (Animator.getMapSaveItems().containsKey(mapNum)) {
            switch (type) {
                case 1: {
                    if (Animator.getMapSaveItems().get((Object)Integer.valueOf((int)mapNum)).knife != null && Animator.getMapSaveItems().get((Object)Integer.valueOf((int)mapNum)).knife.equals(itemXY)) {
                        return false;
                    }
                    return true;
                }
                case 2: {
                    if (Animator.getMapSaveItems().get((Object)Integer.valueOf((int)mapNum)).gun != null && Animator.getMapSaveItems().get((Object)Integer.valueOf((int)mapNum)).gun.equals(itemXY)) {
                        return false;
                    }
                    return true;
                }
                case 3: {
                    if (Animator.getMapSaveItems().get((Object)Integer.valueOf((int)mapNum)).shotgun != null && Animator.getMapSaveItems().get((Object)Integer.valueOf((int)mapNum)).shotgun.equals(itemXY)) {
                        return false;
                    }
                    return true;
                }
                case 4: {
                    if (Animator.getMapSaveItems().get((Object)Integer.valueOf((int)mapNum)).laser != null && Animator.getMapSaveItems().get((Object)Integer.valueOf((int)mapNum)).laser.equals(itemXY)) {
                        return false;
                    }
                    return true;
                }
                case 5: {
                    if (Animator.getMapSaveItems().get((Object)Integer.valueOf((int)mapNum)).flamethrower != null && Animator.getMapSaveItems().get((Object)Integer.valueOf((int)mapNum)).flamethrower.equals(itemXY)) {
                        return false;
                    }
                    return true;
                }
                case 6: {
                    if (Animator.getMapSaveItems().get((Object)Integer.valueOf((int)mapNum)).bazooka != null && Animator.getMapSaveItems().get((Object)Integer.valueOf((int)mapNum)).bazooka.equals(itemXY)) {
                        return false;
                    }
                    return true;
                }
                case 7: {
                    if (Animator.getMapSaveItems().get((Object)Integer.valueOf((int)mapNum)).C4 != null && Animator.getMapSaveItems().get((Object)Integer.valueOf((int)mapNum)).C4.equals(itemXY)) {
                        return false;
                    }
                    return true;
                }
                case 8: {
                    if (Animator.getMapSaveItems().get((Object)Integer.valueOf((int)mapNum)).syringe != null && Animator.getMapSaveItems().get((Object)Integer.valueOf((int)mapNum)).syringe.equals(itemXY)) {
                        return false;
                    }
                    return true;
                }
                case 9: {
                    if (Animator.getMapSaveItems().get((Object)Integer.valueOf((int)mapNum)).shield != null && Animator.getMapSaveItems().get((Object)Integer.valueOf((int)mapNum)).shield.equals(itemXY)) {
                        return false;
                    }
                    return true;
                }
                case 10: {
                    if (Animator.getMapSaveItems().get((Object)Integer.valueOf((int)mapNum)).hookshot != null && Animator.getMapSaveItems().get((Object)Integer.valueOf((int)mapNum)).hookshot.equals(itemXY)) {
                        return false;
                    }
                    return true;
                }
            }
            throw new GameException("MakeMaps: No weapons or item for type " + type + " for map save data");
        }
        return true;
    }

    private static Boolean checkmapSaveMaxHealth(int type, Point itemXY, int mapNum) {
        if (Animator.getMapSaveItems().containsKey(mapNum)) {
            switch (type) {
                case 1: {
                    if (Animator.getMapSaveItems().get((Object)Integer.valueOf((int)mapNum)).maxHealth1.contains(itemXY)) {
                        return false;
                    }
                    return true;
                }
                case 2: {
                    if (Animator.getMapSaveItems().get((Object)Integer.valueOf((int)mapNum)).maxHealth2.contains(itemXY)) {
                        return false;
                    }
                    return true;
                }
                case 3: {
                    if (Animator.getMapSaveItems().get((Object)Integer.valueOf((int)mapNum)).maxHealth3.contains(itemXY)) {
                        return false;
                    }
                    return true;
                }
            }
            throw new GameException("MakeMaps: No max health type " + type + " for map save data");
        }
        return true;
    }

    private static String setMapFile(int mapNum) {
        String mapFile = "";
        if (mapNum == 1) {
            mapFile = "/mapFiles/TestMap4.2.csv";
        } else if (mapNum == 2) {
            mapFile = "/mapFiles/TestMap5.csv";
        } else if (mapNum == 3) {
            mapFile = "/mapFiles/TestCave1.csv";
        } else if (mapNum == 4) {
            mapFile = "/mapFiles/TestCave2.csv";
        } else {
            throw new GameException("No map found for mapNum: " + mapNum);
        }
        return mapFile;
    }
}

