/*
 * Decompiled with CFR 0.152.
 */
package pickups;

import Engine.Animator;
import Engine.Font2;
import exceptions.GameException;
import java.util.HashMap;
import pickups.Items;

public class BulletPickups
extends Items {
    int amt;
    int type;
    boolean useNow;

    public BulletPickups(int x, int y, int type, int amt, boolean useNow) {
        super(x, y);
        this.amt = amt;
        this.type = type;
        this.useNow = useNow;
        if (!useNow) {
            this.imageNum = 2;
            this.hookable = 1;
            this.setImage();
            this.setRect();
            this.updateRect();
        }
    }

    @Override
    public void useItem() {
        int newBullets = 0;
        if (this.type < 10) {
            newBullets = Animator.getBoard().getHero().getBullet(this.type) + this.amt;
            if (newBullets > Animator.getBoard().getHero().getWeaponMaxAmmo()[this.type][Animator.getBoard().getHero().getHeroWeapons().getHeroWeaponsArray().get(this.type + 2).getupgarde5()]) {
                newBullets = Animator.getBoard().getHero().getWeaponMaxAmmo()[this.type][Animator.getBoard().getHero().getHeroWeapons().getHeroWeaponsArray().get(this.type + 2).getupgarde5()];
            }
            Animator.getBoard().getHero().setBullets(this.type, newBullets);
        } else if (this.type == 10) {
            HashMap<String, Integer> tempHash = Animator.getBoard().getHero().getHeroC4();
            newBullets = tempHash.get("C4Count") + this.amt;
            if (newBullets > tempHash.get("C4Max")) {
                newBullets = tempHash.get("C4Max");
            }
            tempHash.put("C4Count", newBullets);
            Animator.getBoard().getHero().setHeroC4(tempHash);
        }
        this.playSound();
        if (!this.useNow) {
            this.remove = true;
            if (newBullets > 0) {
                String ItemStr = "+" + String.valueOf(this.amt);
                Animator.getBoard().fontArray.add(new Font2(ItemStr, "blue", Animator.getBoard().getHero(), 90));
            }
        }
    }

    private void setRect() {
        this.rectSpaceX = 2 * Animator.pixMulti;
        this.rectSpaceY = 2 * Animator.pixMulti;
        this.rectW = 12 * Animator.pixMulti;
        this.rectH = 12 * Animator.pixMulti;
    }

    public void playSound() {
        if (Animator.playsouds.booleanValue()) {
            if (Animator.getBoard().clipGunReload.isRunning()) {
                Animator.getBoard().clipGunReload.stop();
            }
            Animator.getBoard().clipGunReload.setFramePosition(0);
            Animator.getBoard().clipGunReload.start();
        }
    }

    private void setImage() {
        switch (this.type) {
            case 0: {
                this.imageLoc = new int[]{16, 32, 32, 48};
                break;
            }
            case 1: {
                this.imageLoc = new int[]{64, 96, 80, 112};
                break;
            }
            case 2: {
                this.imageLoc = new int[]{112, 96, 128, 112};
                break;
            }
            case 3: {
                this.imageLoc = new int[]{112, 32, 128, 48};
                break;
            }
            case 4: {
                this.imageLoc = new int[]{48, 16, 64, 32};
                break;
            }
            case 5: {
                this.imageLoc = new int[]{48, 16, 64, 32};
                break;
            }
            case 10: {
                this.imageLoc = new int[]{176, 48, 192, 64};
                break;
            }
            default: {
                throw new GameException("No bullet pickup type: " + this.type);
            }
        }
    }
}

