/*
 * Decompiled with CFR 0.152.
 */
package pickups;

import Engine.Animator;
import Engine.Font2;
import Engine.SaveGame;
import exceptions.GameException;
import java.awt.Point;
import pickups.Items;

public class Coins
extends Items {
    int amt;
    int coinNum;
    private int soundCounter = -1;
    private int soundTick = 2;

    public Coins(int x, int y, int amt) {
        super(x, y);
        this.amt = amt;
        this.setCoin();
    }

    public Coins(int x, int y, int amt, Boolean perm, Point itemXY) {
        super(x, y, perm, itemXY);
        this.amt = amt;
        this.setCoin();
    }

    private void setCoin() {
        this.hookable = 1;
        this.setRect();
        this.setAmt();
        this.imageNum = 1;
        this.updateRect();
        switch (this.amt) {
            case 1: {
                this.coinNum = 1;
                break;
            }
            case 5: {
                this.coinNum = 2;
                break;
            }
            case 10: {
                this.coinNum = 3;
                break;
            }
            case 20: {
                this.coinNum = 4;
                break;
            }
            case 50: {
                this.coinNum = 5;
                break;
            }
            case 100: {
                this.coinNum = 6;
            }
        }
    }

    @Override
    public void useItem() {
        int missingCoin = Animator.getBoard().getHero().getMaxMoney() - Animator.getBoard().getHero().getMoney();
        if (this.amt > missingCoin) {
            this.amt = missingCoin;
        }
        this.soundCounter = this.amt * this.soundTick;
        this.visible = false;
        this.touchable = false;
        if (Animator.getBoard().getHero().getMoney() >= Animator.getBoard().getHero().getMaxMoney()) {
            this.playSound();
            this.remove = true;
        } else {
            this.lasting = true;
        }
        if (this.amt > 0) {
            String CoinAmtStr = "+" + String.valueOf(this.amt);
            Animator.getBoard().fontArray.add(new Font2(CoinAmtStr, "yellow", Animator.getBoard().getHero(), 90));
        }
        if (this.perm.booleanValue()) {
            int curMap = this.hero.getHeroCurMap();
            Animator.checkmapSaveItems(curMap);
            System.out.println("adding coin " + this.coinNum + " XY " + this.itemXY);
            switch (this.coinNum) {
                case 1: {
                    Animator.getMapSaveItems().get((Object)Integer.valueOf((int)curMap)).itemCoin1.add(this.itemXY);
                    break;
                }
                case 2: {
                    Animator.getMapSaveItems().get((Object)Integer.valueOf((int)curMap)).itemCoin2.add(this.itemXY);
                    break;
                }
                case 3: {
                    Animator.getMapSaveItems().get((Object)Integer.valueOf((int)curMap)).itemCoin3.add(this.itemXY);
                    break;
                }
                case 4: {
                    Animator.getMapSaveItems().get((Object)Integer.valueOf((int)curMap)).itemCoin4.add(this.itemXY);
                    break;
                }
                case 5: {
                    Animator.getMapSaveItems().get((Object)Integer.valueOf((int)curMap)).itemCoin5.add(this.itemXY);
                    break;
                }
                case 6: {
                    Animator.getMapSaveItems().get((Object)Integer.valueOf((int)curMap)).itemCoin6.add(this.itemXY);
                }
            }
            SaveGame.SaveGame1(false);
        }
    }

    private void setRect() {
        this.rectSpaceX = 2 * Animator.pixMulti;
        this.rectSpaceY = 2 * Animator.pixMulti;
        this.rectW = 12 * Animator.pixMulti;
        this.rectH = 12 * Animator.pixMulti;
    }

    public void playSound() {
        if (Animator.playsouds.booleanValue()) {
            int clipIndex = 0;
            if (Animator.getBoard().clipGetCoin[0].isRunning()) {
                clipIndex = 1;
            }
            Animator.getBoard().clipGetCoin[0].setFramePosition(0);
            Animator.getBoard().clipGetCoin[1].setFramePosition(0);
            Animator.getBoard().clipGetCoin[clipIndex].start();
        }
    }

    @Override
    public void updateItem() {
        Boolean keepGoing = true;
        int i = 0;
        while (i < Animator.getBoard().itemsArray.size()) {
            if (Animator.getBoard().itemsArray.get(i) instanceof Coins && Animator.getBoard().itemsArray.get(i).getIsActive().booleanValue() && !Animator.getBoard().itemsArray.get(i).equals(this)) {
                keepGoing = false;
            }
            ++i;
        }
        if (keepGoing.booleanValue()) {
            this.isActive = true;
            --this.soundCounter;
            if (this.soundCounter >= 0 && this.soundCounter % this.soundTick == 0 && Animator.getBoard().getHero().getMoney() < Animator.getBoard().getHero().getMaxMoney()) {
                Animator.getBoard().getHero().setMoney(Animator.getBoard().getHero().getMoney() + 1);
                Animator.getBoard().getHero().checkMoney();
                this.playSound();
            }
            if (this.soundCounter == 0) {
                this.remove = true;
            }
        }
    }

    private void setAmt() {
        if (this.amt == 1) {
            int[] nArray = new int[4];
            nArray[2] = 16;
            nArray[3] = 16;
            this.imageLoc = nArray;
        } else if (this.amt == 5) {
            int[] nArray = new int[4];
            nArray[0] = 16;
            nArray[2] = 32;
            nArray[3] = 16;
            this.imageLoc = nArray;
        } else if (this.amt == 10) {
            int[] nArray = new int[4];
            nArray[0] = 32;
            nArray[2] = 48;
            nArray[3] = 16;
            this.imageLoc = nArray;
        } else if (this.amt == 20) {
            int[] nArray = new int[4];
            nArray[1] = 16;
            nArray[2] = 16;
            nArray[3] = 32;
            this.imageLoc = nArray;
        } else if (this.amt == 50) {
            this.imageLoc = new int[]{16, 16, 32, 32};
        } else if (this.amt == 100) {
            this.imageLoc = new int[]{32, 16, 48, 32};
        } else {
            throw new GameException("Coin amount cannot be: " + this.amt);
        }
    }
}

