/*
 * Decompiled with CFR 0.152.
 */
package weapons;

import Engine.Animator;
import weapons.WeaponHit;

public class Explosion
extends WeaponHit {
    int counter = 0;
    short imgFrame = 1;

    public Explosion(int x, int y, int damage, Boolean doSound, int explosionType, int explosionSize) {
        super(x, y);
        this.damage = damage;
        this.enemyHit = true;
        this.heroHit = true;
        this.imgNum = (short)3;
        this.wepNum = explosionType;
        this.explosionSize = explosionSize;
        this.createRect();
        if (doSound.booleanValue()) {
            this.playSound();
        }
    }

    public void playSound() {
        if (Animator.playsouds.booleanValue() && !Animator.getBoard().clipBombExplode.isRunning()) {
            Animator.getBoard().clipBombExplode.setFramePosition(0);
            Animator.getBoard().clipBombExplode.start();
        }
    }

    private void createRect() {
        int pixMulti = Animator.pixMulti;
        this.rectSpaceX = 0 * pixMulti;
        this.rectSpaceY = 0 * pixMulti;
        this.rectW = 16 * pixMulti;
        this.rectH = 16 * pixMulti;
    }

    private void setImg(short num) {
        switch (num) {
            case 1: {
                this.imgLocation[0] = 0;
                this.imgLocation[1] = 128;
                this.imgLocation[2] = 16;
                this.imgLocation[3] = 144;
                break;
            }
            case 2: {
                this.imgLocation[0] = 16;
                this.imgLocation[1] = 128;
                this.imgLocation[2] = 32;
                this.imgLocation[3] = 144;
                break;
            }
            case 3: {
                this.imgLocation[0] = 32;
                this.imgLocation[1] = 128;
                this.imgLocation[2] = 48;
                this.imgLocation[3] = 144;
                break;
            }
            case 4: {
                this.imgLocation[0] = 48;
                this.imgLocation[1] = 128;
                this.imgLocation[2] = 64;
                this.imgLocation[3] = 144;
            }
        }
        this.updateRect(false);
    }

    @Override
    public void update() {
        if (this.counter % 10 == 0) {
            this.setImg(this.imgFrame);
            this.imgFrame = (short)(this.imgFrame + 1);
        }
        ++this.counter;
        if (this.counter >= 40) {
            this.remove = true;
        }
        this.updateRect(false);
        this.collision2();
    }
}

