/*
 * Decompiled with CFR 0.152.
 */
package Engine;

import Engine.Animator;
import Engine.Hero;
import enemiesClass.Enemies;
import exceptions.GameException;
import java.awt.Image;
import java.awt.Point;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import javax.imageio.ImageIO;
import pickups.MajorItems;

public class Font2 {
    ArrayList<int[]> paintLetters = new ArrayList();
    int x;
    int y;
    int letW = 7;
    int letH = 8;
    int letWBase = 7;
    int letHBase = 8;
    int letWOG = this.letW;
    int letHOG = this.letH;
    int reset;
    int letWpaint = this.letW * Animator.pixMulti;
    int letHpaint = this.letH * Animator.pixMulti;
    int letWpaintBase = this.letW * Animator.pixMulti;
    int letHpaintBase = this.letH * Animator.pixMulti;
    int printTimer = 0;
    int textRiser = 0;
    private int fontSize = 1;
    private Boolean onScreen = false;
    private Enemies hitEnemy;
    private Hero hitHero;
    private MajorItems mi;
    private String color;
    private String[] words;
    private Boolean border = false;
    private Boolean visiable = true;
    private Image image;
    private Image imgBorder;
    private Boolean remove = false;
    private Boolean nextWords = false;
    private int wordIndex = 0;
    private int arrowCounter = 0;
    private Boolean moveWithMap = false;
    private boolean willRemove = false;
    ArrayList<String> strArray = new ArrayList();

    public Font2(int x, int y, int reset, String[] words, String color, Boolean visiable) {
        this.x = x;
        this.y = y;
        this.reset = reset;
        this.words = words;
        this.color = color;
        this.visiable = visiable;
        this.loadImage();
        this.init();
    }

    public Font2(int x, int y, int reset, String[] words, String color, Boolean visiable, int size) {
        this.x = x;
        this.y = y;
        this.reset = reset;
        this.words = words;
        this.color = color;
        this.visiable = visiable;
        this.fontSize = size;
        this.loadImage();
        this.init();
    }

    public Font2(int x, int y, String[] words, String color, Boolean willRemove) {
        this.x = x;
        this.y = y;
        this.words = words;
        this.color = color;
        this.willRemove = willRemove;
        this.reset = 999;
        this.fontSize = -1;
        this.loadImage();
        this.init();
    }

    public Font2(int x, int y, int reset, String[] words, String color, Boolean visiable, Boolean border) {
        this.x = x;
        this.y = y;
        this.reset = reset;
        this.words = words;
        this.color = color;
        this.visiable = visiable;
        this.border = border;
        this.loadImage();
        this.init();
    }

    public Font2(int x, int y, int reset, String[] words, String color, Boolean visiable, Boolean border, MajorItems mi) {
        this.x = x;
        this.y = y;
        this.reset = reset;
        this.words = words;
        this.color = color;
        this.visiable = visiable;
        this.border = border;
        this.mi = mi;
        this.loadImage();
        this.init();
    }

    public Font2(String word, String color, Enemies enemy, int timer) {
        this.reset = 100;
        this.words = new String[]{word};
        this.color = color;
        this.hitEnemy = enemy;
        this.setEnemyXY();
        this.printTimer = timer;
        this.onScreen = true;
        this.fontSize = 2;
        this.loadImage();
        this.init();
    }

    public Font2(String word, String color, Hero hero, int timer) {
        this.reset = 100;
        this.words = new String[]{word};
        this.color = color;
        this.hitHero = hero;
        this.setHeroXY();
        this.printTimer = timer;
        this.onScreen = true;
        this.fontSize = 2;
        this.loadImage();
        this.init();
    }

    public void init() {
        if (this.fontSize == 2) {
            this.letW = this.letWBase * 10 / 12;
            this.letH = this.letHBase * 10 / 12;
            this.letWpaint = this.letWpaintBase * 10 / 12;
            this.letHpaint = this.letHpaintBase * 10 / 12;
        } else if (this.fontSize == -1) {
            this.letW = this.letWBase * 2;
            this.letH = this.letHBase * 2;
            this.letWpaint = this.letWpaintBase * 2;
            this.letHpaint = this.letHpaintBase * 2;
        } else if (this.fontSize == -2) {
            this.letW = this.letWBase * 4;
            this.letH = this.letHBase * 4;
            this.letWpaint = this.letWpaintBase * 4;
            this.letHpaint = this.letHpaintBase * 4;
        } else if (this.fontSize == 1) {
            this.letW = this.letWBase;
            this.letH = this.letHBase;
            this.letWpaint = this.letWpaintBase;
            this.letHpaint = this.letHpaintBase;
        }
        this.lineWords();
        this.setArray();
    }

    public void resetWords() {
        this.lineWords();
        this.setArray();
    }

    public void update() {
        if (this.border.booleanValue()) {
            Animator.getBoard().setFreezGame(true);
        }
        if (this.border.booleanValue() && this.nextWords.booleanValue()) {
            this.nextWords = false;
            if (Animator.getBoard().getHero().isInActiveTileAmmo()) {
                this.remove = true;
                Animator.getBoard().getHero().setInActiveTileAmmo(false);
            } else if (this.wordIndex + 1 < this.words.length) {
                ++this.wordIndex;
                this.playSound();
            } else {
                Animator.getBoard().setFreezGame(false);
                Animator.getBoard().setContinueGame(true);
                if (this.mi != null) {
                    Animator.getBoard().getHero().setDirDraw(Animator.getBoard().getHero().getHeroMoveDown());
                    Animator.getBoard().getHero().setGettingMajorItem(false);
                    Animator.getBoard().getHero().setCanAct(true);
                    Animator.getBoard().setFreezGame(false);
                    this.mi.setRemove(true);
                }
                this.remove = true;
            }
            this.resetWords();
        }
        if (this.wordIndex + 1 < this.words.length) {
            ++this.arrowCounter;
            if (this.arrowCounter > 120) {
                this.arrowCounter = 0;
            }
        }
        if (this.printTimer > 0) {
            --this.printTimer;
            if (this.printTimer == 1) {
                this.remove = true;
            }
        }
        if (this.hitEnemy != null || this.hitHero != null) {
            if (Animator.getBoard().getEnemyArray().contains(this.hitEnemy)) {
                this.setEnemyXY();
            } else if (this.hitHero == null) {
                this.moveWithMap = true;
            }
            if (this.hitHero != null) {
                this.setHeroXY();
            }
            if (this.printTimer % 2 == 0) {
                --this.y;
                ++this.textRiser;
                this.resetWords();
            }
            if (this.printTimer < 45) {
                this.visiable = this.printTimer % 4 == 0 ? Boolean.valueOf(false) : Boolean.valueOf(true);
            }
        }
    }

    private void setEnemyXY() {
        int textX;
        int wordLen = this.words[0].length();
        int wordMid = wordLen * this.letWpaint / 2;
        this.x = textX = this.hitEnemy.getRectX() + this.hitEnemy.getRectW() / 2 - wordMid;
        this.y = this.hitEnemy.getRectY() - this.letHpaint - this.textRiser;
    }

    private void setHeroXY() {
        int textX;
        int wordLen = this.words[0].length();
        int wordMid = wordLen * this.letWpaint / 2;
        this.x = textX = this.hitHero.getRectX() + this.hitHero.getRectW() / 2 - wordMid;
        this.y = this.hitHero.getRectY() - this.letHpaint - this.textRiser;
    }

    /*
     * Unable to fully structure code
     */
    private void setArray() {
        this.paintLetters.clear();
        fontX = this.x;
        fontY = this.y;
        currentChar = 0;
        i = 0;
        ** GOTO lbl23
        {
            lets = new int[4];
            point = this.setLet(this.strArray.get(i).charAt(currentChar));
            lets[0] = fontX;
            lets[1] = fontY;
            lets[2] = point.x;
            lets[3] = point.y;
            this.paintLetters.add(lets);
            fontX = this.fontSize == 2 ? (fontX += 5 * Animator.pixMulti) : (this.fontSize == -1 ? (fontX += 12 * Animator.pixMulti) : (this.fontSize == -2 ? (fontX += 24 * Animator.pixMulti) : (fontX += 7 * Animator.pixMulti)));
            ++currentChar;
            do {
                if (currentChar < this.strArray.get(i).length()) continue block0;
                currentChar = 0;
                fontX = this.x;
                fontY = this.fontSize == 2 ? (fontY += 7 * Animator.pixMulti) : (this.fontSize == -1 ? (fontY += 16 * Animator.pixMulti) : (this.fontSize == -2 ? (fontY += 16 * Animator.pixMulti) : (fontY += 9 * Animator.pixMulti)));
                ++i;
lbl23:
                // 2 sources

            } while (i < this.strArray.size());
        }
        if (this.wordIndex + 1 < this.words.length) {
            lets = new int[]{240 * Animator.pixMulti, 68 * Animator.pixMulti, 4 * this.letWOG, 10 * this.letHOG};
            this.paintLetters.add(lets);
        }
        this.strArray.clear();
    }

    private void loadImage() {
        if (this.color.equals("black")) {
            this.image = Animator.getBoard().getFontsBlack();
        } else if (this.color.equals("blue")) {
            this.image = Animator.getBoard().getFontsBlue();
        } else if (this.color.equals("green")) {
            this.image = Animator.getBoard().getFontsGreen();
        } else if (this.color.equals("lightgreen")) {
            this.image = Animator.getBoard().getFontsLightGreen();
        } else if (this.color.equals("red")) {
            this.image = Animator.getBoard().getFontsRed();
        } else if (this.color.equals("yellow")) {
            this.image = Animator.getBoard().getFontsYellow();
        } else if (this.color.equals("white")) {
            this.image = Animator.getBoard().getFontsWhite();
        } else {
            throw new GameException("No font color exists of: " + this.color);
        }
        if (this.border.booleanValue()) {
            BufferedImage fonts = null;
            try {
                fonts = ImageIO.read(this.getClass().getClassLoader().getResource("fonts/border.png"));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.imgBorder = fonts;
            this.playSound();
        }
    }

    public void playSound() {
        if (Animator.playsouds.booleanValue()) {
            if (Animator.getBoard().clipMessage.isRunning()) {
                Animator.getBoard().clipMessage.stop();
            }
            Animator.getBoard().clipMessage.setFramePosition(0);
            Animator.getBoard().clipMessage.start();
        }
    }

    private void lineWords() {
        int charsLines;
        String[] wordCount = this.words[this.wordIndex].split(" ");
        String newLine = "";
        int currentLine = charsLines = this.reset / this.letW;
        int i = 0;
        while (i < wordCount.length) {
            if (wordCount[i].length() > charsLines) {
                throw new GameException("Word is to long for legnth of: " + wordCount[i] + " " + charsLines);
            }
            if (wordCount[i].length() < currentLine) {
                currentLine -= wordCount[i].length() + 1;
                newLine = String.valueOf(newLine) + wordCount[i] + " ";
            } else {
                this.strArray.add(newLine);
                currentLine = charsLines;
                --i;
                newLine = "";
            }
            ++i;
        }
        this.strArray.add(newLine);
    }

    public void removeText() {
        this.remove = true;
    }

    public ArrayList<int[]> getPaintLetters() {
        return this.paintLetters;
    }

    public int getLetWpaint() {
        return this.letWpaint;
    }

    public int getLetHpaint() {
        return this.letHpaint;
    }

    public Image getImage() {
        return this.image;
    }

    public Image getImgBorder() {
        return this.imgBorder;
    }

    public Boolean getBorder() {
        return this.border;
    }

    public int getLetWOG() {
        return this.letWOG;
    }

    public int getLetHOG() {
        return this.letHOG;
    }

    public int getLetW() {
        return this.letW;
    }

    public int getLetH() {
        return this.letH;
    }

    public void setWords(String[] words) {
        if (!Arrays.equals(words, this.words)) {
            this.words = words;
            this.resetWords();
        }
    }

    public void setNextWords(Boolean nextWords) {
        this.nextWords = nextWords;
    }

    public Boolean getVisiable() {
        return this.visiable;
    }

    public void setVisiable(Boolean visiable) {
        this.visiable = visiable;
    }

    public Boolean getRemove() {
        return this.remove;
    }

    public int getArrowCounter() {
        return this.arrowCounter;
    }

    public String[] getWords() {
        return this.words;
    }

    public Boolean getMoveWithMap() {
        return this.moveWithMap;
    }

    public Boolean getOnScreen() {
        return this.onScreen;
    }

    public boolean isWillRemove() {
        return this.willRemove;
    }

    public void setColor(String color) {
        this.color = color;
        this.loadImage();
    }

    public void setFontSize(int fontSize) {
        this.fontSize = fontSize;
    }

    private Point setLet(char let) {
        Point point = new Point(0, 0);
        if (let == 'A') {
            point.x = 0 * this.letWOG;
            point.y = 0 * this.letHOG;
        } else if (let == 'B') {
            point.x = 1 * this.letWOG;
            point.y = 0 * this.letHOG;
        } else if (let == 'C') {
            point.x = 2 * this.letWOG;
            point.y = 0 * this.letHOG;
        } else if (let == 'D') {
            point.x = 3 * this.letWOG;
            point.y = 0 * this.letHOG;
        } else if (let == 'E') {
            point.x = 4 * this.letWOG;
            point.y = 0 * this.letHOG;
        } else if (let == 'F') {
            point.x = 5 * this.letWOG;
            point.y = 0 * this.letHOG;
        } else if (let == 'G') {
            point.x = 6 * this.letWOG;
            point.y = 0 * this.letHOG;
        } else if (let == 'H') {
            point.x = 7 * this.letWOG;
            point.y = 0 * this.letHOG;
        } else if (let == 'I') {
            point.x = 8 * this.letWOG;
            point.y = 0 * this.letHOG;
        } else if (let == 'J') {
            point.x = 0 * this.letWOG;
            point.y = 1 * this.letHOG;
        } else if (let == 'K') {
            point.x = 1 * this.letWOG;
            point.y = 1 * this.letHOG;
        } else if (let == 'L') {
            point.x = 2 * this.letWOG;
            point.y = 1 * this.letHOG;
        } else if (let == 'M') {
            point.x = 3 * this.letWOG;
            point.y = 1 * this.letHOG;
        } else if (let == 'N') {
            point.x = 4 * this.letWOG;
            point.y = 1 * this.letHOG;
        } else if (let == 'O') {
            point.x = 5 * this.letWOG;
            point.y = 1 * this.letHOG;
        } else if (let == 'P') {
            point.x = 6 * this.letWOG;
            point.y = 1 * this.letHOG;
        } else if (let == 'Q') {
            point.x = 7 * this.letWOG;
            point.y = 1 * this.letHOG;
        } else if (let == 'R') {
            point.x = 8 * this.letWOG;
            point.y = 1 * this.letHOG;
        } else if (let == 'S') {
            point.x = 0 * this.letWOG;
            point.y = 2 * this.letHOG;
        } else if (let == 'T') {
            point.x = 1 * this.letWOG;
            point.y = 2 * this.letHOG;
        } else if (let == 'U') {
            point.x = 2 * this.letWOG;
            point.y = 2 * this.letHOG;
        } else if (let == 'V') {
            point.x = 3 * this.letWOG;
            point.y = 2 * this.letHOG;
        } else if (let == 'W') {
            point.x = 4 * this.letWOG;
            point.y = 2 * this.letHOG;
        } else if (let == 'X') {
            point.x = 5 * this.letWOG;
            point.y = 2 * this.letHOG;
        } else if (let == 'Y') {
            point.x = 6 * this.letWOG;
            point.y = 2 * this.letHOG;
        } else if (let == 'Z') {
            point.x = 7 * this.letWOG;
            point.y = 2 * this.letHOG;
        } else if (let == 'a') {
            point.x = 8 * this.letWOG;
            point.y = 2 * this.letHOG;
        } else if (let == 'b') {
            point.x = 0 * this.letWOG;
            point.y = 3 * this.letHOG;
        } else if (let == 'c') {
            point.x = 1 * this.letWOG;
            point.y = 3 * this.letHOG;
        } else if (let == 'd') {
            point.x = 2 * this.letWOG;
            point.y = 3 * this.letHOG;
        } else if (let == 'e') {
            point.x = 3 * this.letWOG;
            point.y = 3 * this.letHOG;
        } else if (let == 'f') {
            point.x = 4 * this.letWOG;
            point.y = 3 * this.letHOG;
        } else if (let == 'g') {
            point.x = 5 * this.letWOG;
            point.y = 3 * this.letHOG;
        } else if (let == 'h') {
            point.x = 6 * this.letWOG;
            point.y = 3 * this.letHOG;
        } else if (let == 'i') {
            point.x = 7 * this.letWOG;
            point.y = 3 * this.letHOG;
        } else if (let == 'j') {
            point.x = 8 * this.letWOG;
            point.y = 3 * this.letHOG;
        } else if (let == 'k') {
            point.x = 0 * this.letWOG;
            point.y = 4 * this.letHOG;
        } else if (let == 'l') {
            point.x = 1 * this.letWOG;
            point.y = 4 * this.letHOG;
        } else if (let == 'm') {
            point.x = 2 * this.letWOG;
            point.y = 4 * this.letHOG;
        } else if (let == 'n') {
            point.x = 3 * this.letWOG;
            point.y = 4 * this.letHOG;
        } else if (let == 'o') {
            point.x = 4 * this.letWOG;
            point.y = 4 * this.letHOG;
        } else if (let == 'p') {
            point.x = 5 * this.letWOG;
            point.y = 4 * this.letHOG;
        } else if (let == 'q') {
            point.x = 6 * this.letWOG;
            point.y = 4 * this.letHOG;
        } else if (let == 'r') {
            point.x = 7 * this.letWOG;
            point.y = 4 * this.letHOG;
        } else if (let == 's') {
            point.x = 8 * this.letWOG;
            point.y = 4 * this.letHOG;
        } else if (let == 't') {
            point.x = 0 * this.letWOG;
            point.y = 5 * this.letHOG;
        } else if (let == 'u') {
            point.x = 1 * this.letWOG;
            point.y = 5 * this.letHOG;
        } else if (let == 'v') {
            point.x = 2 * this.letWOG;
            point.y = 5 * this.letHOG;
        } else if (let == 'w') {
            point.x = 3 * this.letWOG;
            point.y = 5 * this.letHOG;
        } else if (let == 'x') {
            point.x = 4 * this.letWOG;
            point.y = 5 * this.letHOG;
        } else if (let == 'y') {
            point.x = 5 * this.letWOG;
            point.y = 5 * this.letHOG;
        } else if (let == 'z') {
            point.x = 6 * this.letWOG;
            point.y = 5 * this.letHOG;
        } else if (let == '0') {
            point.x = 7 * this.letWOG;
            point.y = 5 * this.letHOG;
        } else if (let == '1') {
            point.x = 8 * this.letWOG;
            point.y = 5 * this.letHOG;
        } else if (let == '2') {
            point.x = 0 * this.letWOG;
            point.y = 6 * this.letHOG;
        } else if (let == '3') {
            point.x = 1 * this.letWOG;
            point.y = 6 * this.letHOG;
        } else if (let == '4') {
            point.x = 2 * this.letWOG;
            point.y = 6 * this.letHOG;
        } else if (let == '5') {
            point.x = 3 * this.letWOG;
            point.y = 6 * this.letHOG;
        } else if (let == '6') {
            point.x = 4 * this.letWOG;
            point.y = 6 * this.letHOG;
        } else if (let == '7') {
            point.x = 5 * this.letWOG;
            point.y = 6 * this.letHOG;
        } else if (let == '8') {
            point.x = 6 * this.letWOG;
            point.y = 6 * this.letHOG;
        } else if (let == '9') {
            point.x = 7 * this.letWOG;
            point.y = 6 * this.letHOG;
        } else if (let == '.') {
            point.x = 8 * this.letWOG;
            point.y = 6 * this.letHOG;
        } else if (let == ',') {
            point.x = 0 * this.letWOG;
            point.y = 7 * this.letHOG;
        } else if (let == ';') {
            point.x = 1 * this.letWOG;
            point.y = 7 * this.letHOG;
        } else if (let == ':') {
            point.x = 2 * this.letWOG;
            point.y = 7 * this.letHOG;
        } else if (let == '?') {
            point.x = 3 * this.letWOG;
            point.y = 7 * this.letHOG;
        } else if (let == '!') {
            point.x = 4 * this.letWOG;
            point.y = 7 * this.letHOG;
        } else if (let == '-') {
            point.x = 5 * this.letWOG;
            point.y = 7 * this.letHOG;
        } else if (let == '_') {
            point.x = 6 * this.letWOG;
            point.y = 7 * this.letHOG;
        } else if (let == '~') {
            point.x = 7 * this.letWOG;
            point.y = 7 * this.letHOG;
        } else if (let == '#') {
            point.x = 8 * this.letWOG;
            point.y = 7 * this.letHOG;
        } else if (let == '\"') {
            point.x = 0 * this.letWOG;
            point.y = 8 * this.letHOG;
        } else if (let == '\'') {
            point.x = 1 * this.letWOG;
            point.y = 8 * this.letHOG;
        } else if (let == '&') {
            point.x = 2 * this.letWOG;
            point.y = 8 * this.letHOG;
        } else if (let == '(') {
            point.x = 3 * this.letWOG;
            point.y = 8 * this.letHOG;
        } else if (let == ')') {
            point.x = 4 * this.letWOG;
            point.y = 8 * this.letHOG;
        } else if (let == '[') {
            point.x = 5 * this.letWOG;
            point.y = 8 * this.letHOG;
        } else if (let == ']') {
            point.x = 6 * this.letWOG;
            point.y = 8 * this.letHOG;
        } else if (let == '|') {
            point.x = 7 * this.letWOG;
            point.y = 8 * this.letHOG;
        } else if (let == '`') {
            point.x = 8 * this.letWOG;
            point.y = 8 * this.letHOG;
        } else if (let == '\\') {
            point.x = 0 * this.letWOG;
            point.y = 9 * this.letHOG;
        } else if (let == '/') {
            point.x = 1 * this.letWOG;
            point.y = 9 * this.letHOG;
        } else if (let == '@') {
            point.x = 2 * this.letWOG;
            point.y = 9 * this.letHOG;
        } else if (let == '+') {
            point.x = 4 * this.letWOG;
            point.y = 9 * this.letHOG;
        } else if (let == '=') {
            point.x = 5 * this.letWOG;
            point.y = 9 * this.letHOG;
        } else if (let == '*') {
            point.x = 6 * this.letWOG;
            point.y = 9 * this.letHOG;
        } else if (let == '$') {
            point.x = 7 * this.letWOG;
            point.y = 9 * this.letHOG;
        } else if (let == '<') {
            point.x = 1 * this.letWOG;
            point.y = 10 * this.letHOG;
        } else if (let == '>') {
            point.x = 2 * this.letWOG;
            point.y = 10 * this.letHOG;
        } else if (let == '%') {
            point.x = 3 * this.letWOG;
            point.y = 10 * this.letHOG;
        } else if (let == ' ') {
            point.x = 8 * this.letWOG;
            point.y = 10 * this.letHOG;
        } else {
            throw new GameException("Cannot create charter when creating string: " + let);
        }
        return point;
    }
}

