/*
 * Decompiled with CFR 0.152.
 */
package Engine;

import Engine.Animator;
import Engine.Hero;
import Engine.Sprite;
import exceptions.GameException;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Random;
import javax.sound.sampled.Clip;
import javax.sound.sampled.FloatControl;
import mapClass.Areas;
import weapons.WeaponHit;

public class MapMain
extends Sprite {
    private int imgNum = 0;
    private int mapNum = 0;
    private Hero hero = Animator.getBoard().getHero();
    private Point mapXY = new Point(0, 0);
    private int[] tileType = new int[4];
    private int[] tileTypeLv4 = new int[4];
    private int[] tileTypeShadow = new int[4];
    private Point mapPoint = new Point();
    private Point mapPointCenter = new Point();
    private boolean hasLv4 = false;
    private boolean hasShadow = false;
    private boolean shadowOnly = false;
    private String secret;
    private String tileTag;
    private int checkLv = 0;
    private int tileSizeX = 1;
    private int tileSizeY = 1;
    private static Random rand = new Random();
    private float heroDistance = 10000.0f;
    private byte soundNumPlay = 0;
    private Boolean soundTilePlay = false;
    private Boolean burnable = false;
    private Boolean explodable = false;
    private Boolean seeThrough = false;
    private boolean onScreen = false;
    private Boolean ignorHookhot = false;
    private Boolean layer4 = false;
    private boolean bulletsOnTop = false;
    private int weaponBreakbale = 0;
    private Point weaponBreakbaleRubble = new Point(5, 42);
    private Point caveOpeningPoint = new Point(17, 25);
    private boolean playingSound = false;
    private Hashtable<MapMain, Float> heroDistanceWaterfallGlobal = new Hashtable();
    private Hashtable<MapMain, Float> heroDistanceFountainGlobal = new Hashtable();
    private static HashMap<MapMain, Float> heroDistanceTileSound = new HashMap();
    private float soundWaterfallMax = 2000.0f;
    private int soundWaterfallDevider = 25;
    private float soundWaterfallDecAmt = 0.5f;
    static final ArrayList<MapMain> activetileAmmo = new ArrayList();
    static final ArrayList<MapMain> activetileHealth = new ArrayList();
    protected boolean tileAnimated = false;
    protected int tileAniPause;
    protected int tileAniSpeed;
    protected int tileAniType;
    protected ArrayList<int[]> imageLocArray = new ArrayList();
    protected Animator.AnimationItems aniItem;

    public MapMain(int x, int y, String type, String secret, Point mapPoint, int checkLv, int mapNum) {
        super(x, y);
        this.mapXY.x = x;
        this.mapXY.y = y;
        this.tileTag = type;
        this.secret = secret;
        this.mapPoint = mapPoint;
        this.spriteType = 1;
        this.checkLv = checkLv;
        this.mapNum = mapNum;
        if (secret.equals("%") || secret.equals("&")) {
            this.createArea();
        } else {
            this.setTypeArray();
            this.checkType();
            this.setSecret();
        }
    }

    private void playSounds(byte soundNum, boolean startSound) {
        if (Animator.playsouds.booleanValue()) {
            Clip tempclip = null;
            Clip[] tempclips = null;
            if (this.soundTilePlay.booleanValue()) {
                if (soundNum == 1) {
                    tempclip = Animator.getBoard().getClipWaterfall();
                } else if (soundNum == 2) {
                    tempclip = Animator.getBoard().getClipFountain();
                } else if (soundNum == 3) {
                    tempclip = Animator.getBoard().getCliplava1();
                }
            } else {
                startSound = false;
            }
            if (soundNum == 100) {
                int tempRand = rand.nextInt(Animator.getBoard().getClipWaterDropAry().length);
                tempclips = Animator.getBoard().getClipWaterDropAry()[tempRand];
            }
            if (startSound) {
                FloatControl volumeControl = null;
                FloatControl volumeControl2 = null;
                if (tempclip != null) {
                    volumeControl = (FloatControl)tempclip.getControl(FloatControl.Type.MASTER_GAIN);
                } else if (tempclips != null) {
                    volumeControl = (FloatControl)tempclips[0].getControl(FloatControl.Type.MASTER_GAIN);
                    volumeControl2 = (FloatControl)tempclips[1].getControl(FloatControl.Type.MASTER_GAIN);
                }
                int volumeFlux = (int)(this.heroDistance / (float)this.soundWaterfallDevider);
                float volume = 0.0f - (float)volumeFlux * this.soundWaterfallDecAmt;
                volumeControl.setValue(volume);
                if (volumeControl2 != null) {
                    volumeControl2.setValue(volume);
                }
                if (tempclip != null && !tempclip.isRunning()) {
                    tempclip.setLoopPoints(0, -1);
                    tempclip.loop(-1);
                    this.playingSound = true;
                } else if (tempclips != null) {
                    int clipIndex = 0;
                    if (tempclips[0].isRunning()) {
                        clipIndex = 1;
                    }
                    if (clipIndex == 0) {
                        tempclips[0].setFramePosition(0);
                    } else {
                        tempclips[1].setFramePosition(0);
                    }
                    tempclips[clipIndex].start();
                }
            } else if (this.playingSound) {
                tempclip.stop();
                this.playingSound = false;
            }
            if (Animator.getBoard().getHeroDead().booleanValue()) {
                this.playingSound = false;
            }
        }
    }

    public void getHeroDistance(int soundNumRemote) {
        if (this.tileTag.equals("WQ") || this.tileTag.equals("WZ") || this.tileTag.equals("WE") || this.tileTag.equals("WD") || this.tileTag.equals("WA")) {
            this.soundNumPlay = 1;
        } else if (this.tileTag.equals("fS")) {
            this.soundNumPlay = (byte)2;
        } else if (this.tileTag.equals("ot") || this.tileTag.equals("oy") || this.tileTag.equals("og") || this.tileTag.equals("oh")) {
            this.soundNumPlay = (byte)3;
        } else {
            this.soundNumPlay = 0;
            if (soundNumRemote > 0) {
                this.soundNumPlay = (byte)soundNumRemote;
            }
        }
        if (this.soundNumPlay > 0 && this.soundTilePlay.booleanValue()) {
            MapMain[] mapCorners = Animator.getBoard().getAreaCorners(this.x, this.y);
            if (Animator.getBoard().checkHeroArea(mapCorners[0], mapCorners[1]).booleanValue() && Animator.getBoard().getHeroDeadCounter() == 0) {
                this.heroDistance = Animator.findDistance(this.mapPointCenter, this.hero.getHeroPoint());
                if (this.soundNumPlay < 100) {
                    if (this.heroDistance <= this.soundWaterfallMax) {
                        heroDistanceTileSound.put(this, Float.valueOf(this.heroDistance));
                    } else {
                        heroDistanceTileSound.remove(this);
                    }
                    for (MapMain key : heroDistanceTileSound.keySet()) {
                        float value = heroDistanceTileSound.get(key).floatValue();
                        if (!(value < this.heroDistance)) continue;
                        this.heroDistance = value;
                    }
                }
                if (this.heroDistance < this.soundWaterfallMax) {
                    this.playSounds(this.soundNumPlay, true);
                } else {
                    this.playSounds(this.soundNumPlay, false);
                }
            } else if (this.playingSound) {
                this.playSounds(this.soundNumPlay, false);
                this.playingSound = false;
                heroDistanceTileSound.clear();
                this.heroDistance = 10000.0f;
            }
        }
    }

    private void checkType() {
        if (this.tileTag.equals("C1") || this.tileTag.equals("C2") || this.tileTag.equals("C3") || this.tileTag.equals("C4") || this.tileTag.equals("C5") || this.tileTag.equals("C6") || this.tileTag.equals("C7") || this.tileTag.equals("C8") || this.tileTag.equals("C9") || this.tileTag.equals("Cf") || this.tileTag.equals("Cg") || this.tileTag.equals("Ch")) {
            this.ignorHookhot = true;
        }
        if (this.tileTag.equals("fQ") || this.tileTag.equals("fE") || this.tileTag.equals("F!") || this.tileTag.equals("F@")) {
            this.bulletsOnTop = true;
        }
    }

    private void setTypeArray() {
        for (Animator.tilesSearchItems tileItem : Animator.getTilesSearchAry2()) {
            if (!tileItem.tileTag.equals(this.tileTag)) continue;
            this.imgNum = tileItem.mapNum;
            if (this.tileTag.equals("Cv") || this.tileTag.equals("Cb") || this.tileTag.equals("Cn") || this.tileTag.equals("Cm") || this.tileTag.equals("Cj") || this.tileTag.equals("Cu") || this.tileTag.equals("CX") || this.tileTag.equals("CS")) {
                this.shadowOnly = true;
                this.hasShadow = true;
                this.tileTypeShadow[0] = tileItem.imageLocArray.get(0)[0];
                this.tileTypeShadow[1] = tileItem.imageLocArray.get(0)[1];
                this.tileTypeShadow[2] = tileItem.imageLocArray.get(0)[2];
                this.tileTypeShadow[3] = tileItem.imageLocArray.get(0)[3];
            } else if (tileItem.imageLocArray.size() == 1) {
                this.tileType = tileItem.imageLocArray.get(0);
            } else if (tileItem.imageLocArray.size() > 1) {
                this.imageLocArray.addAll(tileItem.imageLocArray);
                this.tileAnimated = true;
                this.tileAniSpeed = 10;
                this.tileAniPause = 0;
                this.tileAniType = 1;
                if (this.tileTag.equals("ot") || this.tileTag.equals("oy") || this.tileTag.equals("og") || this.tileTag.equals("oh")) {
                    this.tileAniSpeed = 10;
                    this.tileAniPause = 30;
                    this.tileAniType = 2;
                } else if (this.tileTag.equals("w.") || this.tileTag.equals("w%")) {
                    int ranNum = rand.nextInt(500);
                    this.tileAniPause = ranNum + 180;
                    this.tileAniSpeed = 10;
                    this.tileAniType = 1;
                }
                this.aniItem = new Animator.AnimationItems(this.tileAniPause, this.tileAniSpeed, this.tileAniType, this.imageLocArray);
            } else {
                throw new GameException("Sanity check failed in MapMain setTypeArray: No array for map points found");
            }
            this.tileSizeX = tileItem.sizeX;
            this.tileSizeY = tileItem.sizeY;
            if (tileItem.touchable.booleanValue()) {
                this.setRect();
                this.touchable = true;
            } else {
                this.noRect = true;
                this.rect = null;
            }
            this.seeThrough = tileItem.seeThrough;
            if (tileItem.shadowX > -1 && tileItem.shadowY > -1) {
                this.hasShadow = true;
                this.tileTypeShadow = Animator.cutSpriteSheet(tileItem.shadowY, tileItem.shadowX, 16, false);
            }
            if (tileItem.L4PointX <= -1 || tileItem.L4PointY <= -1) continue;
            this.hasLv4 = true;
            this.tileTypeLv4 = Animator.cutSpriteSheet(tileItem.L4PointY, tileItem.L4PointX, 16, false);
        }
    }

    private void checkExplodedTile(Point mapXY) {
        if (Animator.getMapSaveItems().containsKey(this.mapNum) && Animator.getMapSaveItems().get((Object)Integer.valueOf((int)this.mapNum)).tilesExplodable.contains(mapXY)) {
            WeaponHit.explodeTile(this, false);
        }
    }

    private void checkBreakbale(int wepNum, Point mapXY) {
        System.out.println("checking map breakable");
        if (Animator.getMapSaveItems().containsKey(this.mapNum)) {
            System.out.println("checking map breakable map num " + this.mapNum + " exists");
            if (Animator.getMapSaveItems().get((Object)Integer.valueOf((int)this.mapNum)).mapBreakables[wepNum].contains(mapXY)) {
                System.out.println("checking map breakable found wepNum " + wepNum + " on tileXY " + mapXY + " mapNum " + this.mapNum);
                this.tileType = Animator.cutSpriteSheet(this.weaponBreakbaleRubble.x, this.weaponBreakbaleRubble.y, 16, false);
                this.rect = null;
                this.noRect = true;
            }
        }
    }

    private void setSecret() {
        MapMain tempMap;
        if (this.secret.equals("u")) {
            this.touchable = false;
        } else if (this.secret.equals("b")) {
            this.burnable = true;
        } else if (this.secret.equals("r")) {
            this.noRect = false;
            this.rect = new Rectangle(0, 0, 0, 0);
            this.seeThrough = false;
            this.setRect();
        } else if (this.secret.equals("y")) {
            this.noRect = false;
            this.rect = new Rectangle(0, 0, 0, 0);
            this.seeThrough = true;
            this.setRect();
        } else if (this.secret.equals("e")) {
            this.explodable = true;
            if (this.tileTag.equals("O#") && this.imgNum == 1) {
                this.caveOpeningPoint = new Point(21, 7);
            }
            this.checkExplodedTile(new Point(this.x, this.y));
        } else if (this.secret.equals("l")) {
            this.layer4 = true;
        } else if (this.secret.equals("s")) {
            this.seeThrough = false;
        } else if (this.secret.equals("a")) {
            activetileAmmo.add(this);
        } else if (this.secret.equals("h")) {
            activetileHealth.add(this);
        } else if (this.secret.equals("c")) {
            this.noRect = true;
            this.rect = null;
        } else if (this.secret.equals("B")) {
            if (this.tileTag.equals("WT")) {
                this.weaponBreakbale = 1;
                this.checkBreakbale(0, this.mapXY);
            } else if (this.tileTag.equals("WY")) {
                this.weaponBreakbale = 2;
                this.checkBreakbale(1, this.mapXY);
            } else if (this.tileTag.equals("WU")) {
                this.weaponBreakbale = 3;
                this.checkBreakbale(2, this.mapXY);
            } else if (this.tileTag.equals("WI")) {
                this.weaponBreakbale = 4;
                this.checkBreakbale(3, this.mapXY);
            } else if (this.tileTag.equals("WO")) {
                this.weaponBreakbale = 5;
                this.checkBreakbale(4, this.mapXY);
            } else if (this.tileTag.equals("WP")) {
                this.weaponBreakbale = 8;
                this.checkBreakbale(5, this.mapXY);
            }
        } else if (this.secret.equals("t")) {
            System.out.println("t loc = " + this.x + " " + this.y + " tag is " + this.tileTag + " mapnum " + this.mapNum);
            this.noRect = true;
            this.rect = null;
        } else if (this.secret.equals("S")) {
            this.soundTilePlay = true;
        }
        if (this.checkLv > 0 && Animator.getBoard().getMapMainArrayL1().size() > 0 && (tempMap = Animator.getBoard().getMapMainArrayL1().get(Animator.getBoard().getMapMainArrayL1().size() - 1)).getX() == this.x && tempMap.getY() == this.y && tempMap.getSecret().equals("u")) {
            this.touchable = false;
        }
        if (this.checkLv > 2 && Animator.getBoard().getMapMainArrayL2().size() > 0 && (tempMap = Animator.getBoard().getMapMainArrayL2().get(Animator.getBoard().getMapMainArrayL2().size() - 1)).getX() == this.x && tempMap.getY() == this.y && tempMap.getSecret().equals("u")) {
            this.touchable = false;
        }
    }

    private void createArea() {
        if (this.secret.equals("%")) {
            Animator.getBoard().getAreas().add(new Areas(this.tileTag, this));
        } else if (this.secret.equals("&")) {
            for (Areas areaAry : Animator.getBoard().getAreas()) {
                if (!areaAry.getAreaName().equals(this.tileTag)) continue;
                areaAry.setMapBR(this);
            }
        }
    }

    private void setRect() {
        if (this.tileTag.equals("W3") || this.tileTag.equals("w3")) {
            this.rectSpaceX = 0;
            this.rectSpaceY = 0;
            this.rectW = 8;
            this.rectH = 8;
        } else if (this.tileTag.equals("W1") || this.tileTag.equals("w1")) {
            this.rectSpaceX = 8;
            this.rectSpaceY = 0;
            this.rectW = 8;
            this.rectH = 8;
        } else if (this.tileTag.equals("W7") || this.tileTag.equals("w7")) {
            this.rectSpaceX = 8;
            this.rectSpaceY = 8;
            this.rectW = 8;
            this.rectH = 8;
        } else if (this.tileTag.equals("W9") || this.tileTag.equals("w9")) {
            this.rectSpaceX = 0;
            this.rectSpaceY = 8;
            this.rectW = 8;
            this.rectH = 8;
        } else if (this.tileTag.equals("fZ") || this.tileTag.equals("f<")) {
            this.rectSpaceX = 4;
            this.rectSpaceY = 0;
            this.rectW = 12;
            this.rectH = 10;
        } else if (this.tileTag.equals("fC") || this.tileTag.equals("f?")) {
            this.rectSpaceX = 0;
            this.rectSpaceY = 0;
            this.rectW = 12;
            this.rectH = 10;
        } else if (this.tileTag.equals("fQ")) {
            this.rectSpaceX = 3;
            this.rectSpaceY = 5;
            this.rectW = 13;
            this.rectH = 11;
        } else if (this.tileTag.equals("fE")) {
            this.rectSpaceX = 0;
            this.rectSpaceY = 5;
            this.rectW = 13;
            this.rectH = 11;
        } else if (this.tileTag.equals("iq") || this.tileTag.equals("iw")) {
            this.rectSpaceX = 0;
            this.rectSpaceY = 0;
            this.rectW = 16;
            this.rectH = 13;
        } else if (this.tileTag.equals("i1")) {
            this.rectSpaceX = 0;
            this.rectSpaceY = 8;
            this.rectW = 16;
            this.rectH = 8;
        } else if (this.tileTag.equals("ie")) {
            this.rectSpaceX = 4;
            this.rectSpaceY = 0;
            this.rectW = 12;
            this.rectH = 13;
        } else if (this.tileTag.equals("ir")) {
            this.rectSpaceX = 0;
            this.rectSpaceY = 0;
            this.rectW = 12;
            this.rectH = 13;
        } else if (this.tileTag.equals("i3")) {
            this.rectSpaceX = 4;
            this.rectSpaceY = 8;
            this.rectW = 12;
            this.rectH = 8;
        } else if (this.tileTag.equals("i4")) {
            this.rectSpaceX = 0;
            this.rectSpaceY = 8;
            this.rectW = 12;
            this.rectH = 8;
        } else if (this.tileTag.equals("ik") || this.tileTag.equals("ij")) {
            this.rectSpaceX = 2;
            this.rectSpaceY = 2;
            this.rectW = 12;
            this.rectH = 12;
        } else if (this.tileTag.equals("if") || this.tileTag.equals("ig")) {
            this.rectSpaceX = 4;
            this.rectSpaceY = 6;
            this.rectW = 8;
            this.rectH = 7;
        } else if (this.tileTag.equals("ih")) {
            this.rectSpaceX = 2;
            this.rectSpaceY = 6;
            this.rectW = 12;
            this.rectH = 9;
        } else if (this.tileTag.equals("ic")) {
            this.rectSpaceX = 2;
            this.rectSpaceY = 0;
            this.rectW = 12;
            this.rectH = 12;
        } else if (this.tileTag.equals("Fq")) {
            this.rectSpaceX = 3;
            this.rectSpaceY = 3;
            this.rectW = 13;
            this.rectH = 13;
        } else if (this.tileTag.equals("Fw")) {
            this.rectSpaceX = 0;
            this.rectSpaceY = 3;
            this.rectW = 13;
            this.rectH = 13;
        } else if (this.tileTag.equals("Fa")) {
            this.rectSpaceX = 3;
            this.rectSpaceY = 0;
            this.rectW = 13;
            this.rectH = 13;
        } else if (this.tileTag.equals("Fs")) {
            this.rectSpaceX = 0;
            this.rectSpaceY = 0;
            this.rectW = 13;
            this.rectH = 13;
        } else if (this.tileTag.equals("Fz")) {
            this.rectSpaceX = 0;
            this.rectSpaceY = 0;
            this.rectW = 16;
            this.rectH = 13;
        } else if (this.tileTag.equals("F7")) {
            this.rectSpaceX = 5;
            this.rectSpaceY = 7;
            this.rectW = 11;
            this.rectH = 9;
        } else if (this.tileTag.equals("F9")) {
            this.rectSpaceX = 0;
            this.rectSpaceY = 7;
            this.rectW = 11;
            this.rectH = 9;
        } else if (this.tileTag.equals("F1")) {
            this.rectSpaceX = 5;
            this.rectSpaceY = 0;
            this.rectW = 11;
            this.rectH = 14;
        } else if (this.tileTag.equals("F3")) {
            this.rectSpaceX = 0;
            this.rectSpaceY = 0;
            this.rectW = 11;
            this.rectH = 14;
        } else if (this.tileTag.equals("F8")) {
            this.rectSpaceX = 0;
            this.rectSpaceY = 7;
            this.rectW = 16;
            this.rectH = 7;
        } else if (this.tileTag.equals("F6")) {
            this.rectSpaceX = 6;
            this.rectSpaceY = 5;
            this.rectW = 4;
            this.rectH = 11;
        } else if (this.tileTag.equals("F4")) {
            this.rectSpaceX = 6;
            this.rectSpaceY = 0;
            this.rectW = 4;
            this.rectH = 16;
        } else if (this.tileTag.equals("F2")) {
            this.rectSpaceX = 6;
            this.rectSpaceY = 0;
            this.rectW = 4;
            this.rectH = 14;
        } else if (this.tileTag.equals("F5")) {
            this.rectSpaceX = 2;
            this.rectSpaceY = 7;
            this.rectW = 14;
            this.rectH = 7;
        } else if (this.tileTag.equals("F0")) {
            this.rectSpaceX = 0;
            this.rectSpaceY = 7;
            this.rectW = 14;
            this.rectH = 7;
        } else if (this.tileTag.equals("rQ")) {
            this.rectSpaceX = 0;
            this.rectSpaceY = 3;
            this.rectW = 15;
            this.rectH = 11;
        } else if (this.tileTag.equals("rr")) {
            this.rectSpaceX = 0;
            this.rectSpaceY = 3;
            this.rectW = 16;
            this.rectH = 12;
        } else if (this.tileTag.equals("rt")) {
            this.rectSpaceX = 0;
            this.rectSpaceY = 3;
            this.rectW = 15;
            this.rectH = 12;
        } else if (this.tileTag.equals("ry") || this.tileTag.equals("ri")) {
            this.rectSpaceX = 1;
            this.rectSpaceY = 4;
            this.rectW = 14;
            this.rectH = 9;
        } else if (this.tileTag.equals("ru")) {
            this.rectSpaceX = 1;
            this.rectSpaceY = 3;
            this.rectW = 14;
            this.rectH = 11;
        } else if (this.tileTag.equals("tQ")) {
            this.rectSpaceX = 3;
            this.rectSpaceY = 6;
            this.rectW = 13;
            this.rectH = 10;
        } else if (this.tileTag.equals("tW")) {
            this.rectSpaceX = 0;
            this.rectSpaceY = 6;
            this.rectW = 13;
            this.rectH = 10;
        } else if (this.tileTag.equals("tA")) {
            this.rectSpaceX = 3;
            this.rectSpaceY = 0;
            this.rectW = 13;
            this.rectH = 12;
        } else if (this.tileTag.equals("tS")) {
            this.rectSpaceX = 0;
            this.rectSpaceY = 0;
            this.rectW = 13;
            this.rectH = 12;
        } else if (this.tileTag.equals("rq")) {
            this.rectSpaceX = 3;
            this.rectSpaceY = 8;
            this.rectW = 13;
            this.rectH = 8;
        } else if (this.tileTag.equals("rw")) {
            this.rectSpaceX = 0;
            this.rectSpaceY = 8;
            this.rectW = 13;
            this.rectH = 8;
        } else if (this.tileTag.equals("ra")) {
            this.rectSpaceX = 2;
            this.rectSpaceY = 0;
            this.rectW = 14;
            this.rectH = 16;
        } else if (this.tileTag.equals("rs")) {
            this.rectSpaceX = 0;
            this.rectSpaceY = 0;
            this.rectW = 14;
            this.rectH = 16;
        } else if (this.tileTag.equals("rz")) {
            this.rectSpaceX = 2;
            this.rectSpaceY = 0;
            this.rectW = 14;
            this.rectH = 12;
        } else if (this.tileTag.equals("rx")) {
            this.rectSpaceX = 0;
            this.rectSpaceY = 0;
            this.rectW = 14;
            this.rectH = 11;
        } else if (this.tileTag.equals("rp")) {
            this.rectSpaceX = 0;
            this.rectSpaceY = 7;
            this.rectW = 16;
            this.rectH = 9;
        } else if (this.tileTag.equals("rl")) {
            this.rectSpaceX = 0;
            this.rectSpaceY = 0;
            this.rectW = 16;
            this.rectH = 11;
        } else {
            this.rectSpaceX = 0;
            this.rectSpaceY = 0;
            this.rectW = 16;
            this.rectH = 16;
        }
    }

    public Point checkCol4(int collisionDomainSize, int objX, int objY, int objRectSpaceX, int objRectSpaceY, int objRectW, int objRectH, Rectangle objRect, Boolean isHero) {
        Point point = new Point(objX, objY);
        if (isHero.booleanValue() && this.touchable && !Animator.getBoard().getHero().isHookshoting() || !isHero.booleanValue()) {
            Rectangle r = this.rect.intersection(objRect);
            Boolean XisX = false;
            Boolean YisY = false;
            Boolean vert = false;
            if (r.x == this.rect.x) {
                XisX = true;
            }
            if (r.y == this.rect.y) {
                YisY = true;
            }
            if (r.height < r.width) {
                vert = true;
            }
            int roundCorner = 5 * Animator.pixMulti;
            int pixelMove = 0;
            if (isHero.booleanValue()) {
                pixelMove = Animator.pixMulti;
            }
            if (vert.booleanValue() && YisY.booleanValue()) {
                point.y = this.rectY - (objRectSpaceY + objRectH + pixelMove);
            }
            if (vert.booleanValue() && !YisY.booleanValue()) {
                point.y = this.rectY + this.rectH - objRectSpaceY + pixelMove;
            }
            if (!vert.booleanValue() && XisX.booleanValue()) {
                point.x = this.rectX - (objRectW + objRectSpaceX + pixelMove);
            }
            if (!vert.booleanValue() && !XisX.booleanValue()) {
                point.x = this.rectX + this.rectW - (objRectSpaceX - pixelMove);
            }
            if (isHero.booleanValue()) {
                this.hero.setX(point.x);
                this.hero.setY(point.y);
                this.hero.updateRect(false);
                this.hero.updateHeroTileRect();
            }
            System.out.println("collisionDomainSize " + collisionDomainSize);
            if (collisionDomainSize == 1 && isHero.booleanValue() && (this.hero.isUp() && !this.hero.isRight() && !this.hero.isLeft() || this.hero.isDown() && !this.hero.isRight() && !this.hero.isLeft() || this.hero.isRight() && !this.hero.isDown() && !this.hero.isUp() || this.hero.isLeft() && !this.hero.isDown() && !this.hero.isUp())) {
                int hRectX = (int)this.hero.getRect().getX();
                int hRectW = (int)this.hero.getRect().getWidth();
                int hRectY = (int)this.hero.getRect().getY();
                int hRectH = (int)this.hero.getRect().getHeight();
                if ((this.hero.isLeft() || this.hero.isRight()) && hRectY < this.rect.y && hRectY + hRectH - this.rect.y <= roundCorner) {
                    this.hero.setY(this.hero.getY() - 1 * (Animator.pixMulti / 4));
                }
                if ((this.hero.isLeft() || this.hero.isRight()) && hRectY + hRectH > this.rect.y + this.rect.height && this.rect.y + this.rect.height - hRectY <= roundCorner) {
                    this.hero.setY(this.hero.getY() + 1 * (Animator.pixMulti / 4));
                }
                if ((this.hero.isUp() || this.hero.isDown()) && hRectX + hRectW > this.rect.x + this.rect.width && this.rect.x + this.rect.width - hRectX <= roundCorner) {
                    this.hero.setX(this.hero.getX() + 1 * (Animator.pixMulti / 4));
                }
                if ((this.hero.isUp() || this.hero.isDown()) && hRectX < this.rect.x && hRectX + hRectW - this.rect.x <= roundCorner) {
                    this.hero.setX(this.hero.getX() - 1 * (Animator.pixMulti / 4));
                }
            }
        }
        return point;
    }

    public void update() {
        this.mapPointCenter.x = this.x + Animator.scale / 2;
        this.mapPointCenter.y = this.y + Animator.scale / 2;
        this.getHeroDistance(0);
        this.updateRect(false);
        if (this.tileAnimated) {
            this.tileType = Animator.doAnimation(this.aniItem, this.tileTag, this);
        }
        this.onScreen = this.x + (Animator.scale + (this.tileSizeX - 1) * Animator.scale) > 0 && this.x < Animator.screenW && this.y + (Animator.scale + (this.tileSizeY - 1) * Animator.scale) > 0 && this.y < Animator.screenH;
    }

    public int[] getTile() {
        return this.tileType;
    }

    public void setTileType(int[] tileType) {
        this.tileType = tileType;
    }

    public Boolean getBurnable() {
        return this.burnable;
    }

    public Boolean getSeeThrough() {
        return this.seeThrough;
    }

    public Boolean getExplodable() {
        return this.explodable;
    }

    public Boolean getLayer4() {
        return this.layer4;
    }

    public Point getMapPoint() {
        return this.mapPoint;
    }

    public String getTileTag() {
        return this.tileTag;
    }

    public Boolean getIgnorHookhot() {
        return this.ignorHookhot;
    }

    public boolean isOnScreen() {
        return this.onScreen;
    }

    public boolean isBulletsOnTop() {
        return this.bulletsOnTop;
    }

    public static ArrayList<MapMain> getActivetileAmmo() {
        return activetileAmmo;
    }

    public static ArrayList<MapMain> getActivetileHealth() {
        return activetileHealth;
    }

    public String getSecret() {
        return this.secret;
    }

    public boolean isHasLv4() {
        return this.hasLv4;
    }

    public int[] getTileTypeLv4() {
        return this.tileTypeLv4;
    }

    public boolean isHasShadow() {
        return this.hasShadow;
    }

    public boolean isShadowOnly() {
        return this.shadowOnly;
    }

    public int[] getTileTypeShadow() {
        return this.tileTypeShadow;
    }

    public int getWeaponBreakbale() {
        return this.weaponBreakbale;
    }

    public Point getWeaponBreakbaleRubble() {
        return this.weaponBreakbaleRubble;
    }

    public Point getCaveOpeningPoint() {
        return this.caveOpeningPoint;
    }

    public Point getMapXY() {
        return this.mapXY;
    }

    public int getImgNum() {
        return this.imgNum;
    }

    public int getTileSizeX() {
        return this.tileSizeX;
    }

    public int getTileSizeY() {
        return this.tileSizeY;
    }

    public static HashMap<MapMain, Float> getHeroDistanceTileSound() {
        return heroDistanceTileSound;
    }

    public void setOnScreen(boolean onScreen) {
        this.onScreen = onScreen;
    }
}

