/*
 * Decompiled with CFR 0.152.
 */
package Engine;

import Engine.Animator;
import java.awt.Image;
import java.awt.Rectangle;

public class Sprite {
    protected int x;
    protected int y;
    protected int spriteType;
    protected int rectSpaceX = 0;
    protected int rectSpaceY = 0;
    protected int rectX = 0;
    protected int rectY = 0;
    protected int rectW = 0;
    protected int rectH = 0;
    protected int rectXW = 0;
    protected int rectYH = 0;
    protected boolean visible = true;
    protected boolean touchable = true;
    protected boolean noRect = false;
    protected boolean removeSprite = false;
    protected Image spriteImg;
    protected int[] spriteLoc;
    protected Rectangle rect = new Rectangle(0, 0, 0, 0);

    public Sprite(int x, int y) {
        this.x = x;
        this.y = y;
    }

    public Sprite(int x, int y, boolean visible, boolean touchable, boolean noRect, Image spriteImage, int[] spriteLoc) {
        this.x = x;
        this.y = y;
        this.visible = visible;
        this.touchable = touchable;
        this.noRect = noRect;
        this.spriteImg = spriteImage;
        this.spriteLoc = spriteLoc;
    }

    public void updateRect(boolean byRect) {
        if (!this.noRect) {
            if (byRect) {
                this.x = this.rectX - this.rectSpaceX;
                this.y = this.rectY - this.rectSpaceY;
            } else {
                this.rectX = this.x + this.rectSpaceX;
                this.rectY = this.y + this.rectSpaceY;
            }
            this.rectXW = this.rectX + this.rectW;
            this.rectYH = this.rectY + this.rectH;
            this.rect.setBounds(this.rectX, this.rectY, this.rectW, this.rectH);
        }
    }

    public void updateRect(boolean byXRect, boolean byYRect) {
        if (!this.noRect) {
            if (byXRect) {
                this.x = this.rectX - this.rectSpaceX;
            } else {
                this.rectX = this.x + this.rectSpaceX;
            }
            if (byYRect) {
                this.y = this.rectY - this.rectSpaceY;
            } else {
                this.rectY = this.y + this.rectSpaceY;
            }
            this.rectXW = this.rectX + this.rectW;
            this.rectYH = this.rectY + this.rectH;
            this.rect.setBounds(this.rectX, this.rectY, this.rectW, this.rectH);
        }
    }

    public void setScalers() {
        this.rectW *= Animator.pixMulti;
        this.rectH *= Animator.pixMulti;
        this.rectSpaceX *= Animator.pixMulti;
        this.rectSpaceY *= Animator.pixMulti;
    }

    protected short getCollisionDir(Rectangle r) {
        Boolean XisX = false;
        Boolean YisY = false;
        Boolean vert = false;
        if (r.x == this.rect.x) {
            XisX = true;
        }
        if (r.y == this.rect.y) {
            YisY = true;
        }
        if (r.height < r.width) {
            vert = true;
        }
        if (vert.booleanValue() && YisY.booleanValue()) {
            return 3;
        }
        if (vert.booleanValue() && !YisY.booleanValue()) {
            return 1;
        }
        if (!vert.booleanValue() && XisX.booleanValue()) {
            return 2;
        }
        if (!vert.booleanValue() && !XisX.booleanValue()) {
            return 4;
        }
        return 0;
    }

    public int getRectXW() {
        return this.rectXW;
    }

    public int getRectYH() {
        return this.rectYH;
    }

    public int getRectX() {
        return this.rectX;
    }

    public void setRectX(int rectX) {
        this.rectX = rectX;
    }

    public int getRectY() {
        return this.rectY;
    }

    public void setRectY(int rectY) {
        this.rectY = rectY;
    }

    public int getRectW() {
        return this.rectW;
    }

    public void setRectW(int rectW) {
        this.rectW = rectW;
    }

    public int getRectH() {
        return this.rectH;
    }

    public void setRectH(int rectH) {
        this.rectH = rectH;
    }

    public int getRectSpaceX() {
        return this.rectSpaceX;
    }

    public void setRectSpaceX(int rectSpaceX) {
        this.rectSpaceX = rectSpaceX;
    }

    public int getRectSpaceY() {
        return this.rectSpaceY;
    }

    public void setRectSpaceY(int rectSpaceY) {
        this.rectSpaceY = rectSpaceY;
    }

    public int getX() {
        return this.x;
    }

    public void setX(int x) {
        this.x = x;
        this.updateRect(false);
    }

    public int getY() {
        return this.y;
    }

    public void setY(int y) {
        this.y = y;
        this.updateRect(false);
    }

    public Rectangle getRect() {
        return this.rect;
    }

    public boolean isTouchable() {
        return this.touchable;
    }

    public boolean isNoRect() {
        return this.noRect;
    }

    public void setNoRect(boolean noRect) {
        this.noRect = noRect;
    }

    public void setRect(Rectangle rect) {
        this.rect = rect;
    }
}

