/*
 * Decompiled with CFR 0.152.
 */
package enemiesClass;

import Engine.Animator;
import Engine.Board;
import Engine.MapMain;
import enemiesClass.AstarNode2;
import enemiesClass.AstarQueueNode;
import enemiesClass.Enemies;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.PriorityQueue;
import java.util.Queue;

public class Astar4 {
    private Point nodeStart;
    private Point nodeEnd;
    private AstarNode2 astarEnd;
    private AstarNode2 astarStart;
    private int astarMinX;
    private int astarMinY;
    private Enemies enemy;
    private boolean diag;
    private boolean isPath;
    private ArrayList<Point> pathToEnd = new ArrayList();
    private int sightDistance;
    private int sightDistanceOG;
    private Point heroCent = Board.findCenter(Animator.getBoard().getHero().getRect());
    private Queue<AstarQueueNode> openSet;
    private AstarNode2[][] grid2;
    private Comparator<AstarQueueNode> nodeComparator = new Comparator<AstarQueueNode>(){

        @Override
        public int compare(AstarQueueNode a1, AstarQueueNode a2) {
            return a1.getPathF() - a2.getPathF();
        }
    };

    public Astar4(MapMain nodeStart, MapMain nodeEnd, Enemies enemy, boolean diag) {
        this.nodeEnd = nodeEnd.getMapPoint();
        this.nodeStart = nodeStart.getMapPoint();
        this.enemy = enemy;
        this.diag = diag;
        this.sightDistanceOG = enemy.sightAttackRange;
        this.grid2 = new AstarNode2[this.sightDistanceOG * 2 + 1][this.sightDistanceOG * 2 + 1];
        this.sightDistance = enemy.sightAttackRange * Animator.scale;
        this.openSet = new PriorityQueue<AstarQueueNode>(11, this.nodeComparator);
        this.makeNodes();
        this.isPath = this.findPath();
    }

    private void makeNodes() {
        boolean foundMins = false;
        Point heroMapPoint = Animator.getBoard().getMapFromPoint(this.heroCent).getMapPoint();
        for (MapMain map : Animator.getBoard().getMapAstarDomain()) {
            if (heroMapPoint.x + this.sightDistanceOG < map.getMapPoint().x || heroMapPoint.x - this.sightDistanceOG > map.getMapPoint().x || heroMapPoint.y + this.sightDistanceOG < map.getMapPoint().y || heroMapPoint.y - this.sightDistanceOG > map.getMapPoint().y) continue;
            if (!foundMins) {
                this.astarMinX = map.getMapPoint().x;
                this.astarMinY = map.getMapPoint().y;
                foundMins = true;
            }
            if (map.getRect() != null) continue;
            AstarNode2 tempNode = new AstarNode2(map.getMapPoint(), map.getX(), map.getY());
            if (map.getMapPoint().x == this.nodeStart.x && map.getMapPoint().y == this.nodeStart.y) {
                this.astarStart = tempNode;
                this.astarStart.setPathG(0);
                this.setHvlaue(this.astarStart);
                this.openSet.add(new AstarQueueNode(this.astarStart.getMapPoint(), this.astarStart.getPathG() + this.astarStart.getPathH()));
            }
            if (map.getMapPoint().x == this.nodeEnd.x && map.getMapPoint().y == this.nodeEnd.y) {
                this.astarEnd = tempNode;
                this.astarEnd.setPathH(0);
            }
            this.grid2[map.getMapPoint().x - this.astarMinX][map.getMapPoint().y - this.astarMinY] = tempNode;
        }
    }

    private void setHvlaue(AstarNode2 anode) {
        anode.setPathH(this.getDistance(anode.getMapPoint(), this.nodeEnd));
    }

    private boolean findPath() {
        while (!this.openSet.isEmpty()) {
            AstarQueueNode queueNode = this.openSet.poll();
            AstarNode2 currentNode = this.grid2[queueNode.getMapPoint().x - this.astarMinX][queueNode.getMapPoint().y - this.astarMinY];
            currentNode.setInClosed(true);
            if (currentNode.equals(this.astarEnd)) {
                this.makePathToEnd();
                return true;
            }
            AstarNode2[] astarNode2Array = this.findNeighbors(currentNode);
            int n = astarNode2Array.length;
            int n2 = 0;
            while (n2 < n) {
                AstarNode2 map = astarNode2Array[n2];
                if (map != null) {
                    Point mapCent = Animator.getBoard().findMapTileCenter(map.getX(), map.getY());
                    if (Animator.getBoard().isRectInTile(map.getMapPoint())) {
                        map.setInClosed(true);
                    } else if (mapCent.x > this.enemy.mapAreaBR.getX() + Animator.scale || mapCent.x < this.enemy.mapAreaTL.getX() || mapCent.y > this.enemy.mapAreaBR.getY() + Animator.scale || mapCent.y < this.enemy.mapAreaTL.getY()) {
                        map.setInClosed(true);
                    } else if (mapCent.x > Animator.screenW + Animator.scale || mapCent.x < -Animator.scale || mapCent.y > Animator.screenH + Animator.scale || mapCent.y < 0) {
                        map.setInClosed(true);
                    } else if (!this.checkRange(mapCent)) {
                        map.setInClosed(true);
                    } else {
                        int tempG = currentNode.getPathG() + this.getDistance(currentNode.getMapPoint(), map.getMapPoint());
                        if (tempG < map.getPathG()) {
                            if (map.getPathG() == Integer.MAX_VALUE) {
                                this.setHvlaue(map);
                            }
                            map.setPathG(tempG);
                            map.setPathParent(currentNode);
                            this.openSet.add(new AstarQueueNode(map.getMapPoint(), map.getPathG() + map.getPathH()));
                        }
                    }
                }
                ++n2;
            }
        }
        return false;
    }

    private AstarNode2[] findNeighbors(AstarNode2 node) {
        int neighborCount = 4;
        if (this.diag) {
            neighborCount = 8;
        }
        AstarNode2[] maps = new AstarNode2[neighborCount];
        int index = 0;
        int ix = -1;
        while (ix < 2) {
            int iy = -1;
            while (iy < 2) {
                if (!(ix == 0 && iy == 0 || node.getMapPoint().x - this.astarMinX + ix < 0 || node.getMapPoint().x - this.astarMinX + ix >= this.sightDistanceOG * 2 + 1 || node.getMapPoint().y - this.astarMinY + iy < 0 || node.getMapPoint().y - this.astarMinY + iy >= this.sightDistanceOG * 2 + 1 || this.grid2[node.getMapPoint().x - this.astarMinX + ix][node.getMapPoint().y - this.astarMinY + iy] == null || this.grid2[node.getMapPoint().x - this.astarMinX + ix][node.getMapPoint().y - this.astarMinY + iy].isInClosed())) {
                    if (ix == 0 || iy == 0) {
                        maps[index] = this.grid2[node.getMapPoint().x - this.astarMinX + ix][node.getMapPoint().y - this.astarMinY + iy];
                        ++index;
                    } else if (this.diag) {
                        maps[index] = this.grid2[node.getMapPoint().x - this.astarMinX + ix][node.getMapPoint().y - this.astarMinY + iy];
                        ++index;
                    }
                }
                ++iy;
            }
            ++ix;
        }
        return maps;
    }

    private void makePathToEnd() {
        AstarNode2 nodeCurrent = this.astarEnd;
        this.pathToEnd.add(new Point(nodeCurrent.getX(), nodeCurrent.getY()));
        while (!nodeCurrent.equals(this.astarStart)) {
            nodeCurrent = nodeCurrent.getPathParent();
            this.pathToEnd.add(new Point(nodeCurrent.getX(), nodeCurrent.getY()));
        }
        Collections.reverse(this.pathToEnd);
    }

    private boolean checkRange(Point point) {
        return this.heroCent.y > point.y - this.sightDistance && this.heroCent.y < point.y + this.sightDistance && this.heroCent.x > point.x - this.sightDistance && this.heroCent.x < point.x + this.sightDistance;
    }

    private int getDistance(Point map1, Point map2) {
        int distY;
        int distX = Math.abs(map1.x - map2.x);
        if (distX > (distY = Math.abs(map1.y - map2.y))) {
            return 14 * distY + 10 * (distX - distY);
        }
        return 14 * distX + 10 * (distY - distX);
    }

    public boolean isPath() {
        return this.isPath;
    }

    public ArrayList<Point> getPathToEnd() {
        return this.pathToEnd;
    }
}

