/*
 * Decompiled with CFR 0.152.
 */
package pickups;

import Engine.Animator;
import Engine.Font2;
import exceptions.GameException;
import java.awt.Point;
import pickups.Items;

public class PickUpHealth
extends Items {
    private int HP;
    private int soundCounter = -1;
    private int soundTick = 2;

    public PickUpHealth(int x, int y, int size) {
        super(x, y);
        this.setSize(size);
        this.hookable = 1;
        this.imageNum = 0;
        this.updateRect();
    }

    public PickUpHealth(int x, int y, int size, Boolean perm, Point itemXY) {
        super(x, y, perm, itemXY);
        this.setSize(size);
        this.imageNum = 0;
    }

    public PickUpHealth(int size) {
        super(Animator.getBoard().getHero().getX(), Animator.getBoard().getHero().getY());
        int[] nArray = new int[4];
        nArray[2] = 16;
        nArray[3] = 16;
        this.imageLoc = nArray;
        this.HP = size;
        this.setRects();
        System.out.println("making health size = " + size);
    }

    public void playSound() {
        if (!Animator.getBoard().clipGetHealth.isRunning() && Animator.playsouds.booleanValue()) {
            Animator.getBoard().clipGetHealth.setFramePosition(0);
            Animator.getBoard().clipGetHealth.start();
        }
    }

    @Override
    public void updateItem() {
        Boolean keepGoing = true;
        int i = 0;
        while (i < Animator.getBoard().itemsArray.size()) {
            Animator.getBoard().getHero().setCurrentCoiningItem(Animator.getBoard().itemsArray.indexOf(this));
            if (Animator.getBoard().itemsArray.get(i).getClass().isAssignableFrom(this.getClass()) && Animator.getBoard().itemsArray.get(i).getIsActive().booleanValue() && !Animator.getBoard().itemsArray.get(i).equals(this)) {
                keepGoing = false;
            }
            ++i;
        }
        if (Animator.getBoard().getHero().getHP() >= Animator.getBoard().getHero().getMaxHP()) {
            keepGoing = false;
            this.remove = true;
        }
        if (keepGoing.booleanValue()) {
            this.isActive = true;
            if (this.soundCounter > 0) {
                --this.soundCounter;
            }
            if (this.soundCounter % this.soundTick == 0) {
                this.playSound();
                Animator.getBoard().getHero().setHP(Animator.getBoard().getHero().getHP() + 1);
                Animator.getBoard().getHero().checkHP();
            }
            if (this.soundCounter == 0) {
                this.remove = true;
            }
        }
    }

    @Override
    public void useItem() {
        System.out.println("Heal HP = " + this.HP);
        int missingHP = Animator.getBoard().getHero().getMaxHP() - Animator.getBoard().getHero().getHP();
        System.out.println("Heal HP = " + this.HP + " missingHP " + missingHP);
        if (this.HP > missingHP) {
            this.HP = missingHP;
        }
        this.soundCounter = this.HP * this.soundTick;
        this.visible = false;
        this.touchable = false;
        if (Animator.getBoard().getHero().getHP() >= Animator.getBoard().getHero().getMaxHP()) {
            System.out.println("play sound");
            this.playSound();
            this.remove = true;
        } else {
            this.lasting = true;
        }
        if (this.HP > 0) {
            String HPStr = "+" + String.valueOf(this.HP);
            Animator.getBoard().fontArray.add(new Font2(HPStr, "green", Animator.getBoard().getHero(), 90));
        }
    }

    private void setSize(int size) {
        this.HP = size;
        if (size == 3) {
            int[] nArray = new int[4];
            nArray[2] = 16;
            nArray[3] = 16;
            this.imageLoc = nArray;
        } else if (size == 9) {
            int[] nArray = new int[4];
            nArray[0] = 16;
            nArray[2] = 32;
            nArray[3] = 16;
            this.imageLoc = nArray;
        } else if (size == 15) {
            int[] nArray = new int[4];
            nArray[0] = 32;
            nArray[2] = 48;
            nArray[3] = 16;
            this.imageLoc = nArray;
        } else if (size == 30) {
            int[] nArray = new int[4];
            nArray[0] = 48;
            nArray[2] = 64;
            nArray[3] = 16;
            this.imageLoc = nArray;
        } else if (size == 45) {
            int[] nArray = new int[4];
            nArray[1] = 16;
            nArray[2] = 16;
            nArray[3] = 32;
            this.imageLoc = nArray;
        } else if (size == 60) {
            this.imageLoc = new int[]{16, 16, 32, 32};
        } else if (size == 75) {
            this.imageLoc = new int[]{32, 16, 48, 32};
        } else if (size == 90) {
            this.imageLoc = new int[]{48, 16, 64, 32};
        } else if (size == 105) {
            this.imageLoc = new int[]{48, 16, 64, 32};
        } else if (size == 120) {
            int[] nArray = new int[4];
            nArray[1] = 32;
            nArray[2] = 16;
            nArray[3] = 48;
            this.imageLoc = nArray;
        } else if (size == 150) {
            this.imageLoc = new int[]{16, 32, 32, 48};
        } else if (size == 225) {
            this.imageLoc = new int[]{32, 32, 48, 48};
        } else if (size == 300) {
            this.imageLoc = new int[]{48, 32, 64, 48};
        } else if (size == 360) {
            this.imageLoc = new int[]{48, 32, 64, 48};
        } else {
            throw new GameException("PickUpHelath does not support size of: " + size);
        }
        this.setRects();
    }

    private void setRects() {
        this.rectSpaceX = 1 * Animator.pixMulti;
        this.rectSpaceY = 1 * Animator.pixMulti;
        this.rectW = 14 * Animator.pixMulti;
        this.rectH = 14 * Animator.pixMulti;
    }
}

