/*
 * Decompiled with CFR 0.152.
 */
package weapons;

import Engine.Animator;
import Engine.MapMain;
import enemiesClass.Enemies;
import java.awt.Point;
import weapons.WeaponHit;

public class slimeAttack1
extends WeaponHit {
    String type;
    Enemies sourceEnemy;
    WeaponHit mainHead;
    Boolean goingBack = false;
    short order;
    boolean attackCompleted = false;

    public slimeAttack1(int x, int y, int damage, int durraiton, short direction, Boolean attached, String type, Enemies sourceEnemy, short order, int speed, WeaponHit mainHead, short imgNum) {
        super(x, y);
        this.heroHit = true;
        this.active = true;
        this.fromEnemy = true;
        this.wepNum = 101;
        this.wepType = "slime";
        this.imgNum = imgNum;
        this.damage = damage;
        this.durration = durraiton * Animator.scale / 2;
        this.direction = direction;
        this.type = type;
        this.sourceEnemy = sourceEnemy;
        this.mainHead = mainHead;
        this.speed = speed * Animator.pixMulti;
        this.order = order;
        this.createRect();
        if (order == 0) {
            this.playSound();
        }
    }

    private void createRect() {
        int pixMulti = Animator.pixMulti;
        int imgSize = 16;
        Point spriteLoc = new Point(0, 0);
        Boolean reverse = false;
        if (this.type == "slimeBlueHead") {
            switch (this.direction) {
                case 1: {
                    spriteLoc = new Point(3, 5);
                    this.rectSpaceX = 5 * pixMulti;
                    this.rectSpaceY = 2 * pixMulti;
                    this.rectW = 6 * pixMulti;
                    this.rectH = 2 * pixMulti;
                    break;
                }
                case 2: {
                    spriteLoc = new Point(2, 5);
                    reverse = true;
                    this.rectSpaceX = 0 * pixMulti;
                    this.rectSpaceY = 6 * pixMulti;
                    this.rectW = 5 * pixMulti;
                    this.rectH = 3 * pixMulti;
                    break;
                }
                case 3: {
                    spriteLoc = new Point(1, 5);
                    this.rectSpaceX = 5 * pixMulti;
                    this.rectSpaceY = 12 * pixMulti;
                    this.rectW = 6 * pixMulti;
                    this.rectH = 2 * pixMulti;
                    break;
                }
                case 4: {
                    spriteLoc = new Point(2, 5);
                    this.rectSpaceX = 11 * pixMulti;
                    this.rectSpaceY = 6 * pixMulti;
                    this.rectW = 5 * pixMulti;
                    this.rectH = 3 * pixMulti;
                }
            }
        } else if (this.type == "slimeRedHead") {
            switch (this.direction) {
                case 1: {
                    spriteLoc = new Point(3, 5);
                    this.rectSpaceX = 4 * pixMulti;
                    this.rectSpaceY = 0 * pixMulti;
                    this.rectW = 8 * pixMulti;
                    this.rectH = 3 * pixMulti;
                    break;
                }
                case 2: {
                    spriteLoc = new Point(2, 5);
                    reverse = true;
                    this.rectSpaceX = 0 * pixMulti;
                    this.rectSpaceY = 7 * pixMulti;
                    this.rectW = 7 * pixMulti;
                    this.rectH = 5 * pixMulti;
                    break;
                }
                case 3: {
                    spriteLoc = new Point(1, 5);
                    this.rectSpaceX = 4 * pixMulti;
                    this.rectSpaceY = 13 * pixMulti;
                    this.rectW = 8 * pixMulti;
                    this.rectH = 3 * pixMulti;
                    break;
                }
                case 4: {
                    spriteLoc = new Point(2, 5);
                    this.rectSpaceX = 9 * pixMulti;
                    this.rectSpaceY = 7 * pixMulti;
                    this.rectW = 7 * pixMulti;
                    this.rectH = 5 * pixMulti;
                }
            }
        }
        if (this.type == "slimeBlueNeck") {
            switch (this.direction) {
                case 1: {
                    spriteLoc = new Point(3, 6);
                    this.rectSpaceX = 6 * pixMulti;
                    this.rectSpaceY = 4 * pixMulti;
                    this.rectW = 4 * pixMulti;
                    this.rectH = 8 * pixMulti;
                    break;
                }
                case 2: {
                    spriteLoc = new Point(2, 6);
                    reverse = true;
                    this.rectSpaceX = 8 * pixMulti;
                    this.rectSpaceY = 6 * pixMulti;
                    this.rectW = 8 * pixMulti;
                    this.rectH = 3 * pixMulti;
                    break;
                }
                case 3: {
                    spriteLoc = new Point(1, 6);
                    this.rectSpaceX = 6 * pixMulti;
                    this.rectSpaceY = 4 * pixMulti;
                    this.rectW = 4 * pixMulti;
                    this.rectH = 8 * pixMulti;
                    break;
                }
                case 4: {
                    spriteLoc = new Point(2, 6);
                    this.rectSpaceX = 0 * pixMulti;
                    this.rectSpaceY = 6 * pixMulti;
                    this.rectW = 8 * pixMulti;
                    this.rectH = 3 * pixMulti;
                }
            }
        } else if (this.type == "slimeRedNeck") {
            switch (this.direction) {
                case 1: {
                    spriteLoc = new Point(3, 6);
                    this.rectSpaceX = 6 * pixMulti;
                    this.rectSpaceY = 4 * pixMulti;
                    this.rectW = 4 * pixMulti;
                    this.rectH = 8 * pixMulti;
                    break;
                }
                case 2: {
                    spriteLoc = new Point(2, 6);
                    reverse = true;
                    this.rectSpaceX = 8 * pixMulti;
                    this.rectSpaceY = 6 * pixMulti;
                    this.rectW = 8 * pixMulti;
                    this.rectH = 3 * pixMulti;
                    break;
                }
                case 3: {
                    spriteLoc = new Point(1, 6);
                    this.rectSpaceX = 6 * pixMulti;
                    this.rectSpaceY = 4 * pixMulti;
                    this.rectW = 4 * pixMulti;
                    this.rectH = 8 * pixMulti;
                    break;
                }
                case 4: {
                    spriteLoc = new Point(2, 6);
                    this.rectSpaceX = 0 * pixMulti;
                    this.rectSpaceY = 6 * pixMulti;
                    this.rectW = 8 * pixMulti;
                    this.rectH = 3 * pixMulti;
                }
            }
        }
        this.imgLocation = Animator.convertIntAryToShort(Animator.cutSpriteSheet(spriteLoc.x, spriteLoc.y, imgSize, reverse));
        this.updateRect(false);
    }

    @Override
    public void update() {
        if (this.active.booleanValue()) {
            boolean byXRect = false;
            boolean byYRect = false;
            if (this.type.contains("slime") && this.type.contains("Head")) {
                MapMain checkMapCol;
                if (!this.attackCompleted) {
                    switch (this.direction) {
                        case 1: {
                            byYRect = true;
                            this.x = this.sourceEnemy.getX();
                            this.rectY = this.sourceEnemy.getRectY() - this.rectH - this.speed * this.wepAttackCounter;
                            this.updateRect(byXRect, byYRect);
                            if (this.rectY < this.sourceEnemy.getRectY() - this.durration) {
                                this.rectY = this.sourceEnemy.getRectY() - this.durration;
                                this.goingBack = true;
                            }
                            if (!this.goingBack.booleanValue() || this.rectYH <= this.sourceEnemy.getRectY()) break;
                            this.attackCompleted = true;
                            this.goingBack = false;
                            break;
                        }
                        case 2: {
                            byXRect = true;
                            this.rectX = this.sourceEnemy.getRectXW() + this.speed * this.wepAttackCounter;
                            this.y = this.sourceEnemy.getY();
                            this.updateRect(byXRect, byYRect);
                            if (this.rectXW > this.sourceEnemy.getRectXW() + this.durration) {
                                this.rectX = this.sourceEnemy.getRectXW() + (this.durration - this.rectW);
                                this.goingBack = true;
                            }
                            if (!this.goingBack.booleanValue() || this.rectX >= this.sourceEnemy.getRectXW()) break;
                            this.attackCompleted = true;
                            this.goingBack = false;
                            break;
                        }
                        case 3: {
                            byYRect = true;
                            this.x = this.sourceEnemy.getX();
                            this.rectY = this.sourceEnemy.getRectYH() + this.speed * this.wepAttackCounter;
                            this.updateRect(byXRect, byYRect);
                            if (this.rectYH > this.sourceEnemy.getRectYH() + this.durration) {
                                this.rectY = this.sourceEnemy.getRectYH() + (this.durration - this.rectH);
                                this.goingBack = true;
                            }
                            if (!this.goingBack.booleanValue() || this.rectY >= this.sourceEnemy.getRectYH()) break;
                            this.attackCompleted = true;
                            this.goingBack = false;
                            break;
                        }
                        case 4: {
                            this.rectX = this.sourceEnemy.getRectX() - this.speed * this.wepAttackCounter;
                            this.y = this.sourceEnemy.getY();
                            byXRect = true;
                            this.updateRect(byXRect, byYRect);
                            if (this.rectX < this.sourceEnemy.getRectX() - this.durration) {
                                this.rectX = this.sourceEnemy.getRectX() - this.durration;
                                this.goingBack = true;
                            }
                            if (!this.goingBack.booleanValue() || this.rectXW <= this.sourceEnemy.getRectX()) break;
                            this.attackCompleted = true;
                            this.goingBack = false;
                        }
                    }
                }
                if ((checkMapCol = this.collision()) != null && !this.goingBack.booleanValue()) {
                    this.goingBack = true;
                    switch (this.direction) {
                        case 1: {
                            this.rectY = checkMapCol.getRectYH();
                            break;
                        }
                        case 2: {
                            this.rectX = checkMapCol.getRectX() - this.rectXW;
                            break;
                        }
                        case 3: {
                            this.rectY = checkMapCol.getRectY() - this.rectYH;
                            break;
                        }
                        case 4: {
                            this.rectX = checkMapCol.getRectXW();
                        }
                    }
                }
                this.wepAttackCounter = !this.goingBack.booleanValue() ? ++this.wepAttackCounter : --this.wepAttackCounter;
                if (this.attackCompleted) {
                    this.x = this.direction == 2 ? this.sourceEnemy.getX() + Animator.scale - this.rectW : (this.direction == 4 ? this.sourceEnemy.getX() - Animator.scale + this.rectW : this.sourceEnemy.getX());
                    this.y = this.sourceEnemy.getY();
                    this.updateRect(false);
                    this.sourceEnemy.setIsAttackAlert(true);
                }
                if (this.attackCompleted && this.wepAttackCounter >= this.sourceEnemy.getAttackPostPause()) {
                    System.out.println("removing slime attack " + this.type + " order = " + this.order);
                    this.sourceEnemy.setAttacking(false);
                    this.sourceEnemy.stopAttack();
                    this.remove = true;
                    this.sourceEnemy.setAttackPause(0);
                }
            }
            if (this.type.contains("slime") && this.type.contains("Neck")) {
                int headX = this.mainHead.getRectX();
                int headXW = this.mainHead.getRectXW();
                int headY = this.mainHead.getRectY();
                int headYH = this.mainHead.getRectYH();
                this.x = this.sourceEnemy.getX();
                this.y = this.sourceEnemy.getY();
                this.updateRect(false);
                switch (this.direction) {
                    case 1: {
                        if (headYH >= this.sourceEnemy.getRectY() - this.rectH * (this.order - 1)) break;
                        this.rectY = headYH + (this.order - 1) * this.rectH;
                        break;
                    }
                    case 2: {
                        if (headX <= this.sourceEnemy.getRectXW() + this.rectW * (this.order - 1)) break;
                        this.rectX = headX - this.order * this.rectW;
                        break;
                    }
                    case 3: {
                        if (headY <= this.sourceEnemy.getRectYH() + this.rectH * (this.order - 1)) break;
                        this.rectY = headY - this.order * this.rectH;
                        break;
                    }
                    case 4: {
                        if (headXW >= this.sourceEnemy.getRectX() - this.rectW * (this.order - 1)) break;
                        this.rectX = headXW + (this.order - 1) * this.rectW;
                    }
                }
                if (this.mainHead == null || this.mainHead.remove.booleanValue()) {
                    this.remove = true;
                }
                this.updateRect(true);
            }
            this.updateRect(byXRect, byYRect);
            this.getHitCounter = this.sourceEnemy.getHitCounter();
        }
    }

    private void playSound() {
        if (Animator.getBoard().getClipWepSlimeAttack1().isRunning()) {
            Animator.getBoard().getClipWepSlimeAttack1().stop();
        }
        Animator.getBoard().getClipWepSlimeAttack1().setFramePosition(0);
        Animator.getBoard().getClipWepSlimeAttack1().start();
    }
}

